/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.odt.readOdt;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.vishia.genJavaOutClass.GenJavaOutClass;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.LogMessageStream;
import org.vishia.odt.readOdt.StyleImg;
import org.vishia.odt.readOdt.StyleOdt;
import org.vishia.odt.readOdt.TranslateOdtCommon;
import org.vishia.odt.readOdt.WriteOdt;
import org.vishia.util.Arguments;
import org.vishia.util.Debugutil;
import org.vishia.util.ExcUtil;
import org.vishia.util.FileFunctions;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringFunctions_C;
import org.vishia.xmlReader.GenXmlCfgJavaData;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlDataNode;
import org.vishia.xmlReader.XmlJzCfgAnalyzer;
import org.vishia.xmlReader.XmlJzReader;

public class ReadOdt
extends TranslateOdtCommon {
    public static final String version = "2025-10-10";
    private final CmdArgs cmdArgs;
    private XmlCfg xmlCfgOdt = new XmlCfg(true);
    private Map<String, StyleOdt> idxDirectToStyle = new TreeMap<String, StyleOdt>();
    private Map<String, StyleImg> idxImgDirectToStyle = new TreeMap<String, StyleImg>();
    private Map<String, StyleOdt> idxIndirectStyle = new TreeMap<String, StyleOdt>();
    private Map<String, String> idxDirectOnlyStyle = new TreeMap<String, String>();
    private Map<String, String> idxUsedStyles = new TreeMap<String, String>();
    private Map<String, String> idxStyleToShort = new TreeMap<String, String>();
    private Map<String, String> idxShortToStyle = new TreeMap<String, String>();
    private Map<String, LabelRef> idxLabelRef = new TreeMap<String, LabelRef>();
    private List<LabelRef> listLabelRef = new LinkedList<LabelRef>();
    private int ctLabel = 0;
    private XmlDataNode nodeDirectStyles;
    private XmlDataNode nodeText;
    private List<XmlDataNode> listNdTitle = new LinkedList<XmlDataNode>();
    private StyleOdt styleP;
    private String sRefBookmark;
    private String sRefChapter;
    private boolean bIsInclude = false;
    private boolean bTitleFound = false;
    private boolean bInCodeBlock;
    private boolean bInColumns;
    private String lastHlinkPathToReplaced = null;
    private String lastXref = null;
    private StringBuilder sb = new StringBuilder(4096);
    private StringBuilder sba = new StringBuilder(4096);
    IllegalArgumentException excTOCnotUpdated = new IllegalArgumentException("Table of contents not updated");
    private Writer wrFrame;
    private Writer wr;
    private Writer wra;
    private Writer wrRep;
    static String sIndent = "\n                ";
    static final String[] sNewlineCheck = new String[]{"\n", ". "};
    static final String[] sNewlineCheckBack = new String[]{" :: ", ", ", ": ", " and", " ", ". ", "\n"};
    static String[][] sCheckReplace = new String[WriteOdt.sTextCtrlCommon.length + WriteOdt.sTextReplace.length][];

    public static int amain(CmdArgs cmdArgs) throws IOException {
        ReadOdt readOdt = new ReadOdt(cmdArgs);
        int n = readOdt.execute();
        readOdt.log.close();
        return n;
    }

    public static int smain(String[] stringArray, Appendable appendable, Appendable appendable2) throws IOException {
        CmdArgs cmdArgs = new CmdArgs();
        if (stringArray.length == 0) {
            cmdArgs.showHelp(appendable);
            return 1;
        }
        if (!cmdArgs.parseArgs(stringArray, appendable2) || !cmdArgs.testConsistence(appendable2)) {
            return 2;
        }
        int n = ReadOdt.amain(cmdArgs);
        if (n != 0) {
            System.out.printf(" EXIT-code=%d", n);
        }
        System.out.println();
        return n;
    }

    public static void main(String[] stringArray) {
        try {
            int n = ReadOdt.smain(stringArray, System.out, System.err);
            System.exit(n);
        }
        catch (Exception exception) {
            System.err.println("Unexpected: " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(255);
        }
    }

    public ReadOdt(CmdArgs cmdArgs) throws IllegalCharsetNameException, UnsupportedCharsetException {
        super((LogMessage)new LogMessageStream(cmdArgs.fLog, null, (Appendable)System.out, (Appendable)System.err, true, Charset.defaultCharset()));
        this.cmdArgs = cmdArgs;
        this.idxStyleToShort.put("ccode-Java", "cJava");
        this.idxStyleToShort.put("Text_20_body", "pStd");
        this.idxStyleToShort.put("List1Left", "*li1l");
    }

    public int execute() throws IOException {
        String string;
        XmlJzCfgAnalyzer xmlJzCfgAnalyzer;
        this.showArguments();
        int n = 6;
        this.bIsInclude = this.cmdArgs.sNameDoc.indexOf(43) > 0;
        this.defineIndirectStyles();
        this.xmlCfgOdt.readFromJar(ReadOdt.class, "xmlCfgOdtNonSemantic.txt", this.log);
        XmlCfg xmlCfg = null;
        if (this.cmdArgs.fWriteXmlStruct != null) {
            xmlJzCfgAnalyzer = new XmlJzCfgAnalyzer();
            try {
                xmlCfg = xmlJzCfgAnalyzer.readXmlStructZip(this.cmdArgs.fIn, "content.xml");
                xmlCfg.writeToText(this.cmdArgs.fWriteXmlStruct, this.log);
            }
            catch (Exception exception) {
                this.log.writeError("Exception analyzeXmlStruct", (Throwable)exception);
            }
        }
        if (this.cmdArgs.dirCreateCfgJavaData != null) {
            XmlCfg xmlCfg2;
            xmlJzCfgAnalyzer = new GenJavaOutClass.CmdArgs();
            xmlJzCfgAnalyzer.dirJava = this.cmdArgs.dirCreateCfgJavaData;
            xmlJzCfgAnalyzer.sJavaClass = "XmlForOdt";
            xmlJzCfgAnalyzer.sJavaPkg = "org.vishia.odt.xmlData";
            string = new GenXmlCfgJavaData((GenJavaOutClass.CmdArgs)xmlJzCfgAnalyzer, this.log);
            if (this.cmdArgs.fWriteXmlStruct != null) {
                xmlCfg2 = new XmlCfg(true);
                xmlCfg2.readCfgFile(this.cmdArgs.fWriteXmlStruct, this.log);
            } else {
                xmlCfg2 = this.xmlCfgOdt;
            }
            string.exec(xmlCfg2);
        }
        if (this.cmdArgs.fIn != null) {
            xmlJzCfgAnalyzer = new XmlDataNode(null, "root", null);
            string = this.readXml((XmlDataNode)xmlJzCfgAnalyzer, this.cmdArgs.fIn);
            if (string != null) {
                this.log.writeError("\nERROR reading xml file %s: %s", new Object[]{this.cmdArgs.fIn.getAbsolutePath(), string});
                n = 4;
            } else {
                this.writeBackupFile(this.cmdArgs.fOutZmL, this.cmdArgs.dirOutBack, this.cmdArgs.sExtOut, this.cmdArgs);
                this.wra = this.cmdArgs.fAdoc == null ? null : new OutputStreamWriter((OutputStream)new FileOutputStream(this.cmdArgs.fAdoc), "UTF-8");
                this.wr = new OutputStreamWriter((OutputStream)new FileOutputStream(this.cmdArgs.fOutZmL), "UTF-8");
                this.wrRep = this.cmdArgs.fReport == null ? null : new OutputStreamWriter((OutputStream)new FileOutputStream(this.cmdArgs.fReport), "UTF-8");
                try {
                    this.readOdgxmlWriteZmL((XmlDataNode)xmlJzCfgAnalyzer);
                    this.wrClose();
                    if (!this.bIsInclude) {
                        this.writeLabelRef();
                    }
                    System.out.printf("\n*** finished %s @%s", this.cmdArgs.fOutZmL.getName(), this.cmdArgs.fOutZmL.getParent());
                    n = 0;
                }
                catch (Exception exception) {
                    CharSequence charSequence = exception == this.excTOCnotUpdated ? "\nERROR: Table of contents is not updated, update all is missing, do it!" : ExcUtil.exceptionInfo((CharSequence)"\nERROR ", (Throwable)exception, (int)0, (int)10);
                    this.log.append(charSequence);
                    this.wrClose();
                    if (this.cmdArgs.dirOutBack != null) {
                        String string2 = this.cmdArgs.sNameDoc;
                        if (FileFunctions.getCanonicalPath((File)this.cmdArgs.dirOutBack).equals(FileFunctions.getCanonicalPath((File)this.cmdArgs.dirIn))) {
                            string2 = string2 + ".back";
                        }
                        File file = new File(this.cmdArgs.dirOutBack, string2 + this.cmdArgs.sExtZmL);
                        boolean bl = this.cmdArgs.fOutZmL.delete() & file.renameTo(this.cmdArgs.fOutZmL);
                        if (bl) {
                            this.log.writef("\n%s successfull restored from: %s", new Object[]{this.cmdArgs.sNameDoc + this.cmdArgs.sExtZmL, file.getAbsolutePath()});
                        } else {
                            this.log.writef("\nERROR restoring %s from %s", new Object[]{this.cmdArgs.sNameDoc + this.cmdArgs.sExtZmL, file.getAbsolutePath()});
                        }
                    }
                    n = 3;
                }
                if (this.cmdArgs.sCmdDifftool != null) {
                    this.executeViewDiff();
                }
            }
        }
        this.log.close();
        return n;
    }

    private void showArguments() {
        System.out.printf("\n*** org.vishia.idt.readOdt.ReadOdt version %s", version);
        System.out.printf("\n  input=%s", this.cmdArgs.fIn);
        System.out.printf("\n  output=%s/*%s", this.cmdArgs.dirZml, this.cmdArgs.sExtOut);
        System.out.printf("\n  SrcCmpn=%s", this.cmdArgs.sDirSrcCmpn);
        System.out.printf("\n  currDir=%s", this.cmdArgs.sCurrDir);
        System.out.printf("\n  Backup-dir %s", this.cmdArgs.dirOutBack);
        System.out.printf("\n  -report=%s", this.cmdArgs.fReport);
        System.out.printf("\n  -dirDbg=%s", this.cmdArgs.dirDbg);
        System.out.printf("\n  Labels write to=%s/*%s", this.cmdArgs.dirLabel, this.cmdArgs.sNameLabel);
        System.out.printf("\n  www-root=%s", this.cmdArgs.swwwRoot);
        System.out.printf("\n  -wrelhtml=%s", this.cmdArgs.sRefBesideInWWWHtml);
        System.out.printf("\n  -wrelpdf=%s", this.cmdArgs.sRefBesideInWWWPdf);
        System.out.printf("\n  -alinkhtml=%s", this.cmdArgs.sRefBesideHtml);
        System.out.printf("\n  -alinkpdf=%s", this.cmdArgs.sRefBesidePdf);
        System.out.printf("\n  sExtRefBesideHtml=%s", this.cmdArgs.sExtRefBesideHtml);
        System.out.printf("\n  sExtRefBesidePdf=%s", this.cmdArgs.sExtRefBesidePdf);
        System.out.printf("\n  View Diff, compare after: %s", this.cmdArgs.sCmdDifftool);
        System.out.printf("\n  dir of saved ZmL=%s", this.cmdArgs.dirSavedZmL);
        if (this.cmdArgs.dirCreateCfgJavaData != null) {
            System.out.printf("\n  -genJavaData=%s", this.cmdArgs.dirCreateCfgJavaData);
        }
    }

    private void executeViewDiff() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.cmdArgs.sCmdDifftool.endsWith(".bat")) {
            linkedList.add("cmd.exe");
            linkedList.add("/C");
        }
        linkedList.add(this.cmdArgs.sCmdDifftool);
        linkedList.add(this.cmdArgs.dirZml.getAbsolutePath());
        linkedList.add(this.cmdArgs.dirSavedZmL.getAbsolutePath());
        ProcessBuilder processBuilder = new ProcessBuilder(linkedList);
        try {
            System.out.println("\n== difftool: " + this.cmdArgs.sCmdDifftool);
            System.out.printf("\n  %s ", ((Object)linkedList).toString());
            processBuilder.start();
            System.out.println("\n== difftool should run: ");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Debugutil.stop();
    }

    private void defineIndirectStyles() {
        StyleOdt styleOdt = new StyleOdt('Q', "Quotation", null, 'i', '?', '?', false, false, 0);
        StyleOdt styleOdt2 = new StyleOdt('E', "Emphasis", null, 'i', 'b', '?', false, false, 0);
        StyleOdt styleOdt3 = new StyleOdt('S', "Strong_20_Emphasis", null, '?', 'b', '?', false, false, 0);
        this.idxIndirectStyle.put("Title", new StyleOdt('p', "Title", null, '?', '?', '?', true, false, 0));
        this.idxIndirectStyle.put("TextPg", new StyleOdt('p', "TextPg", null, '?', '?', '?', true, false, 0));
        this.idxIndirectStyle.put("TextCol", new StyleOdt('c', "TextCol", null, '?', '?', '?', false, true, 0));
        this.idxIndirectStyle.put("ImgCaptionTextCol", new StyleOdt('i', "ImgCaptionTextCol", null, '?', '?', '?', false, true, 0));
        this.idxIndirectStyle.put("ImgCaptionTextPg", new StyleOdt('i', "ImgCaptionTextPg", null, '?', '?', '?', true, false, 0));
        this.idxIndirectStyle.put("ImgCaptionText", new StyleOdt('i', "ImgCaptionText", null, '?', '?', '?', false, false, 0));
        this.idxIndirectStyle.put("modif_i??", styleOdt);
        this.idxIndirectStyle.put("modif_?b?", styleOdt3);
        this.idxIndirectStyle.put("modif_ib?", styleOdt2);
        this.idxIndirectStyle.put("Q", styleOdt);
        this.idxIndirectStyle.put("S", styleOdt3);
        this.idxIndirectStyle.put("E", styleOdt2);
        this.idxIndirectStyle.put("modif_??1", new StyleOdt('1', "Subscript", null, '?', '?', '1', false, false, 0));
        this.idxIndirectStyle.put("modif_??2", new StyleOdt('2', "SuperScript", null, '?', '?', '2', false, false, 0));
        this.idxIndirectStyle.put("modif_i?1", new StyleOdt('3', "SubScriptItalic", null, 'i', '?', '1', false, false, 0));
        this.idxIndirectStyle.put("Heading_20_1", new StyleOdt('\u0000', "Heading_20_1", null, '?', '?', '?', true, true, 0));
        this.idxIndirectStyle.put("Column2", new StyleOdt('\u0000', "Column2", null, '?', '?', '?', false, false, 2));
    }

    private String readXml(XmlDataNode xmlDataNode, File file) throws IOException {
        String string = file.getName();
        XmlJzReader xmlJzReader = new XmlJzReader();
        xmlJzReader.setNamespaceEntry("xml", "XML");
        xmlJzReader.setCfg(this.xmlCfgOdt);
        xmlJzReader.openXmlTestOut(new File(this.cmdArgs.dirDbg, string + "-back.xml"));
        String string2 = xmlJzReader.readZipXml(file, "content.xml", (Object)xmlDataNode);
        return string2;
    }

    public String readOdgxmlWriteZmL(XmlDataNode xmlDataNode) throws IOException {
        XmlDataNode xmlDataNode2 = (XmlDataNode)xmlDataNode.allNodes.get(0);
        this.nodeDirectStyles = (XmlDataNode)xmlDataNode2.singleNodes.get("office:automatic-styles");
        this.gatherDirectStyles(this.nodeDirectStyles);
        XmlDataNode xmlDataNode3 = (XmlDataNode)xmlDataNode2.singleNodes.get("office:body");
        this.nodeText = (XmlDataNode)xmlDataNode3.singleNodes.get("office:text");
        this.gatherAllHeading(this.nodeText);
        this.writeTitle();
        this.writeAsciidocHead();
        this.writeZmlHead();
        this.gatherContent(this.nodeText, 0);
        return null;
    }

    private String gatherDirectStyles(XmlDataNode xmlDataNode) {
        Iterable iterable = xmlDataNode.iterNodes("style:style");
        for (XmlDataNode xmlDataNode2 : iterable) {
            Object object;
            char c;
            String string = (String)xmlDataNode2.attribs.get("style:name");
            String string2 = (String)xmlDataNode2.attribs.get("style:family");
            String string3 = (String)xmlDataNode2.attribs.get("style:parent-style-name");
            String string4 = "";
            String string5 = null;
            String string6 = null;
            String string7 = null;
            int n = 0;
            XmlDataNode xmlDataNode3 = xmlDataNode2.getFirstNode("style:paragraph-properties");
            XmlDataNode xmlDataNode4 = xmlDataNode2.getFirstNode("style:text-properties");
            if (xmlDataNode4 != null) {
                string5 = xmlDataNode4.getAttrib("fo:font-style");
                if (string5 != null) {
                    Debugutil.stop();
                }
                string6 = xmlDataNode4.getAttrib("fo:font-weight");
                string7 = (String)xmlDataNode4.attribs.get("style:text-position");
            }
            if (xmlDataNode3 != null) {
                string4 = xmlDataNode3.getAttrib("fo:break-before");
                if (string5 == null) {
                    string5 = xmlDataNode3.getAttrib("fo:font-style");
                }
                if (string6 == null) {
                    string6 = xmlDataNode3.getAttrib("fo:font-weight");
                }
            } else {
                XmlDataNode xmlDataNode5;
                xmlDataNode3 = xmlDataNode2.getFirstNode("style:section-properties");
                if (xmlDataNode3 != null && (xmlDataNode5 = xmlDataNode3.getFirstNode("style:columns")) != null) {
                    n = this.getAttribNumber(xmlDataNode5, "fo:column-count", 1);
                    if (string3 == null && string2.equals("section")) {
                        string3 = "Column" + n;
                    }
                }
            }
            boolean bl = string4 != null && string4.equals("page");
            boolean bl2 = string4 != null && string4.equals("column");
            char c2 = string5 != null ? (char)string5.charAt(0) : (char)'?';
            char c3 = '?';
            if (string7 != null) {
                Debugutil.stop();
                if (string7.startsWith("super")) {
                    c3 = '2';
                } else if (string7.startsWith("sub")) {
                    c3 = '1';
                } else {
                    this.log.writeInfo("Info: unknown position attribute: %s", new Object[]{string7});
                }
            }
            char c4 = string6 != null ? (string6.equals("bold") ? (char)'b' : (char)string6.charAt(0)) : (c = '?');
            if (c2 != 'i' && c2 != 'n' && string5 != null) {
                this.log.writeWarning("\nfontstyle other then italic: %s", new Object[]{string5});
            }
            if (c != 'b' && c != 'n' && string6 != null) {
                this.log.writeWarning("\nfontweight other then bold: %s", new Object[]{string6});
            }
            if (string3 == null || !string3.equals(string)) {
                if (string2.equals("graphic")) {
                    object = xmlDataNode2.getFirstNode("style:graphic-properties");
                    String string8 = object.getAttrib("style:vertical-pos");
                    String string9 = object.getAttrib("style:horizontal-pos");
                    String string10 = object.getAttrib("style:wrap");
                    String string11 = object.getAttrib("style:horizontal-rel");
                    String string12 = object.getAttrib("style:vertical-rel");
                    StyleImg styleImg = new StyleImg(string, string3, string8, string9, string10, string11, string12);
                    this.idxImgDirectToStyle.put(string, styleImg);
                } else {
                    object = new StyleOdt('\u0000', string, string3, c2, c, c3, bl, bl2, n);
                    this.idxDirectToStyle.put(string, (StyleOdt)object);
                }
            }
            if (string3 == null) {
                this.idxDirectOnlyStyle.put(string, string2);
                continue;
            }
            object = this.idxUsedStyles.get(string3);
            if (object != null && !object.equals(string2)) {
                Debugutil.stop();
            }
            this.idxUsedStyles.put(string3, string2);
        }
        return null;
    }

    private void writeAsciidocHead() throws IOException {
        this.wrAdoc("\n");
        this.wrAdoc(":toc: left");
        this.wrAdoc("\n");
        this.wrAdoc(":toclevels: 5");
        this.wrAdoc("\n");
        this.wrAdoc(":sectnums:");
        this.wrAdoc("\n");
        this.wrAdoc(":sectlinks:");
        this.wrAdoc("\n");
        this.wrAdoc(":max-width: 55em");
        this.wrAdoc("\n");
        this.wrAdoc(":prewrap!:");
        this.wrAdoc("\n");
        this.wrAdoc(":cpp: C++");
        this.wrAdoc("\n");
        this.wrAdoc(":cp: C/++");
        this.wrAdoc("\n");
        this.wrAdoc(":ldquo: \u201c");
        this.wrAdoc("\n");
        this.wrAdoc(":rdquo: \u201d");
        this.wrAdoc("\n");
        this.wrAdoc(":lgquo: \u201e");
        this.wrAdoc("\n");
        this.wrAdoc(":stylesheet: ./Asciidoc_StyleA/CppJava.css");
    }

    private void writeZmlHead() throws IOException {
        this.wrm("\n\n### ZmL Markup vishia-2025-10-10");
        StringBuilder stringBuilder = new StringBuilder(WriteOdt.sTextReplace.length);
        for (String[] stringArray : WriteOdt.sTextReplace) {
            char c = stringArray[0].charAt(0);
            if (c < '\u007f') continue;
            stringBuilder.append(c);
        }
        this.wrm("\n### ");
        this.wrm(stringBuilder);
    }

    private String gatherAllHeading(XmlDataNode xmlDataNode) {
        boolean bl = false;
        for (XmlDataNode xmlDataNode2 : xmlDataNode.allNodes) {
            StyleOdt styleOdt;
            if (!bl && xmlDataNode2.tag.equals("text:p") && (styleOdt = this.getBaseStyle(xmlDataNode2.getAttrib("text:style-name"), null)) != null && styleOdt.name.equals("Title")) {
                this.listNdTitle.add(xmlDataNode2);
                bl = true;
            }
            if (xmlDataNode2.tag.equals("text:h")) {
                int n = this.getAttribNumber(xmlDataNode2, "text:outline-level", 0);
                styleOdt = this.getBaseStyle(xmlDataNode2.getAttrib("text:style-name"), null);
                if (styleOdt.name.equals("Title")) {
                    this.listNdTitle.add(xmlDataNode2);
                    bl = true;
                    continue;
                }
                if (n < 1 || n > 6) continue;
                bl = true;
                this.gatherAllBookmarksInHeader(xmlDataNode2);
                continue;
            }
            if (xmlDataNode2.tag.equals("text:section")) {
                this.gatherAllHeading(xmlDataNode2);
                continue;
            }
            if (xmlDataNode2.tag.equals("text:list")) {
                for (XmlDataNode xmlDataNode3 : xmlDataNode2.iterNodes("text:list-item")) {
                    this.gatherAllHeading(xmlDataNode3);
                }
                for (XmlDataNode xmlDataNode3 : xmlDataNode2.iterNodes("text:list-header")) {
                    this.gatherAllHeading(xmlDataNode3);
                }
                continue;
            }
            if (!xmlDataNode2.tag.equals("text:list")) continue;
            this.gatherAllHeading(xmlDataNode2);
        }
        return null;
    }

    private void gatherAllBookmarksInHeader(XmlDataNode xmlDataNode) {
        String string = null;
        String string2 = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        for (XmlDataNode xmlDataNode2 : xmlDataNode.iterNodes("text:bookmark-start")) {
            bl = true;
            String string3 = xmlDataNode2.getAttrib("text:name");
            if (string3 == null) continue;
            if (string3.startsWith("__RefHeading")) {
                string = string3;
                continue;
            }
            if (string3.startsWith("__RefNumPara")) {
                string2 = string3;
                continue;
            }
            if (!string3.startsWith("__Link_")) continue;
            linkedList.add(string3.substring(7));
        }
        if (bl) {
            Object object = null;
            if (string != null) {
                object = this.idxLabelRef.get(string);
            }
            if (object == null && string2 != null) {
                object = this.idxLabelRef.get(string2);
            }
            if (object == null) {
                if (linkedList.size() == 0) {
                    linkedList.add("$Label_" + ++this.ctLabel);
                }
                this.newLabelRef(linkedList, string, string2);
            } else {
                Debugutil.stop();
                assert (false);
            }
        } else {
            Debugutil.stop();
            this.log.writef("\nWARNING chapter title without bookmark: %s", new Object[]{xmlDataNode.getText()});
        }
    }

    private void newLabelRef(List<String> list, String string, String string2) {
        LabelRef labelRef = new LabelRef(string, string2, list, null, null);
        this.listLabelRef.add(labelRef);
        if (string != null && this.idxLabelRef.get(string) == null) {
            this.idxLabelRef.put(string, labelRef);
        }
        if (string2 != null && this.idxLabelRef.get(string2) == null) {
            this.idxLabelRef.put(string2, labelRef);
        }
        if (list != null) {
            for (String string3 : list) {
                this.idxLabelRef.put(string3, labelRef);
            }
        }
    }

    private String writeTitle() throws IOException {
        this.wrm("../makeDocu/-LOffc-ZmL2odt.sh ./ " + this.cmdArgs.sNameDoc + ".odt NOPAUSE;exit 0;\n");
        for (XmlDataNode xmlDataNode : this.listNdTitle) {
            this.wrAdoc("= ");
            this.wrm("<::ZmL.>");
            this.gathWrText(xmlDataNode, '\u0000');
        }
        return null;
    }

    protected String gatherContent(XmlDataNode xmlDataNode, int n) throws IOException {
        ListIterator<XmlDataNode> listIterator = xmlDataNode.allNodes.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            Object object2;
            XmlDataNode xmlDataNode2 = (XmlDataNode)listIterator.next();
            String string = null;
            if (this.bInCodeBlock && !xmlDataNode2.tag.equals("text:p")) {
                this.wrAdoc("\n----\n");
                this.wrm("\n<.Code>");
                this.bInCodeBlock = false;
            }
            if (xmlDataNode2.tag.equals("text:h")) {
                string = this.gathWrHeader(xmlDataNode2, false);
            } else if (xmlDataNode2.tag.equals("text:list")) {
                string = this.gathWrList(xmlDataNode2);
            } else if (xmlDataNode2.tag.equals("text:p")) {
                object2 = new char[1];
                object = this.getBaseStyle((String)xmlDataNode2.attribs.get("text:style-name"), (char[])object2);
                String string2 = ((StyleOdt)object).name;
                if (this.bInCodeBlock && !string2.startsWith("Code")) {
                    this.wrAdoc("\n----\n");
                    this.wrm("\n<.Code>");
                    this.bInCodeBlock = false;
                }
                if (!this.bTitleFound) {
                    // empty if block
                }
                if (this.bTitleFound && !string2.startsWith("ExternRef")) {
                    if (this.bInCodeBlock) {
                        this.wrAdoc("\n");
                        this.wrm("\n");
                    } else {
                        this.wrAdoc("\n\n");
                        this.wrm("\n\n");
                    }
                    string = this.gathWrParagraph(xmlDataNode2, listIterator, 0, new String[]{"Text", "Text_20_body"});
                } else {
                    this.bTitleFound |= this.getBaseStyle((String)string2, null).name.equals("Title");
                }
            } else if (xmlDataNode2.tag.equals("table:table")) {
                string = this.gathWrTable(xmlDataNode2);
            } else if (xmlDataNode2.tag.equals("text:table-of-content")) {
                string = this.gathWrTableOfContent(xmlDataNode2);
            } else if (xmlDataNode2.tag.equals("text:section")) {
                object2 = this.getBaseStyle((String)xmlDataNode2.attribs.get("text:style-name"), null);
                object = (String)xmlDataNode2.attribs.get("text:name");
                this.wrAdoc("\n\n//Section: ");
                this.wrAdoc(object2.name);
                this.wrm("\n\n<::Section: ");
                this.wrm(object2.name);
                this.wrm(">");
                this.bInColumns = object2.name.startsWith("Column");
                string = this.gatherContent(xmlDataNode2, n + 1);
                this.wrAdoc("\n\n//End-Section");
                this.wrm("\n\n<.Section>\n");
                if (n > 0) {
                    this.wrAdoc(" " + n);
                }
                this.bInColumns = false;
                this.wrAdoc("\n");
            }
            if (string == null) continue;
            this.wrAdoc("\n//ERROR evaluating odt on node ");
            this.wrAdoc(xmlDataNode2.tag);
            this.wrAdoc(": ");
            this.wrAdoc(string);
            this.wrAdoc("\n");
            this.wrm("\n//ERROR evaluating odt on node ");
            this.wrm(xmlDataNode2.tag);
            this.wrm(": ");
            this.wrm(string);
            this.wrm("\n");
        }
        if (this.bInCodeBlock) {
            this.wrAdoc("\n----\n");
            this.wrm("\n<.Code>");
            this.bInCodeBlock = false;
        }
        return null;
    }

    private String gathWrHeader(XmlDataNode xmlDataNode, boolean bl) throws IOException {
        String string5;
        String string2 = null;
        this.bTitleFound = true;
        StyleOdt styleOdt = this.getBaseStyle((String)xmlDataNode.attribs.get("text:style-name"), null);
        int n = this.getAttribNumber(xmlDataNode, "text:outline-level", 9);
        if (styleOdt.name.equals("Title")) {
            this.bTitleFound = true;
            n = 0;
            return null;
        }
        if (n == 0) {
            this.bTitleFound = true;
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = null;
        LabelRef labelRef = null;
        for (XmlDataNode object2 : xmlDataNode.iterNodes("text:bookmark-start")) {
            string5 = object2.getAttrib("text:name");
            if (string5 == null) continue;
            if (string5.startsWith("__Link_")) {
                string5 = string5.substring(7);
            }
            if (string5.startsWith("__PART_")) {
                int n2 = string5.indexOf(35);
                string3 = n2 >= 0 ? string5.substring(7, n2) : string5.substring(7);
                if (!string3.startsWith("END_")) continue;
                string3 = "";
                continue;
            }
            LabelRef labelRef2 = this.idxLabelRef.get(string5);
            if (labelRef2 != null && labelRef2 != labelRef) {
                labelRef = labelRef2;
                for (CharSequence charSequence : labelRef.idxLabel.values()) {
                    linkedList.add((String)charSequence);
                }
                continue;
            }
            if (labelRef2 != null) continue;
            this.log.writef("\nWARNING problem with idxLabelRef: '%s'", new Object[]{string5});
            linkedList.add(string5);
        }
        if (!bl && this.wrFrame != null && string3 != null) {
            if (this.wr != null) {
                if (this.sb.length() > 0) {
                    this.wrBufferToFile(this.sb, this.wr, null, true);
                }
                this.wr.close();
            }
            this.wr = this.wrFrame;
            this.wrFrame = null;
        }
        for (int i = 0; i < 6 - n; ++i) {
            this.wrAdoc("\n");
            this.wrm("\n");
        }
        if (styleOdt.pgBreakBefore) {
            this.wrm("\n<::pageBreak.>\n");
            this.wrAdoc("\n'''");
        } else if (styleOdt.colBreakBefore) {
            this.wrm("\n<::columnBreak.>\n");
            this.wrAdoc("\n'''");
        }
        if (n <= 6) {
            this.wrAdoc("\n");
            for (String string4 : linkedList) {
                this.wrAdoc("[#");
                this.wrAdoc(string4);
                this.wrAdoc("]");
            }
            if (this.sb.length() > 0) {
                this.wrBufferToFile(this.sb, this.wr, null, true);
            }
            this.wrAdoc("\n=");
            this.wrm("\n=");
            for (int i = 0; i < n; ++i) {
                this.wrAdoc("=");
                this.wrm("=");
            }
            this.wrAdoc(" ");
            this.wrm(" ");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.insert(0, " Chapter generated: ");
            for (String string5 : linkedList) {
                stringBuilder.insert(0, "# " + string5);
            }
            String string6 = xmlDataNode.getText();
            if (string6 != null) {
                stringBuilder.append(" ").append(string6);
            }
            this.wrRep(stringBuilder);
        } else {
            this.wrm("<:style:");
            this.wrm(styleOdt.name);
            this.wrm(":Label:");
            this.wrm((CharSequence)linkedList.get(0));
            this.wrm(".>");
            this.wrAdoc("\n<$C:");
            this.wrAdoc(styleOdt.name);
            this.wrAdoc("==");
            this.wrAdoc((CharSequence)linkedList.get(0));
            this.wrAdoc(">");
        }
        string2 = this.gathWrText(xmlDataNode, '\u0000');
        boolean bl2 = false;
        if (!bl && string3 != null) {
            if (string3.length() > 0) {
                this.wrm(" <:#__PART_");
                this.wrm(string3);
            } else {
                this.wrm(" <:#__PART_END_");
            }
            bl2 = true;
        }
        for (String string5 : linkedList) {
            if (!bl2) {
                this.wrm(" <:");
            }
            bl2 = true;
            this.wrm("#");
            this.wrm(string5);
        }
        if (bl2) {
            this.wrm(".>");
        }
        if (!bl && string3 != null && string3.length() > 0) {
            assert (linkedList.size() > 0);
            String[] stringArray = new String[1];
            assert (this.sb.length() > 0);
            this.wrBufferToFile(this.sb, this.wr, stringArray, true);
            string5 = string3 + this.cmdArgs.sExtZmL;
            File file = null;
            try {
                if (string3.startsWith("RD_")) {
                    this.wrFrame = this.wr;
                    this.wr = null;
                } else {
                    file = new File(this.cmdArgs.dirZml, string5);
                    this.writeBackupFile(file, this.cmdArgs.dirOutBack, this.cmdArgs.sExtOut, this.cmdArgs);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                    this.wrFrame = this.wr;
                    this.wr = outputStreamWriter;
                    this.wrm("../makeDocu/-LOffc-ZmL2odt.sh " + string3 + " ;exit 0;\n");
                    this.wrm("<::ZmL.>");
                    this.wrm(string3);
                    this.writeZmlHead();
                    this.wrm("\n\n<::TOC-2.>Table of Contents");
                    this.gathWrHeader(xmlDataNode, true);
                }
            }
            catch (Exception exception) {
                CharSequence charSequence;
                charSequence = ExcUtil.exceptionInfo((CharSequence)"", (Throwable)exception, (int)0, (int)10);
                this.log.writef("Exception write include %s: %s", new Object[]{file, charSequence});
            }
        }
        return string2;
    }

    private String gathWrParagraph(XmlDataNode xmlDataNode, ListIterator<XmlDataNode> listIterator, int n, String[] stringArray) throws IOException {
        boolean bl;
        boolean bl2;
        String string = null;
        String string2 = (String)xmlDataNode.attribs.get("text:style-name");
        char[] cArray = new char[1];
        StyleOdt styleOdt = this.getBaseStyle(string2, cArray);
        if (styleOdt.name.startsWith("ExternRef")) {
            return null;
        }
        if (styleOdt.name.equals("CodeAsciidoc")) {
            Debugutil.stop();
        }
        if (!styleOdt.name.equals("TextPg") && styleOdt.pgBreakBefore) {
            this.wrm("\n<::pageBreak.>\n");
            this.wrAdoc("\n'''");
        } else if (!styleOdt.name.equals("TextCol") && styleOdt.colBreakBefore) {
            this.wrm("\n<::columnBreak.>\n");
            this.wrAdoc("\n'''");
        }
        boolean bl3 = bl2 = styleOdt != null && styleOdt.name.startsWith("ImgCaption");
        if (bl2) {
            Debugutil.stop();
        }
        boolean bl4 = styleOdt != null && styleOdt.name.startsWith("CaptionCode");
        boolean bl5 = styleOdt != null && styleOdt.name.startsWith("Code");
        boolean bl6 = bl = styleOdt != null && styleOdt.name.startsWith("*");
        if (bl5) {
            Debugutil.stop();
        }
        if (bl4) {
            if (styleOdt.name.endsWith("Pg")) {
                this.wrm("\n<::pageBreak.>\n");
                this.wrAdoc("\n'''");
            } else if (styleOdt.name.endsWith("Col")) {
                this.wrm("\n<::columnBreak.>\n");
                this.wrAdoc("\n'''");
            }
            this.gathWrCodeInclude(xmlDataNode, listIterator);
        } else if (!(styleOdt == null || bl2 || bl5 && styleOdt.equals(this.styleP))) {
            boolean bl7 = false;
            for (String string3 : stringArray) {
                if (!styleOdt.name.equals(string3)) continue;
                bl7 = true;
                break;
            }
            if (this.bInCodeBlock) {
                this.wrAdoc("----\n\n");
                this.wrm("<.Code>\n\n");
                this.bInCodeBlock = false;
            }
            if (bl5) {
                this.wrBufferToFile(this.sb, this.wr, null, true);
                this.bInCodeBlock = true;
                this.wrAdoc("[Source, ");
                this.wrAdoc(styleOdt.name.substring(4));
                this.wrAdoc("]\n----\n");
                this.wrm("<:Code:");
                this.wrm(styleOdt.name.substring(4));
                this.wrm(">\n");
            } else if (bl) {
                this.wrAdoc("* ");
                this.wrm("* ");
            } else if (!bl7) {
                this.wrAdoc("[.");
                this.wrAdoc(styleOdt.name);
                this.wrAdoc("]\n");
                this.wrm("<:p:");
                this.wrm(styleOdt.name);
                this.wrm(".>");
            }
        }
        this.styleP = styleOdt;
        XmlDataNode xmlDataNode2 = xmlDataNode.getFirstNode("draw:frame");
        if (xmlDataNode2 != null) {
            this.gathImageInFrame(xmlDataNode, xmlDataNode2, bl2);
        }
        if (!bl2 && !bl4) {
            string = this.gathWrText(xmlDataNode, cArray[0]);
        }
        return string;
    }

    private void gathImageInFrame(XmlDataNode xmlDataNode, XmlDataNode xmlDataNode2, boolean bl) throws IOException {
        XmlDataNode xmlDataNode3;
        String string = xmlDataNode2.getAttrib("draw:style-name");
        XmlDataNode xmlDataNode4 = xmlDataNode2.getFirstNode("draw:text-box");
        if (xmlDataNode4 != null && (xmlDataNode3 = xmlDataNode4.getFirstNode("text:p")) != null) {
            String string2 = xmlDataNode3.getAttrib("text:style-name");
            XmlDataNode xmlDataNode5 = (XmlDataNode)xmlDataNode3.singleNodes.get("draw:frame");
            if (xmlDataNode5 != null) {
                this.gathWrFrameOrImage(xmlDataNode3, xmlDataNode5, string, true);
            }
        }
        if ((xmlDataNode3 = (XmlDataNode)xmlDataNode2.singleNodes.get("draw:image")) != null) {
            this.gathWrFrameOrImage(xmlDataNode, xmlDataNode2, string, bl);
        }
    }

    private void gathWrCodeInclude(XmlDataNode xmlDataNode, ListIterator<XmlDataNode> listIterator) throws IOException {
        String string = this.getTextXml(xmlDataNode, true);
        CharSequence charSequence = ReadOdt.replaceToBackslashSubscription(string);
        if (!listIterator.hasNext()) {
            this.log.writef("\nError 'CaptionCode' content after missing: '%s'", new Object[]{charSequence});
            String string2 = "Cmd";
        } else {
            String string3;
            XmlDataNode xmlDataNode2 = listIterator.next();
            StyleOdt styleOdt = this.getBaseStyle((String)xmlDataNode2.attribs.get("text:style-name"), null);
            if (styleOdt != null && styleOdt.name.startsWith("Code")) {
                string3 = styleOdt.name.substring(4);
                while (listIterator.hasNext()) {
                    xmlDataNode2 = listIterator.next();
                    StyleOdt styleOdt2 = this.getBaseStyle((String)xmlDataNode2.attribs.get("text:style-name"), null);
                    if (!styleOdt2.name.equals(styleOdt.name)) break;
                    for (XmlDataNode xmlDataNode3 : xmlDataNode2.iterNodes("text:span")) {
                        StyleOdt styleOdt3 = this.getBaseStyle((String)xmlDataNode3.attribs.get("text:style-name"), null);
                        if (!styleOdt3.name.equals("cM")) continue;
                        String string4 = xmlDataNode3.getText();
                        Debugutil.stop();
                    }
                }
                listIterator.previous();
            } else {
                listIterator.previous();
                this.log.writef("\nError 'CaptionCode' content after should have style 'Code...': '%s'", new Object[]{charSequence});
                string3 = "Cmd";
            }
            this.wrAdoc("[Source, ");
            this.wrAdoc(string3);
            this.wrAdoc("]\n----\n");
            this.wrBufferToFile(this.sb, this.wr, null, true);
            this.wrm("<:Code:");
            this.wrm(string3);
            this.wrm(">\n");
            this.wrm("<::");
            this.wrm(charSequence);
            this.wrm(".>\n");
            this.wrAdoc(charSequence);
            this.wrAdoc("[]\n");
            this.wrAdoc("\n----\n");
            this.wrm("<.Code>\n");
        }
        this.bInCodeBlock = false;
    }

    private String gathWrText(XmlDataNode xmlDataNode, char c) throws IOException {
        GathWrText gathWrText = new GathWrText();
        String string = null;
        if (xmlDataNode.text != null) {
            if (xmlDataNode.text.contains("given download example")) {
                Debugutil.stop();
            }
            if (c != '\u0000') {
                gathWrText.styleSpan1 = this.idxIndirectStyle.get("" + c);
                gathWrText.ndsSpan = new LinkedList<XmlDataNode>();
                gathWrText.ndsSpan.add(xmlDataNode);
                this.writeSpan(gathWrText.ndsSpan, gathWrText.styleSpan1);
                gathWrText.ndsSpan = null;
            } else {
                this.wrTextAdoc(xmlDataNode.text);
                this.wrText(xmlDataNode.text);
            }
        }
        gathWrText.iterNodes = xmlDataNode.allNodes.listIterator();
        while (gathWrText.iterNodes.hasNext()) {
            XmlDataNode xmlDataNode2 = gathWrText.iterNodes.next();
            string = this.gathWrTextNode(gathWrText, xmlDataNode2, gathWrText.iterNodes, c);
        }
        if (gathWrText.ndsSpan != null) {
            this.writeSpan(gathWrText.ndsSpan, gathWrText.styleSpan1);
        }
        return null;
    }

    private String gathWrTextNode(GathWrText gathWrText, XmlDataNode xmlDataNode, ListIterator<XmlDataNode> listIterator, char c) throws IOException {
        String string = null;
        if (xmlDataNode.tag.equals("text:span")) {
            String string2;
            boolean bl;
            Object object;
            if (gathWrText.nodeLast != null) {
                object = gathWrText.nodeLast;
                gathWrText.nodeLast = null;
                this.gathWrTextNode(gathWrText, (XmlDataNode)object, listIterator, c);
            }
            object = (String)xmlDataNode.attribs.get("text:style-name");
            char[] cArray = null;
            StyleOdt styleOdt = this.getBaseStyle((String)object, cArray);
            if (gathWrText.styleSpan1 != null && styleOdt != gathWrText.styleSpan1) {
                this.writeSpan(gathWrText.ndsSpan, gathWrText.styleSpan1);
                gathWrText.styleSpan1 = null;
                gathWrText.ndsSpan = null;
            }
            if (!(bl = false) && (string2 = this.getTextXml(xmlDataNode, true)) != null) {
                if (string2.startsWith("<:style")) {
                    Debugutil.stop();
                }
                if (styleOdt == null) {
                    assert (gathWrText.styleSpan1 == null);
                    this.wrm(string2);
                    this.wrAdoc(string2);
                    bl = true;
                    string2 = null;
                } else if (gathWrText.styleSpan1 == null) {
                    gathWrText.styleSpan1 = styleOdt;
                    gathWrText.ndsSpan = new LinkedList<XmlDataNode>();
                    gathWrText.ndsSpan.add(xmlDataNode);
                } else {
                    gathWrText.ndsSpan.add(xmlDataNode);
                }
            }
        } else {
            if (gathWrText.ndsSpan != null) {
                this.writeSpan(gathWrText.ndsSpan, gathWrText.styleSpan1);
                gathWrText.styleSpan1 = null;
                gathWrText.ndsSpan = null;
            }
            char c2 = '\u0000';
            if (xmlDataNode.tag.equals("text:a")) {
                boolean bl = false;
                if (xmlDataNode.text != null && xmlDataNode.text.equals(">>>")) {
                    bl = this.checkWrCrossRefPdf(gathWrText, xmlDataNode, listIterator);
                }
                if (!bl) {
                    this.gathWrTextNodeLink(gathWrText, xmlDataNode, listIterator, c);
                }
            } else if (xmlDataNode.tag.equals("text:hidden-text")) {
                String string3 = xmlDataNode.getAttrib("text:string-value");
                if (string3.startsWith("@ref#")) {
                    if (!gathWrText.bLinkWritten) {
                        int n = string3.startsWith("@ref#__Link_") ? 12 : 5;
                        this.wrm("<:@ref:#" + string3.substring(n) + ":.>");
                    }
                } else {
                    Debugutil.stop();
                }
            } else if (xmlDataNode.tag.equals("$")) {
                if (c != '\u0000') {
                    gathWrText.styleSpan1 = this.idxIndirectStyle.get("" + c);
                    gathWrText.ndsSpan = new LinkedList<XmlDataNode>();
                    gathWrText.ndsSpan.add(xmlDataNode);
                    this.writeSpan(gathWrText.ndsSpan, gathWrText.styleSpan1);
                } else {
                    this.wrTextAdoc(xmlDataNode.text);
                    this.wrText(xmlDataNode.text);
                }
            } else if (xmlDataNode.tag.equals("text:p")) {
                Debugutil.stop();
            } else if (xmlDataNode.tag.equals("text:bookmark-ref")) {
                c2 = this.gathWrXRef(xmlDataNode);
            } else if (xmlDataNode.tag.equals("text:line-break")) {
                if (this.bInCodeBlock) {
                    this.wrAdoc("\n");
                    this.wrm("\n");
                } else {
                    this.wrAdoc(" <:nl>\n");
                    this.wrm("\\n\n");
                }
            } else if (xmlDataNode.tag.equals("text:s")) {
                if (gathWrText.whatlast != ' ') {
                    int n = this.getAttribNumber(xmlDataNode, "text:c", 1);
                    while (--n >= 0) {
                        this.wrAdoc(" ");
                        this.wrm(" ");
                    }
                }
            } else if (xmlDataNode.tag.equals("text:tab")) {
                this.wrAdoc("\t");
                this.wrm("\\t ");
            } else if (xmlDataNode.tag.equals("text:section")) {
                Debugutil.stop();
                this.wrAdoc("\n//SECTION in p\n");
                this.wrm("\n<:SECTION in p>\n");
            }
            gathWrText.whatlast = c2;
        }
        return string;
    }

    private boolean checkWrCrossRefPdf(GathWrText gathWrText, XmlDataNode xmlDataNode, ListIterator<XmlDataNode> listIterator) throws IOException {
        LinkedList<XmlDataNode> linkedList = new LinkedList<XmlDataNode>();
        String string = xmlDataNode.getAttrib("text:style-name");
        String string2 = xmlDataNode.getAttrib("xlink:href");
        String string3 = null;
        String string4 = null;
        linkedList.add(xmlDataNode);
        String string5 = this.getLinkNameFromURL(string2);
        while (gathWrText.iterNodes.hasNext()) {
            XmlDataNode xmlDataNode2 = gathWrText.iterNodes.next();
            string = xmlDataNode2.getAttrib("text:style-name");
            string2 = xmlDataNode2.getAttrib("xlink:href");
            if (xmlDataNode2.tag.equals("text:a") && this.getLinkNameFromURL(string2).equals(string5) || xmlDataNode2.tag.equals("text:hidden-text") || xmlDataNode2.tag.equals("$") && StringFunctions.indexAfterAnyChar((CharSequence)xmlDataNode2.text, (int)0, (int)-1, (CharSequence)": ") == xmlDataNode2.text.length()) {
                linkedList.add(xmlDataNode2);
                continue;
            }
            gathWrText.iterNodes.hasPrevious();
            gathWrText.iterNodes.previous();
            break;
        }
        for (XmlDataNode xmlDataNode3 : linkedList) {
            int n;
            string = xmlDataNode3.getAttrib("text:style-name");
            string2 = xmlDataNode3.getAttrib("xlink:href");
            if (string != null && string.equals("Reference") && (string2 == null || !string2.contains(".pdf"))) {
                string4 = xmlDataNode3.text;
            }
            if (string2 != null && (n = string2.indexOf(35) + 1) > 0) {
                if (string3 != null) {
                    if (string3.equals(string2.substring(n))) continue;
                    this.log.writef("\nERROR different inner labels: %s, %s", new Object[]{string3, string2});
                    continue;
                }
                string3 = string2.substring(n);
                continue;
            }
            if (!xmlDataNode3.tag.equals("text:hidden-text")) continue;
            String string6 = xmlDataNode3.getAttrib("text:string-value");
            if (string6.startsWith("@ref#")) {
                int n2 = n = string6.startsWith("@ref#__Link_") ? 12 : 5;
                if (string3 != null) {
                    if (string3.equals(string6.substring(n))) continue;
                    this.log.writef("\nERROR different hidden text inner labels: %s, %s", new Object[]{string3, string2});
                    continue;
                }
                string3 = string6.substring(n);
                continue;
            }
            Debugutil.stop();
        }
        if (string3 != null) {
            if (string3.startsWith("__Link_")) {
                string3 = string3.substring(7);
            }
            if (string4 == null) {
                string4 = "???";
            }
            this.wrm("<:@ref:#" + string3 + ":" + string4 + ".>");
        } else {
            Debugutil.stop();
        }
        return string3 != null;
    }

    private String gathWrTextNodeLink(GathWrText gathWrText, XmlDataNode xmlDataNode, ListIterator<XmlDataNode> listIterator, char c) throws IOException {
        XmlDataNode xmlDataNode2;
        String string = null;
        String string2 = xmlDataNode.getAttrib("text:style-name");
        String string3 = xmlDataNode.getAttrib("xlink:href");
        boolean bl = false;
        Object var9_9 = null;
        Object var10_10 = null;
        if (xmlDataNode.text != null && xmlDataNode.text.equals(">>") && listIterator.hasNext() && (xmlDataNode2 = listIterator.next()) != null && (string2 = xmlDataNode2.getAttrib("text:style-name")) != null && string2.startsWith("c")) {
            this.wrm(">><:");
            this.wrm(string2);
            this.wrm(":");
            String string4 = xmlDataNode2.getTextAllSubNodes();
            if (string4 == null) {
                string4 = "??";
            }
            this.wrText(string4);
            this.wrm(".>");
            if (this.wra != null) {
                string = this.gathWrXlink(xmlDataNode, gathWrText.iterNodes, false);
            }
            bl = true;
        } else if (string2 != null && string2.startsWith("c")) {
            this.wrm(">><:");
            this.wrm(string2);
            this.wrm(":");
            String string5 = xmlDataNode.getTextAllSubNodes();
            if (string5 == null) {
                string5 = "??";
            }
            this.wrText(string5);
            this.wrm(".>");
            if (this.wra != null) {
                string = this.gathWrXlink(xmlDataNode, gathWrText.iterNodes, false);
            }
            bl = true;
        } else {
            string = this.gathWrXlink(xmlDataNode, gathWrText.iterNodes, true);
        }
        return string;
    }

    private String getTextXml(XmlDataNode xmlDataNode, boolean bl) {
        if (xmlDataNode.text != null) {
            return xmlDataNode.text;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.getTextXml(xmlDataNode, stringBuilder, bl);
        return stringBuilder.toString();
    }

    private void getTextXml(XmlDataNode xmlDataNode, StringBuilder stringBuilder, boolean bl) {
        if (xmlDataNode.allNodes == null || xmlDataNode.allNodes.size() == 0) {
            String string = xmlDataNode.text;
            if (string != null) {
                stringBuilder.append(string);
            }
        } else {
            for (XmlDataNode xmlDataNode2 : xmlDataNode.allNodes) {
                if (xmlDataNode2.tag.equals("text:s")) {
                    int n;
                    String string = xmlDataNode2.getAttrib("text:c");
                    if (string == null) {
                        stringBuilder.append(' ');
                        continue;
                    }
                    for (n = StringFunctions_C.parseIntRadix((CharSequence)string, (int)0, (int)3, (int)10, null); n >= 10; n -= 10) {
                        stringBuilder.append("          ");
                    }
                    while (--n >= 0) {
                        stringBuilder.append(' ');
                    }
                    continue;
                }
                if (xmlDataNode2.tag.equals("text:tab")) {
                    stringBuilder.append('\t');
                    continue;
                }
                if (xmlDataNode2.tag.equals("text:line-break")) {
                    stringBuilder.append('\n');
                    continue;
                }
                if (xmlDataNode2.tag.equals("$")) {
                    this.getTextXml(xmlDataNode2, stringBuilder, false);
                    continue;
                }
                if (!bl) continue;
                this.getTextXml(xmlDataNode2, stringBuilder, bl);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String writeSpan(List<XmlDataNode> list, StyleOdt styleOdt) throws IOException {
        Object object;
        boolean bl = styleOdt != null;
        String string = "";
        if (!bl) {
            object = "";
            for (XmlDataNode xmlDataNode : list) {
                object = (String)object + this.getTextXml(xmlDataNode, true);
            }
            this.wrm((CharSequence)object);
            this.wrAdoc((CharSequence)object);
        } else {
            object = "";
            for (XmlDataNode xmlDataNode : list) {
                object = (String)object + this.getTextXml(xmlDataNode, true);
            }
            switch (styleOdt.cShort) {
                case 'Q': {
                    this.wrAdoc("__");
                    string = "__";
                    break;
                }
                case 'E': {
                    this.wrAdoc("__**");
                    string = "**__";
                    break;
                }
                case 'S': {
                    this.wrAdoc("**");
                    string = "**";
                    break;
                }
                case '1': {
                    this.wrAdoc("~");
                    string = "~";
                    break;
                }
                case '2': {
                    this.wrAdoc("^");
                    string = "^";
                    break;
                }
                case '3': {
                    this.wrAdoc("__~");
                    string = "*__";
                    break;
                }
                case '4': {
                    this.wrAdoc("__^");
                    string = "^__";
                    break;
                }
                default: {
                    string = "";
                }
            }
            if (string.length() > 0) {
                this.wrm("<:" + styleOdt.cShort + ":");
            } else if (styleOdt.name.equals("Reference")) {
                void var6_9;
                String string2 = "";
                for (XmlDataNode xmlDataNode : list) {
                    String string3 = (String)var6_9 + this.getTextXml(xmlDataNode, true);
                }
                int n = var6_9.length();
                if (var6_9.startsWith("XREF:")) {
                    void var8_31;
                    String string4 = var6_9.substring(5);
                    if (string4.startsWith("#")) {
                        String string5 = string4.substring(1);
                    }
                    if (var8_31.equals("Impl-ReadOdg-PageShape-Pins")) {
                        Debugutil.stopp();
                    }
                    this.wrAdoc("link:");
                    this.wrAdoc((CharSequence)var8_31);
                    this.wrAdoc(".todo.XREF[]");
                    this.wrm("<:@ref:#" + (String)var8_31 + ":.>");
                    bl = false;
                } else {
                    int[] nArray = new int[1];
                    if (StringFunctions_C.parseIntRadix((CharSequence)var6_9, (int)0, (int)n, (int)10, (int[])nArray) != 0 && nArray[0] == n) {
                        this.wrAdoc("PDF@");
                        this.wrAdoc((CharSequence)var6_9);
                        this.wrm("<:@page.>");
                        bl = false;
                    } else {
                        for (XmlDataNode xmlDataNode : list) {
                            for (XmlDataNode xmlDataNode2 : xmlDataNode.iterNodes("text:bookmark-ref")) {
                                this.gathWrXRef(xmlDataNode2);
                                bl = false;
                            }
                        }
                        if (bl) {
                            this.wrm("<:Reference:");
                            this.wrAdoc("__");
                            string = "__";
                        }
                    }
                }
            } else if (styleOdt.name.startsWith("modif_")) {
                if (styleOdt.cItalic == 'i') {
                    this.wrAdoc("__");
                    string = "__";
                    if (styleOdt.cWeight != '\u0000') {
                        this.wrAdoc("**");
                        string = "**__";
                    }
                    String string6 = styleOdt.cWeight == '\u0000' ? "Q" : "E";
                    this.wrm("<:" + string6 + ":");
                } else if (styleOdt.cWeight != '?') {
                    assert (styleOdt.cItalic != 'i' || styleOdt.cItalic == 'n');
                    this.wrAdoc("**");
                    string = "**";
                    this.wrm("<:S:");
                } else {
                    bl = false;
                }
            } else {
                boolean bl2;
                void var7_26;
                boolean bl3;
                void var7_24;
                String string7 = styleOdt.name;
                Object var7_22 = null;
                for (String[] stringArray : WriteOdt.sTextCtrlCommon) {
                    if (!string7.equals(stringArray[4])) continue;
                    String string8 = stringArray[0];
                    break;
                }
                if (var7_24 == null) {
                    String string9 = "<:" + string7 + ':';
                }
                boolean bl4 = bl3 = styleOdt != null && styleOdt.name.equals("ccode");
                if (bl3) {
                    String string10 = "c";
                }
                this.wrm((CharSequence)var7_26);
                int n = styleOdt != null && (styleOdt.name.equals("Quotation") || styleOdt.name.equals("Citation")) ? 1 : 0;
                int n2 = styleOdt != null && styleOdt.name.equals("Strong_20_Emphasis") ? 1 : 0;
                boolean bl5 = bl2 = styleOdt != null && styleOdt.name.equals("Emphasis");
                if (n != 0) {
                    this.wrAdoc("__");
                    string = "__";
                } else if (n2 != 0) {
                    this.wrAdoc("**");
                    string = "**";
                } else if (bl2) {
                    this.wrAdoc("__**");
                    string = "**__";
                } else if (bl3) {
                    this.wrAdoc("`");
                    string = "`";
                } else {
                    this.wrAdoc("[");
                    this.wrAdoc(styleOdt.name);
                    this.wrAdoc("]`");
                    string = "`";
                }
            }
        }
        if (bl) {
            for (XmlDataNode xmlDataNode : list) {
                if (xmlDataNode.tag.equals("text:bookmark-ref")) {
                    this.gathWrXRef(xmlDataNode);
                    continue;
                }
                String string11 = this.getTextXml(xmlDataNode, true);
                if (string11.equals("Value cast of input:")) {
                    Debugutil.stop();
                }
                this.wrTextAdoc(string11);
                this.wrText(string11);
            }
            this.wrAdoc(string);
            this.wrm(".>");
        }
        return null;
    }

    private String gathWrList(XmlDataNode xmlDataNode) throws IOException {
        XmlDataNode xmlDataNode2 = (XmlDataNode)xmlDataNode.singleNodes.get("text:list-header");
        if (xmlDataNode2 != null) {
            this.gathWrListItemOrNumbHeader(xmlDataNode2);
        } else {
            xmlDataNode2 = (XmlDataNode)xmlDataNode.singleNodes.get("text:list-item");
            if (xmlDataNode2 != null) {
                this.gathWrListItemOrNumbHeader(xmlDataNode2);
            } else {
                List list = (List)xmlDataNode.multiNodes.get("text:list-item");
                if (list != null) {
                    for (XmlDataNode xmlDataNode3 : list) {
                        this.gathWrListItemOrNumbHeader(xmlDataNode3);
                    }
                }
                Debugutil.stop();
            }
        }
        return null;
    }

    private String gathWrListItemOrNumbHeader(XmlDataNode xmlDataNode) throws IOException {
        String string;
        XmlDataNode xmlDataNode2 = (XmlDataNode)xmlDataNode.singleNodes.get("text:h");
        if (xmlDataNode2 == null) {
            xmlDataNode2 = (XmlDataNode)xmlDataNode.singleNodes.get("text:p");
        }
        if (xmlDataNode2 != null) {
            string = xmlDataNode2.getAttrib("text:outline-level");
            if (string != null && string.charAt(0) <= '6') {
                this.gathWrHeader(xmlDataNode2, false);
            } else {
                this.gathWrListItem(xmlDataNode2);
            }
        }
        if ((string = xmlDataNode.getFirstNode("text:list")) != null) {
            this.gathWrList((XmlDataNode)string);
        }
        return null;
    }

    private String gathWrListItem(XmlDataNode xmlDataNode) throws IOException {
        XmlDataNode xmlDataNode2 = (XmlDataNode)xmlDataNode.singleNodes.get("draw:frame");
        if (xmlDataNode2 != null) {
            String string = xmlDataNode2.getAttrib("draw:style-name");
            return this.gathWrFrameOrImage(xmlDataNode, xmlDataNode2, string, true);
        }
        StyleOdt styleOdt = this.getBaseStyle(xmlDataNode.getAttrib("text:style-name"), null);
        this.wrAdoc("\n\n* ");
        this.wrm("\n\n* ");
        return this.gathWrText(xmlDataNode, '\u0000');
    }

    private String gathWrTable(XmlDataNode xmlDataNode) throws IOException {
        String string = null;
        XmlDataNode xmlDataNode2 = xmlDataNode.getFirstNode("table:table-column");
        String string2 = xmlDataNode2.getAttrib("table:number-columns-repeated");
        this.wrm("\n\n<::table:col=");
        this.wrm(string2);
        this.wrm(".>");
        for (XmlDataNode xmlDataNode3 : xmlDataNode.iterNodes("table:table-row")) {
            this.wrm("\n<:tr.>");
            for (XmlDataNode xmlDataNode4 : xmlDataNode3.iterNodes("table:table-cell")) {
                this.wrm("\n  <:td");
                String string3 = xmlDataNode4.getAttrib("table:number-columns-spanned");
                if (string3 != null) {
                    this.wrm(":spanned=");
                    this.wrm(string3);
                }
                this.wrm(".>");
                ListIterator listIterator = xmlDataNode4.iterListNodes("text:p");
                while (listIterator.hasNext()) {
                    XmlDataNode xmlDataNode5 = (XmlDataNode)listIterator.next();
                    this.gathWrParagraph(xmlDataNode5, listIterator, 4, new String[]{"Table_20_Contents"});
                }
            }
        }
        this.wrm("\n<.table>");
        return string;
    }

    private String gathWrTableOfContent(XmlDataNode xmlDataNode) throws IOException {
        XmlDataNode xmlDataNode2 = xmlDataNode.getFirstNode("text:table-of-content-source");
        XmlDataNode xmlDataNode3 = xmlDataNode.getFirstNode("text:index-body");
        boolean bl = false;
        char[] cArray = new char[1];
        String string = "Table of contents";
        if (xmlDataNode3 != null) {
            XmlDataNode xmlDataNode4;
            XmlDataNode xmlDataNode5 = xmlDataNode3.getFirstNode("text:index-title");
            if (xmlDataNode5 != null && (xmlDataNode4 = xmlDataNode5.getFirstNode("text:p")) != null) {
                StyleOdt styleOdt = this.getBaseStyle(xmlDataNode4.getAttrib("text:style-name"), cArray);
                bl = styleOdt != null && styleOdt.pgBreakBefore;
                string = xmlDataNode4.getText();
            }
            boolean bl2 = false;
            for (XmlDataNode xmlDataNode6 : xmlDataNode3.iterNodes("text:p")) {
                LabelRef labelRef;
                XmlDataNode xmlDataNode7 = xmlDataNode6.getFirstNode("text:a");
                if (xmlDataNode7 == null) continue;
                bl2 = true;
                String string2 = xmlDataNode7.getAttrib("xlink:href");
                if (string2.startsWith("#")) {
                    string2 = string2.substring(1);
                }
                String string3 = null;
                String string4 = this.getTextXml(xmlDataNode7, false);
                int n = string4.indexOf(9);
                if (n > 0) {
                    string3 = string4.substring(n + 1);
                    string4 = string4.substring(0, n);
                }
                if ((labelRef = this.idxLabelRef.get(string2)) == null) {
                    LinkedList<String> linkedList = new LinkedList<String>();
                    linkedList.add(string2);
                    this.idxLabelRef.put(string2, new LabelRef("?", "?", linkedList, string4, string3));
                    continue;
                }
                labelRef.sTitle = string4;
                labelRef.sPage = string3;
            }
            if (!bl2) {
                throw this.excTOCnotUpdated;
            }
        }
        if (xmlDataNode2 != null) {
            int n = this.getAttribNumber(xmlDataNode2, "text:outline-level", 0);
            String string5 = xmlDataNode2.getAttrib("text:index-scope");
            this.wrAdoc("\n");
            if (bl) {
                this.wrAdoc("\n\n\n'''");
            }
            this.wrAdoc("\n//TOC");
            if (string5 != null) {
                this.wrAdoc("-");
                this.wrAdoc(string5);
            }
            this.wrAdoc("-" + n);
            this.wrAdoc(":");
            this.wrAdoc(string);
            this.wrm("\n");
            if (bl) {
                this.wrm("\n\n\n<::pageBreak.>");
            }
            this.wrm("\n<::TOC");
            if (string5 != null) {
                this.wrm("-");
                this.wrm(string5);
            }
            this.wrm("-" + n);
            this.wrm(".>");
            this.wrm(string);
            return null;
        }
        return "odt-MISSING <text:table-of-content-source...>";
    }

    private String gathWrFrameOrImage(XmlDataNode xmlDataNode, XmlDataNode xmlDataNode2, String string, boolean bl) throws IOException {
        XmlDataNode xmlDataNode3;
        String string22;
        StringBuilder stringBuilder;
        if (!bl) {
            stringBuilder = null;
        } else {
            stringBuilder = new StringBuilder();
            for (String string22 : xmlDataNode.allNodes) {
                if (((XmlDataNode)string22).tag.equals("$")) {
                    stringBuilder.append(((XmlDataNode)string22).text);
                    continue;
                }
                if (!((XmlDataNode)string22).tag.equals("text:span")) continue;
                stringBuilder.append(((XmlDataNode)string22).text);
            }
            ReadOdt.replaceToBackslashSubscription(stringBuilder);
        }
        XmlDataNode xmlDataNode4 = xmlDataNode.getFirstNode("text:bookmark-start");
        string22 = null;
        if (xmlDataNode4 != null && (string22 = xmlDataNode4.getAttrib("text:name")) == null) {
            string22 = xmlDataNode4.getAttrib("draw:name");
        }
        if ((xmlDataNode3 = (XmlDataNode)xmlDataNode2.singleNodes.get("draw:image")) != null) {
            String string3 = xmlDataNode3.getAttrib("xlink:href");
            StyleImg styleImg = this.idxImgDirectToStyle.get(string);
            String string4 = " :: ";
            String string5 = "";
            if (string3 != null) {
                float f;
                float f2;
                float f3;
                String string6;
                int n;
                if (string3.startsWith("../")) {
                    string3 = string3.substring(1);
                }
                this.wrAdoc("\n\nimage::");
                this.wrAdoc(string3);
                this.wrAdoc("[");
                this.wrm("\n<:@image:");
                this.wrm(string3);
                if (string22 != null) {
                    this.wrAdoc("id=");
                    this.wrAdoc(string22.substring(1));
                    this.wrm(string4);
                    this.wrm("id=");
                    this.wrm(string22);
                    string4 = " :: ";
                    string5 = ", ";
                }
                if (stringBuilder != null && stringBuilder.length() > 0) {
                    this.wrAdoc(string4);
                    this.wrAdoc("title=");
                    this.wrAdoc(stringBuilder);
                    this.wrm(string4);
                    this.wrm("title=");
                    this.wrm(stringBuilder);
                    string4 = " :: ";
                    string5 = ", ";
                }
                String string7 = "ImageCenter";
                if (styleImg != null) {
                    if (styleImg.parentName.startsWith("Image")) {
                        string7 = styleImg.parentName;
                    } else {
                        String string8 = styleImg.wrap == null ? "" : (styleImg.wrap.equals("left") ? "Floatleft" : (styleImg.wrap.equals("right") ? "Floatright" : ""));
                        string7 = "Image" + string8;
                    }
                    this.wrm(string4);
                    this.wrm("style=");
                    this.wrm(string7);
                    string4 = " :: ";
                }
                if ((n = string7.indexOf("Float")) > 0) {
                    string6 = string7.substring(n + 5);
                    this.wrm(string4);
                    this.wrm("float=" + string6);
                    string4 = " :: ";
                    this.wrAdoc(string5);
                    this.wrAdoc("float=" + string6);
                    string5 = ", ";
                }
                string6 = xmlDataNode2.getAttrib("style:rel-width");
                String string9 = xmlDataNode2.getAttrib("style:rel-height");
                if (string6 != null) {
                    this.wrm(string4);
                    this.wrm("sRelX = " + string6);
                    string4 = " :: ";
                }
                if (string9 != null) {
                    this.wrm(string4);
                    this.wrm("sRelY = " + string9);
                    string4 = " :: ";
                }
                String string10 = xmlDataNode2.getAttrib("svg:width");
                String string11 = xmlDataNode2.getAttrib("svg:height");
                int[] nArray = new int[1];
                float f4 = StringFunctions_C.parseFloat((CharSequence)string10, (int)0, (int)-1, (int[])nArray);
                float f5 = StringFunctions_C.parseFloat((CharSequence)string11, (int)0, (int)-1, (int[])nArray);
                String string12 = string11.substring(nArray[0]);
                if (string12.equals("in")) {
                    f3 = f4;
                    f2 = f5;
                    f = 100.0f;
                } else if (string12.equals("cm")) {
                    f3 = f4 / 2.54f;
                    f2 = f5 / 2.54f;
                    f = 50.0f;
                } else if (string12.equals("mm")) {
                    f3 = f4 / 25.4f;
                    f2 = f5 / 25.4f;
                    f = 5.0f;
                } else if (string12.equals("pt")) {
                    f3 = f4 / 72.0f;
                    f2 = f5 / 72.0f;
                    f = 1.0f;
                } else {
                    f3 = f4;
                    f2 = f5;
                    f = 100.0f;
                    this.log.writeWarning("unknown measurement for image: %s: %s\n", new Object[]{string3, string11});
                }
                float f6 = (float)((int)(f * f4 + 0.5f)) / f;
                float f7 = (float)((int)(f * f5 + 0.5f)) / f;
                this.wrm(string4);
                this.wrm("size=" + f6 + string12 + "*" + f7 + string12);
                string4 = " :: ";
                File file = new File(string3);
                if (file.exists()) {
                    BufferedImage bufferedImage = ImageIO.read(file);
                    WritableRaster writableRaster = bufferedImage.getRaster();
                    int n2 = writableRaster.getWidth();
                    int n3 = writableRaster.getHeight();
                    this.wrm(string4);
                    this.wrm("px=" + n2 + "*" + n3);
                    string4 = " :: ";
                    float f8 = (float)n2 / f3;
                    float f9 = (float)n3 / f2;
                    int n4 = (int)(f8 + 0.5f);
                    int n5 = (int)(f8 + 0.5f);
                    if (n4 == n5) {
                        this.wrm(string4);
                        this.wrm("DPI = " + n4);
                    } else {
                        this.wrm(string4);
                        this.wrm("DPI = " + n4 + "*" + n5);
                    }
                }
                this.wrAdoc("]\n");
                this.wrm(".>\n");
            }
        }
        return null;
    }

    private String gathWrXlink(XmlDataNode xmlDataNode, ListIterator<XmlDataNode> listIterator, boolean bl) throws IOException {
        block41: {
            try {
                String string;
                String string2 = xmlDataNode.getAttrib("xlink:href");
                if (string2.contains("Impl-ReadOdg-PageShape-Pins")) {
                    Debugutil.stopp();
                }
                if (xmlDataNode.text != null) {
                    string = xmlDataNode.text;
                } else {
                    string = "";
                    for (Object object2 : xmlDataNode.allNodes) {
                        if (((XmlDataNode)object2).tag.equals("text:soft-page-break")) {
                            string = string + "\\|";
                            continue;
                        }
                        String string3 = object2.getText();
                        if (string3 == null) {
                            Debugutil.stop();
                            continue;
                        }
                        string = string + string3;
                    }
                }
                int n = string2.indexOf(35);
                if (n >= 0 && (this.cmdArgs.sRefBesideHtml != null && string2.startsWith(this.cmdArgs.sRefBesideHtml) || this.cmdArgs.sRefBesideInWWWHtml != null && string2.startsWith(this.cmdArgs.sRefBesideInWWWHtml) || this.cmdArgs.sRefBesidePdf != null && string2.startsWith(this.cmdArgs.sRefBesidePdf) || this.cmdArgs.sRefBesideInWWWPdf != null && string2.startsWith(this.cmdArgs.sRefBesideInWWWPdf))) {
                    Object object;
                    Object object2;
                    Debugutil.unexpected();
                    object2 = string2.substring(n + 1);
                    if (((String)object2).equals("Impl-ReadOdg-PageShape-Pins")) {
                        Debugutil.stopp();
                    }
                    string = "";
                    int n2 = 7;
                    boolean bl2 = false;
                    while (--n2 >= 0 && listIterator.hasNext()) {
                        object = listIterator.next();
                        if (object.tag.equals("text:span") && object.getAttrib("text:style-name").equals("Reference")) {
                            string = string + this.getTextXml((XmlDataNode)object, true);
                            bl2 = true;
                            continue;
                        }
                        if (object.tag.equals("text:soft-page-break")) {
                            ++n2;
                            continue;
                        }
                        if (bl2) {
                            listIterator.hasPrevious();
                            listIterator.previous();
                            break;
                        }
                        if (object.tag.equals("text:a")) {
                            ++n2;
                            continue;
                        }
                        String string4 = this.getTextXml((XmlDataNode)object, true);
                        if (string4 == null) continue;
                        boolean bl3 = false;
                        for (int i = 0; i < string4.length(); ++i) {
                            if ("( )/:,".indexOf(string4.charAt(i)) >= 0) continue;
                            bl3 = true;
                            break;
                        }
                        if (!bl3) continue;
                        string = string + string4;
                    }
                    this.lastXref = object2;
                    this.wrAdoc("<<");
                    this.wrAdoc((CharSequence)object2);
                    if (bl) {
                        this.wrm("<:@ref:#");
                        this.wrm((CharSequence)object2);
                    }
                    if (string != null) {
                        this.wrAdoc(",");
                        if (bl) {
                            this.wrm(":");
                        }
                        if (this.sRefChapter != null && this.sRefBookmark.equals(object2)) {
                            this.wrAdoc(this.sRefChapter);
                            this.wrAdoc(" ");
                            if (bl) {
                                this.wrm(this.sRefChapter);
                                this.wrm(" ");
                            }
                        }
                        object = ReadOdt.replaceToBackslashSubscription(string);
                        this.wrAdoc((CharSequence)object);
                        if (bl) {
                            this.wrm((CharSequence)object);
                        }
                    }
                    this.wrAdoc(">>");
                    if (bl) {
                        this.wrm(".>");
                    }
                } else if (this.cmdArgs.sRefBesidePdf != null && string2.startsWith(this.cmdArgs.sRefBesidePdf)) {
                    Debugutil.stop();
                } else {
                    String string5;
                    String string6;
                    String string7;
                    int n3;
                    int n4;
                    if (string2.endsWith("WriteOdt.html")) {
                        Debugutil.stop();
                    }
                    if (string2.startsWith(this.cmdArgs.swwwRoot) && this.lastHlinkPathToReplaced != null) {
                        int n5 = string2.indexOf(this.lastHlinkPathToReplaced);
                        if (n5 >= 0) {
                            string2 = string2.substring(0, n5) + "...";
                        }
                        this.lastHlinkPathToReplaced = null;
                    } else if (string2.startsWith("../") && (n4 = StringFunctions.indexAfterAnyChar((CharSequence)(string2 = string2.substring(1)), (int)0, (int)-1, (CharSequence)"./")) > 0) {
                        this.lastHlinkPathToReplaced = string2.substring(n4);
                    }
                    if (string == null) {
                        string = "";
                    } else if (string.equals(string2)) {
                        string = "";
                    }
                    int n6 = string2.indexOf(35);
                    if (n6 > 0 && (n3 = StringFunctions.indexAfterIdentifier((CharSequence)string2, (int)(n6 + 1), (int)-1, null)) < string2.length() - 2 && !(string7 = this.searchForReplacingLinkOperationLabel(string6 = string2.substring(0, n6), string5 = string2.substring(n6 + 1), this.cmdArgs.dirIn)).endsWith("?")) {
                        String string8 = "(...)";
                        if (n3 == string2.length() - 2) {
                            string8 = "()";
                        }
                        string2 = string2.substring(0, n3) + string8;
                    }
                    this.wrAdoc("link:");
                    this.wrAdoc(string2);
                    this.wrAdoc("[");
                    if (bl) {
                        this.wrReplaceLastSpace('\n');
                        this.wrm("<:@link:");
                        this.wrm(string2);
                    }
                    if (string.indexOf(8203) >= 0) {
                        Debugutil.stop();
                    }
                    CharSequence charSequence = ReadOdt.replaceToBackslashSubscription(string);
                    if (string.length() > 0) {
                        this.wrAdoc(charSequence);
                        if (bl) {
                            this.wrm("::");
                            this.wrm(charSequence);
                        }
                    }
                    if (bl) {
                        this.wrm(".>");
                    }
                    this.wrAdoc("]");
                }
            }
            catch (Exception exception) {
                CharSequence charSequence = ExcUtil.exceptionInfo((CharSequence)"", (Throwable)exception, (int)0, (int)20);
                this.log.writef("\nException %s", new Object[]{charSequence});
                charSequence = ExcUtil.exceptionInfo((CharSequence)"Exception: ", (Throwable)exception, (int)0, (int)2);
                if (!bl) break block41;
                this.wrm("<:E:");
                this.wrm(charSequence);
                this.wrm(".>");
            }
        }
        return null;
    }

    private char gathWrXRef(XmlDataNode xmlDataNode) throws IOException {
        String string = (String)xmlDataNode.attribs.get("text:ref-name");
        if (string.equals("Impl-ReadOdg-PageShape-Pins")) {
            Debugutil.stopp();
        }
        String string2 = xmlDataNode.getAttrib("text:reference-format");
        String string3 = xmlDataNode.getText();
        if (string.startsWith("__RefNumPara")) {
            Debugutil.stop();
        }
        int n = 0;
        if (string != null && string2 != null) {
            boolean bl = string.startsWith("__Link_");
            if (bl) {
                string = string.substring(7);
            }
            if (string2 != null && string2.equals("chapter")) {
                this.sRefChapter = string3;
                this.sRefBookmark = string;
                n = 32;
            } else if (string2.equals("text")) {
                if (!bl) {
                    Iterator<String> iterator;
                    LabelRef labelRef = this.idxLabelRef.get(string);
                    if (labelRef == null) {
                        Debugutil.stop();
                    } else if (labelRef.idxLabel != null && (iterator = labelRef.idxLabel.values().iterator()).hasNext()) {
                        String string4;
                        string = string4 = iterator.next();
                    }
                }
                this.lastXref = string;
                this.wrAdoc("<<");
                this.wrAdoc(string);
                this.wrm("<:@ref:#");
                this.wrm(string);
                if (string3 != null) {
                    this.wrAdoc(",");
                    this.wrm(":");
                    if (this.sRefChapter != null && this.sRefBookmark.equals(string)) {
                        this.wrAdoc(this.sRefChapter);
                        this.wrAdoc(" ");
                        this.wrm(this.sRefChapter);
                        this.wrm(" ");
                    }
                    this.wrAdoc(string3);
                    this.wrm(string3);
                }
                this.wrAdoc(">>");
                this.wrm(".>");
                this.sRefChapter = null;
            } else if (string2.equals("page")) {
                this.wrAdoc("PDF@");
                this.wrAdoc(string3);
                this.wrm("<:@page.>");
            } else {
                Debugutil.stop();
            }
        }
        return (char)n;
    }

    private StyleOdt getBaseStyle(String string, char[] cArray) {
        String string2;
        if (string.equals("T18")) {
            Debugutil.stop();
        }
        if (string.equals("T26")) {
            Debugutil.stop();
        }
        String string3 = string;
        boolean bl = false;
        boolean bl2 = false;
        char c = '?';
        char c2 = '?';
        char c3 = '?';
        StyleOdt styleOdt = this.idxDirectToStyle.get(string3);
        while (styleOdt != null) {
            bl |= styleOdt.pgBreakBefore;
            bl2 |= styleOdt.colBreakBefore;
            if (c3 == '?' && styleOdt.cPosition != '?') {
                c3 = styleOdt.cPosition;
            }
            if (c == '?' && styleOdt.cItalic != '?') {
                c = styleOdt.cItalic;
            }
            if (c2 == '?' && styleOdt.cWeight != '?') {
                c2 = styleOdt.cWeight;
            }
            if ((string3 = styleOdt.parentName) == null) {
                styleOdt = null;
                continue;
            }
            styleOdt = this.idxDirectToStyle.get(string3);
        }
        if (styleOdt == null) {
            if (c2 != '?' || c != '?' || c3 != '?') {
                string2 = (string3 == null ? "modif_" : string3) + c + c2 + c3;
                styleOdt = this.idxIndirectStyle.get(string2);
                if (styleOdt == null && string3 != null) {
                    styleOdt = this.idxIndirectStyle.get(string3);
                } else {
                    string3 = string2;
                }
            } else if (string3 != null) {
                styleOdt = this.idxIndirectStyle.get(string3);
            }
            if (styleOdt == null && string3 != null) {
                styleOdt = new StyleOdt('\u0000', string3, null, c, c2, c3, false, false, 0);
                this.idxIndirectStyle.put(string3, styleOdt);
            }
        }
        if (styleOdt != null && (styleOdt.pgBreakBefore != bl || styleOdt.colBreakBefore != bl2) && (styleOdt = this.idxIndirectStyle.get(string2 = string3 + (bl ? "Pg" : "") + (bl2 ? "Col" : ""))) == null) {
            styleOdt = new StyleOdt('\u0000', string2, null, '?', '?', '?', bl, bl2, 0);
            this.idxIndirectStyle.put(string2, styleOdt);
        }
        if ((c != '?' || c2 != '?') && cArray != null) {
            cArray[0] = c == 'i' ? (c2 == 'b' ? 69 : 81) : (c2 == 'b' ? 83 : 0);
        }
        return styleOdt;
    }

    private int getNumber(String string, int n) {
        int n2 = n;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.writeError("EXCEPTION gatherText, parse " + string, (Throwable)numberFormatException);
            }
        }
        return n2;
    }

    private int getAttribNumber(XmlDataNode xmlDataNode, String string, int n) {
        String string2 = xmlDataNode.attribs == null ? null : (String)xmlDataNode.attribs.get(string);
        return this.getNumber(string2, n);
    }

    private String wrText(String string) throws IOException {
        int n = 0;
        if (string.startsWith("\\t")) {
            Debugutil.stop();
        }
        CharSequence charSequence = ReadOdt.replaceToBackslashSubscription(string);
        String string2 = charSequence.toString();
        int n2 = 0;
        if (!this.bInCodeBlock) {
            int n3 = string2.length();
            String[] stringArray = null;
            do {
                n2 = n3;
                int n4 = n3;
                for (String[] stringArray2 : WriteOdt.sTextCtrlCommon) {
                    int n5 = string2.indexOf(stringArray2[0], n);
                    if (n5 < 0 || n5 >= n3 - 1) continue;
                    if (stringArray2.length > 3) {
                        int n6 = string2.indexOf(stringArray2[1], n5 + 1);
                        if (n6 <= 0 || n2 <= n5) continue;
                        n2 = n5;
                        n4 = n6 + stringArray2[1].length();
                        stringArray = stringArray2;
                        continue;
                    }
                    n2 = n5;
                    n4 = n5 + stringArray2[0].length();
                    stringArray = stringArray2;
                }
                if (n2 >= n3) continue;
                if (n2 > n) {
                    this.wrm(string2.substring(n, n2));
                }
                if (stringArray.length == 3) {
                    assert (n4 - n2 == stringArray[1].length());
                    this.wrm((CharSequence)stringArray[0]);
                } else {
                    this.wrm(string2.substring(n2, n4));
                }
                n = n4;
            } while (n2 < n3);
            if (n < n3) {
                this.wrm(string2.substring(n));
            }
        } else {
            assert (this.bInCodeBlock);
            if (string.startsWith("...text")) {
                Debugutil.stop();
            }
            this.wrm(string2);
        }
        return null;
    }

    private static CharSequence replaceToBackslashSubscription(CharSequence charSequence) {
        StringBuilder stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : null;
        CharSequence charSequence2 = charSequence;
        int n = 0;
        int[] nArray = new int[1];
        while (n >= 0) {
            boolean bl;
            if ((n = StringFunctions.indexOfAnyChar((CharSequence)charSequence2, (int)n, (int)Integer.MAX_VALUE, (CharSequence)WriteOdt.sTextReplaceChars, (int[])nArray)) < 0) continue;
            int n2 = nArray[0];
            String[] stringArray = WriteOdt.sTextReplace[n2];
            int n3 = stringArray[0].length();
            boolean bl2 = bl = n3 == 1;
            if (n3 > 1) {
                do {
                    boolean bl3 = bl = StringFunctions.compare((CharSequence)charSequence2, (int)n, (CharSequence)stringArray[0], (int)0, (int)n3) == 0;
                    if (bl) continue;
                    stringArray = WriteOdt.sTextReplace[++n2];
                } while (!bl && stringArray[0].charAt(0) == charSequence2.charAt(n));
            }
            if (bl) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(charSequence);
                    charSequence2 = stringBuilder;
                }
                String string = stringArray[1];
                stringBuilder.replace(n, n + n3, string);
                n += string.length();
                continue;
            }
            ++n;
        }
        return charSequence2;
    }

    private String wrTextAdoc(String string) throws IOException {
        if (string.contains("search")) {
            Debugutil.stop();
        }
        if (!this.bInCodeBlock) {
            int n = 0;
            StringBuilder stringBuilder = null;
            CharSequence charSequence = string;
            int[] nArray = new int[1];
            while (n >= 0) {
                if ((n = StringFunctions.indexOfAnyChar((CharSequence)charSequence, (int)n, (int)Integer.MAX_VALUE, (CharSequence)WriteOdt.sTextReplaceChars, (int[])nArray)) < 0) continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string);
                    charSequence = stringBuilder;
                }
                String string2 = WriteOdt.sTextReplace[nArray[0]][2];
                stringBuilder.replace(n, n + 1, string2);
                n += string2.length();
            }
            int n2 = 0;
            String[] stringArray = null;
            String string3 = charSequence.toString();
            int n3 = string3.length();
            do {
                n = n3;
                int n4 = n3;
                for (String[] stringArray2 : WriteOdt.sTextCtrlCommon) {
                    int n5 = string3.indexOf(stringArray2[2], n2);
                    if (n5 < 0 || n5 >= n3 - 1) continue;
                    if (stringArray2.length > 3) {
                        int n6 = string3.indexOf(stringArray2[3], n5 + 1);
                        if (n6 <= 0 || n <= n5) continue;
                        n = n5;
                        n4 = n6 + stringArray2[3].length();
                        stringArray = stringArray2;
                        continue;
                    }
                    n = n5;
                    n4 = n5 + stringArray2[2].length();
                    stringArray = stringArray2;
                }
                if (n >= n3) continue;
                if (n > n2) {
                    this.wrAdoc(string3.substring(n2, n));
                }
                if (stringArray.length == 3) {
                    assert (n4 - n == stringArray[1].length());
                    this.wrAdoc((CharSequence)stringArray[2]);
                } else {
                    int n7 = string3.indexOf(43, n);
                    if (n7 >= n && n7 < n4) {
                        this.wrAdoc("pass:[");
                        this.wrAdoc(string3.substring(n, n4));
                        this.wrAdoc("]");
                    } else {
                        this.wrAdoc("+");
                        this.wrAdoc(string3.substring(n, n4));
                        this.wrAdoc("+");
                    }
                }
                n2 = n4;
            } while (n < n3);
            if (n2 < n3) {
                this.wrAdoc(string3.substring(n2));
            }
        } else {
            this.wrAdoc(string);
        }
        return null;
    }

    private void wrReplaceLastSpace(char c) {
        int n = this.sb.length() - 1;
        if (n >= 0 && this.sb.charAt(n) == ' ') {
            this.sb.setCharAt(n, c);
        }
    }

    private void wrAdoc(CharSequence charSequence) throws IOException {
        if (this.wra != null) {
            if (this.sba.length() > 2000) {
                this.wrBufferToFile(this.sba, this.wra, null, false);
            }
            if (charSequence == null) {
                this.sba.append("????");
            } else {
                int n = this.sba.length();
                this.sba.append(charSequence);
            }
        }
    }

    private void wrm(CharSequence charSequence) throws IOException {
        if (this.wr != null) {
            if (this.bInCodeBlock) {
                assert (this.sb.length() == 0);
                this.wr.append(charSequence);
                if (this.cmdArgs.bDebug && StringFunctions.indexOf((CharSequence)charSequence, (int)0, (int)-1, (char)'\n') >= 0) {
                    this.wr.flush();
                }
            } else {
                if (this.sb.length() > 2000) {
                    this.wrBufferToFile(this.sb, this.wr, null, false);
                }
                if (charSequence == null) {
                    this.sb.append("????");
                } else {
                    int n = this.sb.length();
                    this.sb.append(charSequence);
                }
            }
        }
    }

    private int searchLineBreak(boolean[] blArray, StringBuilder stringBuilder, int n, int n2, int n3, int n4) {
        int n5;
        String string;
        String string2 = stringBuilder.subSequence(n, n2).toString();
        int n6 = StringFunctions.indexOfAnyString((CharSequence)stringBuilder, (int)n, (int)n3, (CharSequence[])sNewlineCheck, null, null);
        if (n6 < 0 && (n6 = StringFunctions.lastIndexOfAnyString((CharSequence)stringBuilder, (int)n, (int)n4, (CharSequence[])sNewlineCheckBack, null)) < 0) {
            Debugutil.stop();
        }
        int n7 = blArray[0] ? n : StringFunctions.indexOf((CharSequence)stringBuilder, (int)n, (int)n2, (CharSequence)"<:@");
        blArray[0] = false;
        int n8 = n7;
        if (n7 > n && (n6 < 0 || n7 < n6) && (n8 = StringFunctions.lastIndexOfAnyString((CharSequence)stringBuilder, (int)n, (int)n7, (CharSequence[])sNewlineCheckBack, null)) < 0) {
            n8 = n;
        }
        String string3 = string = n6 <= 0 ? null : stringBuilder.substring(n, n6);
        if (n8 >= 0 && (n6 < 0 || n8 < n6)) {
            int n9;
            int n10;
            if (stringBuilder.substring(n7, n7 + 8).equals("<:@image")) {
                Debugutil.stop();
            }
            int n11 = n10 = (n9 = StringFunctions.indexOf((CharSequence)stringBuilder, (int)n7, (int)n2, (CharSequence)".>")) < 0 ? -1 : StringFunctions.indexOfAnyString((CharSequence)stringBuilder, (int)n9, (int)n2, (CharSequence[])sNewlineCheckBack, null, null);
            if (n10 > n2) {
                n10 = n2;
            }
            if (n6 < n10) {
                n6 = -1;
            }
            if (n10 < 0 || n10 > n3) {
                int n12 = n9 < n3 ? n9 : n4;
                n10 = StringFunctions.lastIndexOf((CharSequence)stringBuilder, (int)n7, (int)n12, (CharSequence)"::");
                if (n10 < 0) {
                    n10 = StringFunctions.indexOf((CharSequence)stringBuilder, (int)n7, (int)n9, (CharSequence)"::");
                }
                if (n10 > 0) {
                    n10 = n10 > n2 ? n2 : (n10 += 2);
                    blArray[0] = true;
                } else {
                    n10 = n9 + 2;
                }
            }
            String string4 = stringBuilder.substring(n8, n10 > n8 ? n10 : n6);
            if (n8 == n) {
                if (n6 >= n10) {
                    n5 = n6;
                } else if (n10 > 0) {
                    n5 = n10;
                } else {
                    this.log.writeWarning("WARNING line cannot break %s", new Object[]{stringBuilder.subSequence(n, n2)});
                    n5 = -1;
                }
            } else {
                n5 = n10 < 0 ? n8 : (n6 > 0 && n10 < n6 ? n6 : (n6 < 0 ? (n10 < n4 ? n10 : (n8 > n ? n8 : n10)) : ((n6 = StringFunctions.indexOfAnyString((CharSequence)stringBuilder, (int)n10, (int)n3, (CharSequence[])sNewlineCheck, null, null)) > 0 ? n6 : (n8 > n ? n8 : n10))));
            }
            if (n10 >= 0 && n6 >= 0 && n10 >= n6) {
                n6 = n8 <= n ? n10 : n8;
            }
        } else if (n6 == 0) {
            n5 = n6;
        } else if (n6 >= 0) {
            n5 = n6;
        } else {
            assert (n8 < 0);
            n6 = StringFunctions.lastIndexOfAnyString((CharSequence)stringBuilder, (int)n, (int)n4, (CharSequence[])sNewlineCheckBack, null);
            while (n6 > n && stringBuilder.charAt(n6 - 1) == '\\') {
                n6 = StringFunctions.lastIndexOfAnyString((CharSequence)stringBuilder, (int)n, (int)(n6 - 1), (CharSequence[])sNewlineCheckBack, null);
            }
            n5 = n6 > 0 ? n6 : n4;
        }
        if (n5 > n2) {
            Debugutil.stop();
        }
        return n5;
    }

    private void wrBufferToFile(StringBuilder stringBuilder, Writer writer, String[] stringArray, boolean bl) throws IOException {
        String string;
        int n;
        int n2 = 0;
        int n3 = stringBuilder.lastIndexOf("\n");
        boolean[] blArray = new boolean[1];
        while (n2 < n3) {
            int n4;
            int n5;
            int n6;
            n = n2 + this.cmdArgs.adocLineLengthFocus;
            if (n > n3) {
                n = n3 + 1;
            }
            if ((n6 = n2 + this.cmdArgs.adocLineSentence) > n3) {
                n6 = n3 + 1;
            }
            if ((n5 = n2 + this.cmdArgs.adocLineLength) > n3) {
                n5 = n3 + 1;
            }
            if ((n4 = this.searchLineBreak(blArray, stringBuilder, n2, n, n6, n5)) >= 0) {
                char c = stringBuilder.charAt(n4);
                if (c != '\n') {
                    if (c == ' ') {
                        stringBuilder.setCharAt(n4, '\n');
                    } else if (stringBuilder.charAt(n4 + 1) == ' ') {
                        stringBuilder.setCharAt(n4 + 1, '\n');
                    } else {
                        stringBuilder.insert(n4, '\n');
                        ++n3;
                    }
                }
                n2 = n4 + 1;
                continue;
            }
            n2 = n3;
        }
        if (bl) {
            string = "";
            n = stringBuilder.length();
            if (n > 0 && stringBuilder.charAt(n - 1) != '\n') {
                stringBuilder.append("\n");
            }
        } else {
            string = stringBuilder.subSequence(n3 + 1, stringBuilder.length()).toString();
            stringBuilder.delete(n3 + 1, stringBuilder.length());
        }
        writer.append(stringBuilder);
        writer.flush();
        if (stringArray != null) {
            stringArray[0] = stringBuilder.toString();
            if (string.length() > 0) {
                Debugutil.stop();
            }
        }
        stringBuilder.setLength(0);
        stringBuilder.append(string);
    }

    private void wrRep(CharSequence charSequence) throws IOException {
        if (this.wrRep != null) {
            this.wrRep.append(charSequence).append("\n");
        }
    }

    private void writeLabelRef() {
        String string;
        int n;
        if (this.cmdArgs.dirLabel != null && (n = (string = this.cmdArgs.sNameLabel).indexOf(42)) >= 0) {
            string = string.substring(0, n) + this.cmdArgs.sNameDoc + string.substring(n + 1);
            File file = new File(this.cmdArgs.dirLabel, string);
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                for (LabelRef labelRef : this.listLabelRef) {
                    Object object;
                    if (labelRef.sTitle == null && labelRef.sRefHeading != null) {
                        object = this.idxLabelRef.get(labelRef.sRefHeading);
                        labelRef.sTitle = ((LabelRef)object).sTitle;
                        labelRef.sPage = ((LabelRef)object).sPage;
                    }
                    if (labelRef.sTitle == null && labelRef.sRefNumPara != null) {
                        object = this.idxLabelRef.get(labelRef.sRefNumPara);
                        labelRef.sTitle = ((LabelRef)object).sTitle;
                        labelRef.sPage = ((LabelRef)object).sPage;
                    }
                    for (String string2 : labelRef.idxLabel.values()) {
                        ((Writer)outputStreamWriter).write(35);
                        outputStreamWriter.write(string2 == null ? "?" : string2);
                        ((Writer)outputStreamWriter).write(32);
                        outputStreamWriter.write(labelRef.sTitle == null ? "?" : labelRef.sTitle);
                        outputStreamWriter.write(" @");
                        outputStreamWriter.write(labelRef.sPage == null ? "?" : labelRef.sPage);
                        ((Writer)outputStreamWriter).write(10);
                    }
                }
            }
            catch (IOException iOException) {
                CharSequence charSequence = ExcUtil.exceptionInfo((CharSequence)"\nERROR writing label.txt", (Throwable)iOException, (int)0, (int)10);
                this.log.writeError(charSequence);
            }
            if (outputStreamWriter != null) {
                FileFunctions.close((Closeable)outputStreamWriter);
            }
        }
    }

    private String wrClose() throws IOException {
        if (this.sb.length() > 0) {
            this.wrBufferToFile(this.sb, this.wr, null, true);
        }
        this.wr.close();
        if (this.wrFrame != null) {
            this.wrFrame.close();
        }
        this.wr = null;
        if (this.sba.length() > 0) {
            this.wrBufferToFile(this.sba, this.wra, null, true);
        }
        if (this.wra != null) {
            this.wra.close();
            this.wra = null;
        }
        if (this.wrRep != null) {
            this.wrRep.close();
            this.wrRep = null;
        }
        return null;
    }

    static {
        int n = -1;
        for (String[] stringArray : WriteOdt.sTextCtrlCommon) {
            ReadOdt.sCheckReplace[++n] = stringArray;
        }
        for (String[] stringArray : WriteOdt.sTextReplace) {
            ReadOdt.sCheckReplace[++n] = stringArray;
        }
    }

    static class LabelRef {
        String sRefHeading;
        String sRefNumPara;
        Map<String, String> idxLabel;
        String sTitle;
        String sPage;

        public LabelRef(String string, String string2, List<String> list, String string3, String string4) {
            this.sRefHeading = string;
            this.sRefNumPara = string2;
            this.idxLabel = new TreeMap<String, String>();
            for (String string5 : list) {
                if (string5.equals("<:")) {
                    Debugutil.stop();
                }
                this.idxLabel.put(string5, string5);
            }
            this.sTitle = string3;
            this.sPage = string4;
        }
    }

    private static class GathWrText {
        List<XmlDataNode> ndsSpan = null;
        StyleOdt styleSpan1 = null;
        char whatlast = '\u0000';
        ListIterator<XmlDataNode> iterNodes;
        boolean bFollowLink = false;
        boolean bLinkWritten = false;
        XmlDataNode nodeLast = null;

        private GathWrText() {
        }
    }

    public static class CmdArgs
    extends TranslateOdtCommon.CommonArgs {
        File fAdoc;
        File fOutZmL;
        File XXdirMarkup;
        boolean bDebug;
        boolean h1file;
        File dirCreateCfgJavaData;
        File fWriteXmlStruct;
        String sCmdDifftool;
        File dirSavedZmL;
        String swwwRoot = "XXX";
        int adocLineLength = 105;
        int adocLineSentence = 140;
        int adocLineLengthFocus = 500;
        Arguments.Argument[] argList1 = new Arguments.Argument[]{new Arguments.Argument("-odt", ":<path/file.odt>  odt file for input", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                return this.arg_odt(string);
            }
        }), new Arguments.Argument("-asciidoc", ":<path/file.txt>  file for output", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                TranslateOdtCommon.CommonArgs.DirName dirName = this.getDirNameReplaceSrcCmpn(string);
                fAdoc = new File(dirName.dir, dirName.name);
                return fAdoc.getParentFile().exists();
            }
        }), new Arguments.Argument("-ZmL", ":<path/file.txt>  ", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                TranslateOdtCommon.CommonArgs.DirName dirName = this.getDirNameReplaceSrcCmpn(string);
                dirZml = dirName.dir.getAbsoluteFile();
                int n = dirName.name.indexOf(46);
                sExtZmL = dirName.name.substring(n);
                fOutZmL = new File(dirZml, dirName.name).getAbsoluteFile();
                FileFunctions.mkDir((File)dirName.dir);
                return dirName.dir.exists();
            }
        }), new Arguments.Argument("-www", ":<wwwRoot>>  root for www access to replace operation link anchors", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                swwwRoot = string;
                return true;
            }
        }), new Arguments.Argument("-h1file", " If given writes an extra file per H1-level chapter", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                h1file = true;
                return true;
            }
        }), new Arguments.Argument("-genJavaData", ":<path>  Generates new versions of Java data in pkg path from -analyzeXmlStruct or from given XmlCfg", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws IOException {
                File file = new File(string).getAbsoluteFile();
                if (!file.exists() || !file.isDirectory()) {
                    return this.errMsg("-genJavaData:%s ERROR not found as directory", new Object[]{file});
                }
                dirCreateCfgJavaData = file;
                return true;
            }
        }), new Arguments.Argument("-analyzeXmlStruct", ":D:/path/to/xmlCfg.txt optional, first analyze the input xml data and generate a new XmlCfg text file", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                fWriteXmlStruct = new File(string);
                File file = fWriteXmlStruct.getParentFile();
                FileFunctions.mkDir((File)file);
                return file.exists();
            }
        }), new Arguments.Argument("-debug", " set internal Flag for debugging", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                bDebug = true;
                return true;
            }
        }), new Arguments.Argument("-difftool", ":viewdiff.bat path to the diff tool called after all is finished", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                sCmdDifftool = string;
                return true;
            }
        }), new Arguments.Argument("-dirSavedZmL", ":path/to/cmp  used as second argument dir for diff tool only, the saved ZmL files", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                dirSavedZmL = this.getDirRepaceSrcCmpn(string);
                return dirSavedZmL.exists();
            }
        })};

        CmdArgs() {
            this.aboutInfo = "...Reader content from odg for FunctionBlockGrafic";
            this.helpInfo = "obligate args: -o:... ...input";
            for (Arguments.Argument argument : this.argListCommon) {
                this.addArg(argument);
            }
            for (Arguments.Argument argument : this.argList1) {
                this.addArg(argument);
            }
        }

        protected boolean arg_odt(String string) {
            this.fIn = new File(string).getAbsoluteFile();
            boolean bl = this.fIn.exists();
            if (bl) {
                this.dirIn = this.fIn.getParentFile();
                String string2 = this.fIn.getName();
                int n = string2.indexOf("++");
                int n2 = string2.lastIndexOf(46);
                if (n > 0) {
                    this.sDirSrcCmpn = string2.substring(0, n);
                    this.sNameDoc = string2.substring(n + 2, n2);
                } else {
                    this.sNameDoc = string2.substring(0, n2);
                }
            }
            return bl;
        }

        public boolean testConsistence(Appendable appendable) {
            boolean bl = true;
            if (!bl) {
                super.showHelp(appendable);
            }
            return bl;
        }
    }
}

