/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.odt.readOdt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.odt.readOdt.WriteOdt;
import org.vishia.util.Debugutil;
import org.vishia.util.FileFunctions;
import org.vishia.util.StringFunctions;

public class GetJavadocLabel {
    private LogMessage log;
    Map<String, Map<String, String>> idxHtmlFilesAnchors = new TreeMap<String, Map<String, String>>();
    Map<String, Link> idxClass2Html = new TreeMap<String, Link>();

    GetJavadocLabel(LogMessage logMessage) {
        this.log = logMessage;
    }

    Map<String, String> createHtmlAnchorOperations(String string, File file) throws IOException {
        String string2;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(file, string)));
        while ((string2 = bufferedReader.readLine()) != null) {
            int n;
            if (!string2.startsWith("<a name=\"") || (n = StringFunctions.indexAfterIdentifier((CharSequence)string2, (int)9, (int)-1, null)) <= 0 || string2.charAt(n) != '-') continue;
            String string3 = string2.charAt(n + 1) == '-' ? string2.substring(9, n) + "()" : string2.substring(9, n);
            int n2 = string2.indexOf(34, n);
            String string4 = string2.substring(9, n2);
            String string5 = (String)treeMap.get(string3);
            if (string5 != null) {
                this.log.writeInfo("Info: operation twice: %s", new Object[]{string5});
                treeMap.put(string3, string5 + "?");
                continue;
            }
            treeMap.put(string3, string4);
        }
        bufferedReader.close();
        this.idxHtmlFilesAnchors.put(string, treeMap);
        return treeMap;
    }

    void analyzeAllJavadocFiles(List<WriteOdt.DirPrepareJavadoc> list, File file) throws IOException {
        for (WriteOdt.DirPrepareJavadoc dirPrepareJavadoc : list) {
            String string = FileFunctions.normalizePath((CharSequence)dirPrepareJavadoc.dirBase.getPath()) + "/";
            String string2 = ":" + dirPrepareJavadoc.sLocal + "/**/*.html";
            LinkedList linkedList = new LinkedList();
            boolean bl = true;
            FileFunctions.addFilesWithBasePath((File)dirPrepareJavadoc.dirBase, (String)string2, linkedList, (boolean)bl);
            if (linkedList.size() == 0) {
                this.log.writef("\nERROR no files found for anylyzeAllJavadocFiles(): %s:%s", new Object[]{string, dirPrepareJavadoc.sLocal});
            }
            for (FileFunctions.FileAndBasePath fileAndBasePath : linkedList) {
                int[] nArray;
                String string3 = fileAndBasePath.file.getName();
                if (!string3.endsWith(".html") || !Character.isUpperCase(string3.charAt(0))) continue;
                String string4 = fileAndBasePath.localPath;
                int n = string4.length() - 5;
                nArray = new int[]{string4.lastIndexOf(47), string4.lastIndexOf(47, nArray[0] - 1), string4.lastIndexOf(47, nArray[1] - 1)};
                for (int i = 0; i < nArray.length; ++i) {
                    String string5 = string4.substring(nArray[i] + 1, n);
                    Link link = new Link();
                    link.sLocal = "./" + string + fileAndBasePath.localPath;
                    link.sWWW = dirPrepareJavadoc.swww + "/" + fileAndBasePath.localPath;
                    this.idxClass2Html.put(string5, link);
                }
            }
            Debugutil.stop();
        }
    }

    public void reportClassesJavadoc(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        for (Map.Entry<String, Link> entry : this.idxClass2Html.entrySet()) {
            String string = entry.getKey();
            Link link = entry.getValue();
            ((Writer)fileWriter).append(string).append(":    ").append(link.sLocal).append("   @").append(link.sWWW).append("\n");
        }
        ((Writer)fileWriter).close();
    }

    static class Link {
        String sLocal;
        String sWWW;

        Link() {
        }
    }
}

