/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.libOffc.cfgui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.vishia.libOffc.cfgui.WriteKeyAcclPrc;
import org.vishia.libOffc.cfgui.XmlDataLOffcKeyAccl_Zbnf;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.LogMessageStream;
import org.vishia.util.Arguments;
import org.vishia.util.FileFunctions;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlJzReader;

public class WriteKeyAccl {
    final CmdArgs cmdArgs;
    private XmlCfg xmlCfg = new XmlCfg(true);
    private XmlJzReader xmlReader = new XmlJzReader();
    private final WriteKeyAcclPrc evalPrc;

    public static void main(String[] stringArray) {
        try {
            int n = WriteKeyAccl.smain(stringArray, System.out, System.err);
            System.exit(n);
        }
        catch (Exception exception) {
            System.err.println("Unexpected: " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(255);
        }
    }

    public static int smain(String[] stringArray, Appendable appendable, Appendable appendable2) throws IOException {
        CmdArgs cmdArgs = new CmdArgs();
        if (stringArray.length == 0) {
            cmdArgs.showHelp(appendable);
            return 1;
        }
        if (!cmdArgs.parseArgs(stringArray, appendable2) || !cmdArgs.testConsistence(appendable2)) {
            return 2;
        }
        int n = WriteKeyAccl.amain(cmdArgs);
        if (n != 0) {
            System.out.printf(" EXIT-code=%d", n);
        }
        System.out.println();
        return n;
    }

    public static int amain(CmdArgs cmdArgs) throws IOException {
        WriteKeyAccl writeKeyAccl = new WriteKeyAccl(cmdArgs);
        int n = writeKeyAccl.execute();
        return n;
    }

    public WriteKeyAccl(CmdArgs cmdArgs) {
        this.cmdArgs = cmdArgs;
        this.evalPrc = new WriteKeyAcclPrc(this.cmdArgs);
    }

    public int execute() throws IOException {
        int n = 0;
        FileOutputStream fileOutputStream = this.cmdArgs.fLog == null ? null : new FileOutputStream(this.cmdArgs.fLog);
        LogMessageStream logMessageStream = new LogMessageStream((OutputStream)fileOutputStream, (OutputStream)System.out, null, (Appendable)System.err, false, Charset.forName("UTF-8"));
        this.evalPrc.init((LogMessage)logMessageStream);
        this.xmlCfg.readFromJar(this.getClass(), "KeyboardAccl.xml.cfg", (LogMessage)logMessageStream);
        this.xmlReader.setCfg(this.xmlCfg);
        this.xmlReader.setNamespaceEntry("xml", "XML");
        XmlDataLOffcKeyAccl_Zbnf xmlDataLOffcKeyAccl_Zbnf = new XmlDataLOffcKeyAccl_Zbnf();
        for (File file : this.cmdArgs.fInKeyboardCfg) {
            String string;
            if (this.cmdArgs.dirDbg != null) {
                try {
                    string = file.getName();
                    this.xmlReader.openXmlTestOut(new File(this.cmdArgs.dirDbg, string + "-back.xml"));
                }
                catch (IOException iOException) {
                    logMessageStream.writeError("\nWARNING cannot open debug/*-back.xml", (Throwable)iOException);
                }
            }
            string = "Configurations2/accelerator/current.xml";
            logMessageStream.writef("\nreads accelerator key XML from %s, \n  internal in zip: '%s' ...", new Object[]{file, string});
            String string2 = this.xmlReader.readZipXml(file, string, (Object)xmlDataLOffcKeyAccl_Zbnf);
            if (string2 != null) {
                logMessageStream.writeError("\nERROR reading xml file %s: %s", new Object[]{file.getPath(), string2});
                n = 4;
                continue;
            }
            logMessageStream.writeInfo((CharSequence)" done");
            n = this.evalPrc.exec(xmlDataLOffcKeyAccl_Zbnf.dataroot, file, (LogMessage)logMessageStream);
        }
        logMessageStream.close();
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
        return n;
    }

    public static class CmdArgs
    extends Arguments {
        List<File> fInKeyboardCfg = new LinkedList<File>();
        File fLog;
        File dirLOffcPrg;
        File dirLOffcUser;
        File dirDbg;
        FileFunctions.FilePathnameExt fpOutText;
        File file_gTxt;
        boolean bShFollow;
        Arguments.Argument[] argList1 = new Arguments.Argument[]{new Arguments.Argument("-i", ":path/...Keyboard...cfg  File which is outputted on LOffc: Tools-Customize.Keyboard-Save", new Arguments.SetArgument(){

            public boolean setArgument(String string) {
                FileFunctions.addFileToList((String)string, fInKeyboardCfg);
                return true;
            }
        }), new Arguments.Argument("-o", ":path/to/*.txt  output in human readable form, if not given writes beside -i:...", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws IOException {
                fpOutText = FileFunctions.FilePathnameExt.parseDirWildcardName(null, (String)string);
                return true;
            }
        }), new Arguments.Argument("-LOffcPrg", ":/path/to/LibreOffice installation, where .../share/registry will be found.", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                dirLOffcPrg = new File(string);
                return true;
            }
        }), new Arguments.Argument("-LOffcUser", ":~/.config/libreoffice/4/user   user settings, where .../config/... will be found.", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                dirLOffcUser = new File(string);
                return true;
            }
        }), new Arguments.Argument("-gTxt", ":KeyAcclText.gTxt  gTxt script as template for the output", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                file_gTxt = FileFunctions.newFile((String)string);
                return true;
            }
        }), new Arguments.Argument("-log", ":path/to/log.txt  Logfile, additonal to console.out, err", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                File file = new File(string);
                File file2 = file.getParentFile();
                FileFunctions.mkDir((File)file2);
                fLog = file;
                return true;
            }
        }), new Arguments.Argument("-dirDebug", ":D:/path/to/xmlCfg.txt in given write debug info", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                dirDbg = new File(string);
                FileFunctions.mkDir((File)dirDbg);
                return dirDbg.exists();
            }
        }), new Arguments.Argument("-shfollow", " then the key with shift modifier follows immediately the key without shift", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                bShFollow = true;
                return true;
            }
        })};

        CmdArgs() {
            this.aboutInfo = "...Writes Key accelerators in human readable text form";
            this.helpInfo = "obligate args: -i:path/...Keyboard...cfg, -LOffcPrg:...";
            for (Arguments.Argument argument : this.argList1) {
                this.addArg(argument);
            }
        }

        public boolean testConsistence(Appendable appendable) throws IOException {
            if (this.fInKeyboardCfg.size() == 0) {
                this.showHelp(appendable);
                return false;
            }
            if (this.dirLOffcPrg == null) {
                appendable.append("-LOffcPrg: is not set, maybe faulty");
                this.showHelp(appendable);
            }
            if (this.fpOutText == null) {
                this.fpOutText = new FileFunctions.FilePathnameExt(null, "", ".txt");
            }
            return true;
        }
    }
}

