/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlReader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.CheckVs;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.ExcUtil;
import org.vishia.util.FileSystem;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringFunctions_B;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.util.StringPartScan;
import org.vishia.xmlReader.XmlAddData_ifc;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlSimple.XmlSequWriter;

public class XmlJzReader {
    public static final String version = "2024-05-23";
    XmlCfg cfg;
    final XmlCfg cfgCfg;
    private boolean bUseNonSemanticDataStore;
    private XmlCfg.XmlCfgNode cfgNodeNonSemanticDataStore;
    int sizeBuffer = 200000;
    private int debugStopLine = -1;
    private String debugTag = null;
    Map<String, String> namespaces = new TreeMap<String, String>();
    private final Map<String, String> replaceChars = new TreeMap<String, String>();
    XmlSequWriter xmlTestWriter;
    protected final LogMessage log;

    public XmlJzReader() {
        this(null);
    }

    public XmlJzReader(LogMessage logMessage) {
        this.log = logMessage;
        this.cfgCfg = XmlCfg.newCfgCfg();
        this.replaceChars.put("&amp;", "&");
        this.replaceChars.put("&lt;", "<");
        this.replaceChars.put("&gt;", ">");
        this.replaceChars.put("&quot;", "\"");
        this.replaceChars.put("&apos;", "'");
        this.replaceChars.put("&nl;", "\n");
        this.replaceChars.put("&cr;", "\r");
        this.replaceChars.put("&#9;", "\t");
        this.replaceChars.put("&#A;", "\n");
        this.replaceChars.put("&#D;", "\r");
        this.replaceChars.put("&#20;", " ");
        this.replaceChars.put("&auml;", "\u00e4");
        this.replaceChars.put("&ouml;", "\u00f6");
        this.replaceChars.put("&uuml;", "\u00fc");
        this.replaceChars.put("&Auml;", "\u00c4");
        this.replaceChars.put("&Ouml;", "\u00d6");
        this.replaceChars.put("&Uuml;", "\u00dc");
    }

    public void setDebugStop(int n) {
        this.debugStopLine = n;
    }

    public void setDebugStopTag(String string) {
        this.debugTag = string;
    }

    public void openXmlTestOut(File file) throws IOException {
        if (this.xmlTestWriter == null) {
            this.xmlTestWriter = new XmlSequWriter();
        }
        this.xmlTestWriter.open(file, "UTF-8", null);
    }

    public void setNamespaceEntry(String string, String string2) {
        this.namespaces.put(string, string2);
    }

    public String readXml(File file, Object object, XmlCfg xmlCfg) throws IOException {
        String string = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string2 = FileSystem.normalizePath(file.getAbsoluteFile()).toString();
            string = this.readXml(fileInputStream, string2, object, xmlCfg);
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("XmlJzReader.readXml(...) file not found: " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new IOException("XmlJzReader.readXml(...) any IO exception: " + file.getAbsolutePath());
        }
        return string;
    }

    public String readZipXml(File file, String string, Object object) {
        String string2 = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            String string3 = file.getAbsolutePath() + ":" + string;
            string2 = this.readXml(inputStream, string3, object, this.cfg);
            inputStream.close();
            zipFile.close();
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readXml(InputStream inputStream, String string, Object object, XmlCfg xmlCfg) {
        String string2 = null;
        try (StringPartScan stringPartScan = null;){
            stringPartScan = new StringPartFromFileLines(inputStream, string, this.sizeBuffer, "encoding", null);
            this.readXml(stringPartScan, object, xmlCfg);
        }
        return string2;
    }

    public void readXml(StringPartScan stringPartScan, Object object) throws Exception {
        this.readXml(stringPartScan, object, this.cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readXml(Reader reader, String string, Object object, XmlCfg xmlCfg) {
        String string2 = null;
        try (StringPartScan stringPartScan = null;){
            stringPartScan = new StringPartFromFileLines(reader, string, this.sizeBuffer);
            this.readXml(stringPartScan, object, xmlCfg);
        }
        return string2;
    }

    public void readXml(StringPartScan stringPartScan, Object object, XmlCfg xmlCfg) throws Exception {
        XmlCfg xmlCfg2 = xmlCfg != null ? xmlCfg : this.cfg;
        stringPartScan.setIgnoreWhitespaces(true);
        this.bUseNonSemanticDataStore = object instanceof XmlAddData_ifc;
        if (this.bUseNonSemanticDataStore) {
            this.cfgNodeNonSemanticDataStore = new XmlCfg.XmlCfgNode(null, this.cfg, "::NonSemanticNode");
        }
        while (stringPartScan.seekEnd("<").found()) {
            stringPartScan.scanStart();
            if (stringPartScan.scan("?").scanOk()) {
                stringPartScan.seekEnd("?>");
                stringPartScan.scanOk();
                continue;
            }
            if (stringPartScan.scan("!").scanOk()) {
                stringPartScan.seekEnd(">");
                stringPartScan.scanOk();
                continue;
            }
            if (stringPartScan.scan().scan("!--").scanOk()) {
                stringPartScan.seekEnd("-->");
                continue;
            }
            stringPartScan.scanOk();
            stringPartScan.readNextContent(this.sizeBuffer * 2 / 3);
            this.parseElement(stringPartScan, object, xmlCfg2.rootNode, 100);
        }
        if (this.xmlTestWriter != null) {
            this.xmlTestWriter.close();
            this.xmlTestWriter = null;
        }
        Debugutil.stop();
    }

    private void parseElement(StringPartScan stringPartScan, Object object, XmlCfg.XmlCfgNode xmlCfgNode, int n) throws Exception {
        Object object2;
        DataAccess.DatapathElement datapathElement;
        DataAccess.DatapathElement datapathElement2;
        DataAccess.DatapathElement datapathElement3;
        DataAccess.DatapathElement datapathElement4;
        Object object3;
        String string;
        Object object4;
        if (n <= 0) {
            throw new IllegalArgumentException("too many recursions in XML node");
        }
        int n2 = -7777;
        if (this.debugStopLine >= 0 && (n2 = stringPartScan.getLineAndColumn(null)) == this.debugStopLine) {
            Debugutil.stop();
        }
        if (!stringPartScan.scanIdentifier(null, "-:.").scanOk()) {
            throw new IllegalArgumentException("tag name expected");
        }
        String string2 = stringPartScan.getLastScannedString().toString();
        if (this.debugTag != null && string2.equals(this.debugTag)) {
            Debugutil.stop();
        }
        if (this.xmlTestWriter != null) {
            this.xmlTestWriter.writeElement(string2);
        }
        if (string2.contains("   ")) {
            Debugutil.stop();
        }
        if (string2.equals("Object")) {
            Debugutil.stop();
        }
        if (this.bUseNonSemanticDataStore) {
            object4 = this.cfgNodeNonSemanticDataStore;
        } else if (xmlCfgNode == null) {
            object4 = null;
        } else {
            if (object == null) {
                Debugutil.stop();
            }
            CheckVs.check(object != null);
            if (string2.toString().contains("   ")) {
                Debugutil.stop();
            }
            if (string2.toString().startsWith("text:p") && stringPartScan.getCurrentPart(38).toString().startsWith(" text:style-name=\"P268\"")) {
                Debugutil.stop();
            }
            if (xmlCfgNode.subnodes == null) {
                object4 = null;
            } else {
                object4 = xmlCfgNode.subnodes.get(string2);
                if (object4 == null) {
                    object4 = xmlCfgNode.subnodes.get("?");
                }
            }
            if (string2.toString().contains("   ")) {
                Debugutil.stop();
            }
        }
        Map<String, DataAccess.IntegerIx> map = null;
        String[] stringArray = null;
        List[] listArray = new List[1];
        List[] listArray2 = new List[1];
        if (n2 == this.debugStopLine) {
            Debugutil.stop();
        }
        if ((string = this.parseAttributes(stringPartScan, string2, (XmlCfg.XmlCfgNode)object4, listArray, listArray2)).length() > string2.length()) {
            Object object5 = object4 = xmlCfgNode.subnodes == null ? null : xmlCfgNode.subnodes.get(string);
        }
        if (object4 != null) {
            if (((XmlCfg.XmlCfgNode)object4).cfgSubtreeName != null) {
                object3 = null;
                object3 = this.cfg.subtrees.get(((XmlCfg.XmlCfgNode)object4).cfgSubtreeName);
                datapathElement4 = ((XmlCfg.XmlCfgNode)object4).elementCreatePath != null ? ((XmlCfg.XmlCfgNode)object4).elementCreatePath : ((XmlCfg.XmlCfgNode)object3).elementCreatePath;
                datapathElement3 = ((XmlCfg.XmlCfgNode)object4).elementFinishPath != null ? ((XmlCfg.XmlCfgNode)object4).elementFinishPath : ((XmlCfg.XmlCfgNode)object3).elementFinishPath;
                datapathElement2 = ((XmlCfg.XmlCfgNode)object4).contentStorePath != null ? ((XmlCfg.XmlCfgNode)object4).contentStorePath : ((XmlCfg.XmlCfgNode)object3).contentStorePath;
                datapathElement = ((XmlCfg.XmlCfgNode)object4).nameSpaceDef != null ? ((XmlCfg.XmlCfgNode)object4).nameSpaceDef : ((XmlCfg.XmlCfgNode)object3).nameSpaceDef;
                object4 = object3;
            } else {
                datapathElement4 = ((XmlCfg.XmlCfgNode)object4).elementCreatePath;
                datapathElement3 = ((XmlCfg.XmlCfgNode)object4).elementFinishPath;
                datapathElement2 = ((XmlCfg.XmlCfgNode)object4).contentStorePath;
                datapathElement = ((XmlCfg.XmlCfgNode)object4).nameSpaceDef;
            }
            map = ((XmlCfg.XmlCfgNode)object4).allArgNames;
            if (((XmlCfg.XmlCfgNode)object4).allArgNames != null) {
                stringArray = new String[((XmlCfg.XmlCfgNode)object4).allArgNames.size()];
                object3 = ((XmlCfg.XmlCfgNode)object4).allArgNames.get("tag");
                if (object3 != null) {
                    stringArray[((DataAccess.IntegerIx)object3).ix] = string2;
                }
            }
        } else {
            datapathElement4 = null;
            datapathElement3 = null;
            datapathElement2 = null;
            datapathElement = null;
        }
        if (object4 == null) {
            Debugutil.stop();
        }
        if (this.bUseNonSemanticDataStore) {
            if (listArray[0] == null) {
                object2 = null;
            } else {
                object2 = new TreeMap<String, String>();
                for (Object object6 : listArray[0]) {
                    object2.put((String)((AttribToStore)object6).name, (String)((AttribToStore)object6).value);
                }
            }
            object3 = ((XmlAddData_ifc)object).newNode(string2, (Map<String, String>)object2);
        } else {
            if (listArray[0] != null) {
                this.storeAttributesDueToSubCfgNode((XmlCfg.XmlCfgNode)object4, listArray[0], listArray2[0], ((XmlCfg.XmlCfgNode)object4).allArgNames, stringArray);
            }
            Object object7 = object4 == null ? null : (object3 = datapathElement4 == null ? object : this.getDataForTheElement(object, datapathElement4, stringArray));
            if (xmlCfgNode != null && xmlCfgNode.subnodes != null && object4 == null) {
                Debugutil.stop();
            }
            if (listArray[0] != null) {
                if (object3 == null) {
                    System.err.print("\nProblem storing attribute values, getDataForTheElement \"" + ((XmlCfg.XmlCfgNode)object4).elementCreatePath + "\" returns null");
                } else {
                    for (Object object8 : listArray[0]) {
                        if (((AttribToStore)object8).daccess == null) continue;
                        this.storeAttrData(stringPartScan, object3, ((AttribToStore)object8).daccess, ((XmlCfg.XmlCfgNode)object4).allArgNames, ((AttribToStore)object8).name, ((AttribToStore)object8).value, string2);
                    }
                }
            }
            if (listArray2[0] != null) {
                if (object3 == null) {
                    System.err.print("\nProblem storing attribute values, getDataForTheElement \"" + ((XmlCfg.XmlCfgNode)object4).elementCreatePath + "\" returns null");
                } else {
                    for (Object object8 : listArray2[0]) {
                        if (((AttribToStore)object8).daccess == null) continue;
                        this.storeAttrData(stringPartScan, object3, ((AttribToStore)object8).daccess, ((XmlCfg.XmlCfgNode)object4).allArgNames, ((AttribToStore)object8).name, ((AttribToStore)object8).value, string2);
                    }
                }
            }
        }
        if (!stringPartScan.scan("/").scan(">").scanOk()) {
            Object object6;
            if (stringPartScan.scan(">").scanOk()) {
                if (this.xmlTestWriter != null) {
                    this.xmlTestWriter.writeElementHeadEnd(false);
                }
                boolean bl = false;
                do {
                    char c;
                    stringPartScan.readNextContent(this.sizeBuffer / 2);
                    if (stringPartScan.getCurrent(2).toString().startsWith(" <")) {
                        Debugutil.stop();
                    }
                    if ("\n\r".indexOf(c = stringPartScan.getCurrentChar()) >= 0) {
                        stringPartScan.seekNoWhitespace();
                    }
                    if ((c = stringPartScan.getCurrentChar()) != '<') {
                        object6 = new StringBuilder(100);
                        this.parseContent(stringPartScan, (StringBuilder)object6);
                        if (object6 != null && object3 != null) {
                            if (this.bUseNonSemanticDataStore) {
                                ((XmlAddData_ifc)object3).addText(((StringBuilder)object6).toString());
                            } else {
                                assert (((XmlCfg.XmlCfgNode)object4).allArgNames != null);
                                DataAccess.IntegerIx integerIx = ((XmlCfg.XmlCfgNode)object4).allArgNames.get("text");
                                if (integerIx != null) {
                                    stringArray[integerIx.ix] = ((StringBuilder)object6).toString();
                                }
                            }
                            XmlJzReader.storeContent((StringBuilder)object6, (XmlCfg.XmlCfgNode)object4, object3, datapathElement2, ((XmlCfg.XmlCfgNode)object4).allArgNames, stringArray);
                        }
                    }
                    if (stringPartScan.scan("</").scanOk()) {
                        bl = true;
                        continue;
                    }
                    if (!stringPartScan.scan("<").scanOk()) continue;
                    if (stringPartScan.scan("!--").scanOk()) {
                        stringPartScan.seekEnd("-->");
                        continue;
                    }
                    if (stringPartScan.scan("![CDATA[").scanOk()) {
                        boolean bl2;
                        object6 = new StringBuilder(500);
                        do {
                            stringPartScan.lento("]]>");
                            bl2 = stringPartScan.found();
                            if (!bl2) {
                                stringPartScan.len0end().seekPos(-3);
                                ((StringBuilder)object6).append(stringPartScan.getCurrent());
                                stringPartScan.fromEnd();
                                stringPartScan.readNextContent(this.sizeBuffer / 2);
                                continue;
                            }
                            ((StringBuilder)object6).append(stringPartScan.getCurrent());
                            stringPartScan.fromEnd();
                        } while (!bl2 || stringPartScan.length() == 0);
                        stringPartScan.seekPos(3);
                        if (object6 == null || object3 == null) continue;
                        if (this.bUseNonSemanticDataStore) {
                            ((XmlAddData_ifc)object3).addText(((StringBuilder)object6).toString());
                        } else {
                            assert (map != null);
                            assert (map == ((XmlCfg.XmlCfgNode)object4).allArgNames);
                            DataAccess.IntegerIx integerIx = map.get("text");
                            if (integerIx != null) {
                                stringArray[integerIx.ix] = ((StringBuilder)object6).toString();
                            }
                        }
                        XmlJzReader.storeContent((StringBuilder)object6, (XmlCfg.XmlCfgNode)object4, object3, datapathElement2, ((XmlCfg.XmlCfgNode)object4).allArgNames, stringArray);
                        continue;
                    }
                    this.parseElement(stringPartScan, object3, (XmlCfg.XmlCfgNode)object4, n - 1);
                } while (!bl);
                stringPartScan.readNextContent(this.sizeBuffer / 2);
                if (!stringPartScan.scanIdentifier(null, "-:.").scanOk()) {
                    throw new IllegalArgumentException("</tag expected");
                }
                stringPartScan.setLengthMax();
                if (!stringPartScan.scan(">").scanOk()) {
                    throw new IllegalArgumentException("</tag > expected");
                }
            } else {
                object2 = new int[1];
                int n3 = stringPartScan.getLineAndColumn((int[])object2);
                object6 = stringPartScan.getInputfile();
                throw new IllegalArgumentException("either \">\" or \"/>\" expected,  in " + (String)object6 + " @" + n3 + ":" + (int)object2[0]);
            }
        }
        if (object3 != null) {
            this.finishElement(object, object3, datapathElement3);
        }
        stringPartScan.setLengthMax();
        if (this.xmlTestWriter != null) {
            this.xmlTestWriter.writeElementEnd();
        }
    }

    private String parseAttributes(StringPartScan stringPartScan, String string, XmlCfg.XmlCfgNode xmlCfgNode, List<AttribToStore>[] listArray, List<AttribToStore>[] listArray2) throws Exception {
        StringBuilder stringBuilder = null;
        while (stringPartScan.scanIdentifier(null, "-:").scan("=").scanOk()) {
            String string2 = stringPartScan.getLastScannedString();
            if (!stringPartScan.scanQuotion("\"", "\"", null).scanOk()) {
                throw new IllegalArgumentException("attr value expected");
            }
            if (xmlCfgNode != null) {
                Object object;
                Object object2;
                int n;
                Object var9_9;
                String string3 = this.replaceSpecialCharsInText(stringPartScan.getLastScannedString()).toString();
                if (this.xmlTestWriter != null) {
                    this.xmlTestWriter.writeAttribute(string2.toString(), string3);
                }
                if ((var9_9 = null) != null && string2.equals(var9_9)) {
                    Debugutil.stop();
                }
                if ((n = StringFunctions.indexOf((CharSequence)string2, ':')) >= 0) {
                    String string4;
                    String string5;
                    object2 = string2.subSequence(0, n);
                    CharSequence charSequence = string2.subSequence(n + 1, string2.length());
                    if (StringFunctions.equals((CharSequence)object2, "xmlns")) {
                        string5 = string3.toString();
                        string4 = charSequence.toString();
                        this.namespaces.put(string4, string5);
                        if (listArray2[0] == null) {
                            listArray2[0] = new LinkedList<AttribToStore>();
                        }
                        listArray2[0].add(new AttribToStore(xmlCfgNode.nameSpaceDef, string4, string5));
                        object = null;
                    } else {
                        string5 = this.namespaces.get(object2.toString());
                        if (string5 == null && object2.equals("xml")) {
                            string5 = "http://www.w3.org/1999/xml";
                        }
                        if (string5 == null) {
                            this.errMsg(1, stringPartScan, new CharSequence[]{"XmlJzReader-Namespace of attribute not found: ", object2});
                            object = null;
                        } else {
                            object = xmlCfgNode.cfg.xmlnsAssign != null ? ((string4 = xmlCfgNode.cfg.xmlnsAssign.get(string5)) == null ? null : string4 + ":" + charSequence) : string2;
                        }
                    }
                } else {
                    object = string2;
                }
                if (object != null) {
                    object2 = this.getCfgAttrib((CharSequence)object, xmlCfgNode);
                    if (listArray[0] == null && (object2 != null && !((XmlCfg.AttribDstCheck)object2).bUseForCheck || xmlCfgNode.attribsUnspec != null || this.bUseNonSemanticDataStore)) {
                        listArray[0] = new LinkedList<AttribToStore>();
                    }
                    if (object2 != null) {
                        if (((XmlCfg.AttribDstCheck)object2).bUseForCheck) {
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder(64);
                                stringBuilder.append(string);
                            }
                            stringBuilder.append("@").append((CharSequence)object).append("=\"").append(string3).append("\"");
                        } else {
                            listArray[0].add(new AttribToStore(((XmlCfg.AttribDstCheck)object2).daccess, object.toString(), string3));
                        }
                    } else if (this.bUseNonSemanticDataStore || xmlCfgNode.attribsUnspec != null) {
                        listArray[0].add(new AttribToStore(xmlCfgNode.attribsUnspec, object.toString(), string3));
                    } else {
                        if (listArray[0] == null) {
                            listArray[0] = new LinkedList<AttribToStore>();
                        }
                        listArray[0].add(new AttribToStore(null, object.toString(), string3));
                    }
                }
            }
            stringPartScan.readNextContent(this.sizeBuffer / 2);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    private XmlCfg.AttribDstCheck getCfgAttrib(CharSequence charSequence, XmlCfg.XmlCfgNode xmlCfgNode) {
        XmlCfg.AttribDstCheck attribDstCheck = null;
        if (xmlCfgNode.attribs != null && (attribDstCheck = xmlCfgNode.attribs.get(charSequence.toString())) == null) {
            attribDstCheck = xmlCfgNode.attribs.get("?");
        }
        return attribDstCheck;
    }

    private void storeAttributesDueToSubCfgNode(XmlCfg.XmlCfgNode xmlCfgNode, List<AttribToStore> list, List<AttribToStore> list2, Map<String, DataAccess.IntegerIx> map, String[] stringArray) {
        assert (map == xmlCfgNode.allArgNames);
        for (AttribToStore attribToStore : list) {
            XmlCfg.AttribDstCheck attribDstCheck = this.getCfgAttrib(attribToStore.name, xmlCfgNode);
            if (attribDstCheck != null) {
                if (attribDstCheck.storeInMap != null) {
                    DataAccess.IntegerIx integerIx = map.get(attribDstCheck.storeInMap);
                    if (integerIx != null) {
                        stringArray[integerIx.ix] = attribToStore.value;
                        continue;
                    }
                    Debugutil.stop();
                    continue;
                }
                if (attribDstCheck.daccess == null || attribToStore.daccess != null) continue;
                attribToStore.daccess = attribDstCheck.daccess;
                continue;
            }
            if (xmlCfgNode.attribsUnspec == null) continue;
            attribToStore.daccess = xmlCfgNode.attribsUnspec;
        }
    }

    Object getDataForTheElement(Object object, DataAccess.DatapathElement datapathElement, String[] stringArray) {
        Object object2;
        if (datapathElement == null) {
            object2 = object;
        } else {
            try {
                object2 = datapathElement.isOperation() ? DataAccess.invokeMethod(datapathElement, null, object, true, stringArray, false) : DataAccess.access(datapathElement, object, true, false, null, (Object[])stringArray, false, null);
            }
            catch (Exception exception) {
                object2 = null;
                CharSequence charSequence = CheckVs.exceptionInfo("", exception, 1, 30);
                System.err.print("\nerror getDataForTheElement: " + datapathElement);
                System.err.print("\nhelp: ");
                System.err.println(charSequence);
            }
        }
        if (object2 == null) {
            Debugutil.stop();
        }
        return object2;
    }

    void finishElement(Object object, Object object2, DataAccess.DatapathElement datapathElement) {
        if (datapathElement != null) {
            try {
                Object[] objectArray = new Object[2];
                objectArray[1] = object2;
                if (datapathElement.isOperation()) {
                    DataAccess.invokeMethod(datapathElement, null, object, true, objectArray, false);
                }
            }
            catch (Exception exception) {
                CharSequence charSequence = CheckVs.exceptionInfo("", exception, 1, 30);
                System.err.print("\nerror finishElement: " + datapathElement);
                System.err.print("help: ");
                System.err.println(charSequence);
            }
        } else if (this.bUseNonSemanticDataStore) {
            ((XmlAddData_ifc)object).addNode((XmlAddData_ifc)object2);
        }
    }

    private void storeAttrData(StringPartScan stringPartScan, Object object, DataAccess.DatapathElement datapathElement, Map<String, DataAccess.IntegerIx> map, CharSequence charSequence, CharSequence charSequence2, String string) {
        try {
            if (datapathElement.isOperation()) {
                Object object2;
                Object[] objectArray = null;
                if (map != null) {
                    objectArray = new String[map.size()];
                    object2 = map.entrySet().iterator();
                    while (object2.hasNext()) {
                        Map.Entry entry = (Map.Entry)object2.next();
                        String string2 = (String)entry.getKey();
                        int n = ((DataAccess.IntegerIx)entry.getValue()).ix;
                        if (string2.equals("name")) {
                            objectArray[n] = charSequence.toString();
                            continue;
                        }
                        if (string2.equals("value")) {
                            objectArray[n] = charSequence2.toString();
                            continue;
                        }
                        if (!string2.equals("tag")) continue;
                        objectArray[n] = string;
                    }
                }
                if ((object2 = DataAccess.invokeMethod(datapathElement, null, object, true, objectArray, true)) != null && object2 instanceof Field) {
                    ((Field)object2).set(object, charSequence2);
                }
            } else {
                DataAccess.storeValue(datapathElement, object, charSequence2, true);
            }
        }
        catch (Exception exception) {
            this.errMsg(1, stringPartScan, "error storeAttrData: ", exception.getMessage());
        }
    }

    private CharSequence parseContent(StringPartScan stringPartScan, StringBuilder stringBuilder) throws IOException, ParseException {
        boolean bl;
        boolean bl2 = false;
        CharSequence charSequence = null;
        do {
            int n;
            CharSequence charSequence2;
            stringPartScan.lento('<');
            boolean bl3 = bl = !stringPartScan.found();
            if (bl) {
                if (bl2) {
                    throw new IllegalArgumentException("Format error in XML file, missing \"<\", file: " + stringPartScan.getInputfile());
                }
                stringPartScan.setLengthMax();
            }
            if ((charSequence2 = stringPartScan.getCurrentPart()).charAt(0) == ' ') {
                Debugutil.stop();
            }
            if ((n = StringFunctions.indexOf(charSequence2, '\n')) > 0) {
                charSequence2 = StringFunctions_B.removeIndentReplaceNewline(charSequence2, 999, " \t", 8, "\r\n", false);
            }
            CharSequence charSequence3 = this.replaceSpecialCharsInText(charSequence2);
            if (this.xmlTestWriter != null) {
                this.xmlTestWriter.writeText(charSequence3, false);
            }
            stringPartScan.fromEnd();
            if (stringBuilder != null && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            if (stringBuilder != null) {
                stringBuilder.append(charSequence3);
                charSequence = stringBuilder;
            } else if (charSequence == null) {
                charSequence = charSequence3;
            } else {
                if (!(charSequence instanceof StringBuilder)) {
                    charSequence = new StringBuilder(charSequence);
                }
                ((StringBuilder)charSequence).append(charSequence3);
            }
            bl2 = stringPartScan.readNextContent(this.sizeBuffer / 2);
        } while (bl);
        stringPartScan.scanStart();
        return charSequence;
    }

    private static void storeContent(StringBuilder stringBuilder, XmlCfg.XmlCfgNode xmlCfgNode, Object object, DataAccess.DatapathElement datapathElement, Map<String, DataAccess.IntegerIx> map, String[] stringArray) {
        if (datapathElement != null) {
            try {
                if (datapathElement.isOperation()) {
                    if (xmlCfgNode.allArgNames != null) {
                        for (Map.Entry<String, DataAccess.IntegerIx> entry : xmlCfgNode.allArgNames.entrySet()) {
                            String string = entry.getKey();
                            int n = entry.getValue().ix;
                            if (!string.equals("text") || stringBuilder == null) continue;
                            stringArray[n] = stringBuilder.toString();
                        }
                    }
                    DataAccess.invokeMethod(datapathElement, null, object, true, stringArray, false);
                } else if (stringBuilder != null) {
                    DataAccess.storeValue(datapathElement, object, stringBuilder, true);
                }
            }
            catch (Exception exception) {
                CharSequence charSequence = ExcUtil.exceptionInfo("error XmlKzReader storeContent: ", exception, 0, 10);
                System.err.println(charSequence);
            }
        }
    }

    private CharSequence replaceSpecialCharsInText(CharSequence charSequence) throws ParseException {
        char c;
        int n;
        if (StringFunctions.contains(charSequence, "Comment of Network1xx")) {
            Debugutil.stop();
        }
        int n2 = -1;
        int n3 = n = charSequence.length();
        boolean bl = false;
        while (++n2 < n && "\n\r\t ".indexOf(c = charSequence.charAt(n2)) >= 0) {
            bl |= c == '\n' || c == '\r';
        }
        if (!bl) {
            n2 = 0;
        }
        while (--n3 >= n2 && "\n\r\t ".indexOf(c = charSequence.charAt(n3)) >= 0) {
            bl |= c == '\n' || c == '\r';
        }
        n3 = !bl ? n : ++n3;
        if (StringFunctions.indexOf(charSequence, '&') < 0 && n2 == 0 && n3 == n) {
            return charSequence;
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        if (n3 < n) {
            stringBuilder.delete(n3, n);
        }
        if (n2 > 0) {
            stringBuilder.delete(0, n2);
        }
        int n4 = 0;
        while ((n4 = StringFunctions.indexOf((CharSequence)stringBuilder, '&', n4)) >= 0) {
            int n5 = StringFunctions.indexOf((CharSequence)stringBuilder, ';', n4);
            String string = "";
            if (n5 > 0 && n5 - n4 < 11) {
                string = stringBuilder.subSequence(n4, n5 + 1).toString();
                String string2 = this.replaceChars.get(string);
                if (string2 == null) {
                    int n6;
                    block16: {
                        if (string.charAt(1) != '#') continue;
                        int n7 = 10;
                        int n8 = 2;
                        if (string.charAt(n8) == 'x') {
                            n7 = 16;
                            ++n8;
                        }
                        try {
                            n6 = Integer.parseUnsignedInt(string.substring(n8, n5 - n4), n7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n6 = 63;
                            if ($assertionsDisabled) break block16;
                            throw new AssertionError();
                        }
                    }
                    ++n5;
                    if (n6 == 10) {
                        int n9 = stringBuilder.length();
                        while (n5 < n9 && "\n\r \t".indexOf(stringBuilder.charAt(n5)) >= 0) {
                            ++n5;
                        }
                    }
                    char[] cArray = Character.toChars(n6);
                    stringBuilder.delete(n4, n5);
                    stringBuilder.insert(n4, cArray);
                    n4 += cArray.length;
                    continue;
                }
                if (string2 == null) continue;
                if (string2.equals("&")) {
                    Debugutil.stop();
                }
                stringBuilder.replace(n4, n5 + 1, string2);
                ++n4;
                continue;
            }
            throw new ParseException("faulty special Characters:" + string + "on #", n4);
        }
        n4 = 0;
        return stringBuilder;
    }

    private void errMsg(int n, StringPartScan stringPartScan, CharSequence ... charSequenceArray) {
        System.err.append("\n");
        for (CharSequence charSequence : charSequenceArray) {
            System.err.append(charSequence);
        }
        System.err.append(" @line:").append(Integer.toString(stringPartScan.getLineAndColumn(null)));
        System.err.append(stringPartScan.getCurrent(20)).append("...");
    }

    public XmlCfg readCfg(File file) throws IOException {
        XmlCfg xmlCfg = new XmlCfg(false);
        this.readXml(file, (Object)xmlCfg.rootNode, this.cfgCfg);
        xmlCfg.transferNamespaceAssignment(this.namespaces);
        xmlCfg.finishReadCfg();
        this.namespaces.clear();
        this.cfg = xmlCfg;
        return xmlCfg;
    }

    public void setCfg(XmlCfg xmlCfg) {
        this.cfg = xmlCfg;
    }

    public XmlCfg getCfg() {
        return this.cfg;
    }

    public XmlCfg readCfgFromJar(Class<?> clazz, String string) throws IOException {
        String string2 = "jar:" + string;
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string2);
        }
        XmlCfg xmlCfg = new XmlCfg();
        xmlCfg.readFromText = false;
        this.readXml(inputStream, string2, (Object)xmlCfg.rootNode, this.cfgCfg);
        inputStream.close();
        xmlCfg.transferNamespaceAssignment(this.namespaces);
        xmlCfg.writeToText(new File("T:/" + string + ".txt"), this.log);
        xmlCfg.finishReadCfg();
        this.cfg = xmlCfg;
        return xmlCfg;
    }

    public XmlCfg readCfgTxtFromJar(Class<?> clazz, String string) throws IOException {
        String string2 = "jar:" + string;
        XmlCfg xmlCfg = new XmlCfg();
        xmlCfg.readFromJar(clazz, string, this.log);
        xmlCfg.writeToText(new File("T:/" + string + ".txt"), this.log);
        xmlCfg.finishReadCfg();
        this.cfg = xmlCfg;
        return xmlCfg;
    }

    public String readXml(File file, Object object) throws IOException {
        return this.readXml(file, object, this.cfg);
    }

    public String readXml(InputStream inputStream, String string, Object object) {
        return this.readXml(inputStream, string, object, this.cfg);
    }

    public String readXml(Reader reader, String string, Object object) {
        return this.readXml(reader, string, object, this.cfg);
    }

    static class AttribToStore {
        DataAccess.DatapathElement daccess;
        final String name;
        final String value;

        AttribToStore(DataAccess.DatapathElement datapathElement, String string, String string2) {
            this.daccess = datapathElement;
            this.name = string;
            this.value = string2;
        }
    }
}

