/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.vishia.util.FilePath;

public final class FileSet {
    public static final String sVersion = "2017-09-01";
    private FilePath commonPath;
    private final List<FilePath> filesOfFileset = new ArrayList<FilePath>();

    public void set_commonPath(String string) {
        this.commonPath = new FilePath(string);
    }

    public void add_filePath(String string) {
        FilePath filePath = new FilePath(string);
        if (filePath.isNotEmpty()) {
            this.filesOfFileset.add(filePath);
        }
    }

    public void listFiles(List<FilePath> list, FilePath filePath, FilePath.FilePathEnvAccess filePathEnvAccess, boolean bl) throws NoSuchFieldException {
        this.listFiles(list, filePath, filePathEnvAccess, bl, 0);
    }

    private void listFiles(List<FilePath> list, FilePath filePath, FilePath.FilePathEnvAccess filePathEnvAccess, boolean bl, int n) throws NoSuchFieldException {
        for (FilePath filePath2 : this.filesOfFileset) {
            Object object;
            if (bl && (filePath2.someFiles() || filePath2.allTree())) {
                object = new LinkedList();
                filePath2.expandFiles(list, this.commonPath, filePath, filePathEnvAccess);
                continue;
            }
            object = new FilePath(filePath2, this.commonPath, filePath, filePathEnvAccess);
            FileSet fileSet = ((FilePath)object).isFileSet();
            if (fileSet != null) {
                if (n >= 100) {
                    throw new IllegalArgumentException("too many recurions, may be faulty: " + filePath2.toString());
                }
                fileSet.listFiles(list, filePath, filePathEnvAccess, bl, n + 1);
                continue;
            }
            list.add((FilePath)object);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.commonPath != null) {
            stringBuilder.append("commonPath=" + this.commonPath + ", ");
        }
        stringBuilder.append(this.filesOfFileset);
        return stringBuilder.toString();
    }
}

