/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.vishia.util.Arguments;
import org.vishia.util.FileFunctions;

public class FileAppend
implements Appendable,
Closeable,
Flushable {
    public static final String sVersion = "2022-01-17";
    protected Wr writer;
    public static final int kFileNotFound = -1;
    public static final int kFileOpenError = -2;
    public static final int kWriteError = -3;
    public String sError;
    private int error;

    public int open(String string, boolean bl) {
        int n = 0;
        try {
            String string2 = Arguments.replaceEnv(string);
            String string3 = FileFunctions.absolutePath(string2, null);
            this.writer = new Wr(new FileOutputStream(string3, bl));
        }
        catch (FileNotFoundException fileNotFoundException) {
            n = -1;
        }
        catch (Exception exception) {
            n = -2;
            this.sError = exception.getMessage();
        }
        return n;
    }

    public int open(String string, String string2, boolean bl) {
        int n = 0;
        try {
            String string3 = Arguments.replaceEnv(string);
            String string4 = FileFunctions.absolutePath(string3, null);
            this.writer = new Wr(new FileOutputStream(string4, bl), string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            n = -1;
        }
        catch (Exception exception) {
            n = -2;
            this.sError = exception.getMessage();
        }
        return n;
    }

    public boolean isOpen() {
        return this.writer != null;
    }

    @Override
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writer = null;
        }
    }

    public void write(String string) throws IOException {
        if (this.writer == null) {
            throw new IOException("file isn't opend");
        }
        this.writer.append(string);
    }

    @Override
    public Wr append(CharSequence charSequence) {
        return this.writer.append(charSequence);
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.writer.flush();
        }
    }

    public void finalize() {
        this.close();
    }

    public int getError() {
        return this.error;
    }

    @Override
    public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
        return this.writer.append(charSequence, n, n2);
    }

    @Override
    public Appendable append(char c) throws IOException {
        return this.writer.append(c);
    }

    public static class Wr
    implements Appendable {
        int error;
        OutputStreamWriter writer;

        public Wr(OutputStream outputStream) {
            this.writer = new OutputStreamWriter(outputStream);
        }

        public Wr(OutputStream outputStream, String string) throws UnsupportedEncodingException {
            this.writer = new OutputStreamWriter(outputStream, string);
        }

        @Override
        public Wr append(CharSequence charSequence) {
            return this.append(charSequence, 0, charSequence.length());
        }

        @Override
        public Wr append(CharSequence charSequence, int n, int n2) {
            try {
                this.writer.append(charSequence, n, n2);
            }
            catch (IOException iOException) {
                this.error = -3;
            }
            return this;
        }

        @Override
        public Wr append(char c) {
            try {
                this.writer.append(c);
            }
            catch (IOException iOException) {
                this.error = -3;
            }
            return this;
        }
    }
}

