/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.DataAccess;
import org.vishia.util.ExcUtil;
import org.vishia.util.FileFunctions;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPartScan;

public abstract class Arguments {
    public static final String sVersion = "2024-06-02";
    private static DateFormat formatDateYYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    private static DateFormat formatDateHHmm = new SimpleDateFormat("HH_mm_ss");
    protected String aboutInfo;
    protected String helpInfo;
    private List<Argument> argList;
    private List<Argument[]> argArrays;
    public static int exitCodeArgError = 6;
    private String sLogPath;
    private String sLogLevel;
    private Appendable outMsg;
    private Appendable errMsg;

    protected final void addArg(Argument argument) {
        if (this.argList == null) {
            this.argList = new LinkedList<Argument>();
        }
        this.argList.add(argument);
    }

    protected final void addArgs(Argument[] argumentArray) {
        if (this.argArrays == null) {
            this.argArrays = new LinkedList<Argument[]>();
        }
        this.argArrays.add(argumentArray);
    }

    public static String replaceEnv(String string) {
        String string2;
        int n;
        String string3;
        String string4;
        String string5 = string;
        if (string.startsWith("/tmp/") && (string4 = System.getenv("OS")) != null && string4.startsWith("Windows")) {
            string3 = System.getenv("TMP");
            if (string3 == null) {
                string3 = System.getenv("TEMP");
            }
            if (string3 != null) {
                string5 = string3 + string.substring(4);
            }
        }
        while ((n = string5.indexOf("$$")) >= 0) {
            int n2 = string5.indexOf(36, n + 2);
            string3 = string5.substring(n + 2, n2);
            string2 = Arguments.getEnv(string3);
            string5 = string5.substring(0, n) + string2 + string5.substring(n2 + 1);
        }
        while ((n = string5.indexOf("$(")) >= 0) {
            int n3 = string5.indexOf(41, n + 2);
            string3 = string5.substring(n + 2, n3);
            string2 = Arguments.getEnv(string3);
            string5 = string5.substring(0, n) + string2 + string5.substring(n3 + 1);
        }
        while ((n = string5.indexOf("$")) >= 0) {
            char c;
            int n4 = n;
            while (++n4 < string5.length() && Character.isJavaIdentifierPart(c = string5.charAt(n4))) {
            }
            int n5 = n4;
            String string6 = string5.substring(n + 1, n4);
            String string7 = Arguments.getEnv(string6);
            string5 = string5.substring(0, n) + string7 + string5.substring(n5);
        }
        return string5;
    }

    public static final String getEnv(String string) {
        String string2;
        if (string.equals("DATE")) {
            long l = System.currentTimeMillis();
            Date date = new Date(l);
            string2 = formatDateYYYYMMDD.format(date);
        } else if (string.equals("TIME")) {
            long l = System.currentTimeMillis();
            Date date = new Date(l);
            string2 = formatDateHHmm.format(date);
        } else {
            string2 = System.getenv(string);
            if (string2 == null) {
                string2 = System.getProperty(string);
            }
            if (string2 == null) {
                throw new IllegalArgumentException("Environment variable >>" + string + "<< expected, not found");
            }
        }
        return string2;
    }

    protected boolean testArgument(String string, int n) throws IOException {
        boolean bl = true;
        Argument argument = null;
        Argument argument2 = null;
        int n2 = 0;
        int n3 = string.length();
        String string2 = this.checkArgVal("--report", string);
        if (string2 != null) {
            this.sLogPath = string2;
        } else {
            string2 = this.checkArgVal("--rlevel", string);
            if (string2 != null) {
                this.sLogLevel = string2;
            } else {
                string2 = this.checkArgVal("--help", string);
                if (string2 != null) {
                    if (this.helpInfo != null) {
                        this.showHelp(this.outMsg);
                    }
                } else {
                    string2 = this.checkArgVal("--version", string);
                    if (string2 != null) {
                        if (this.aboutInfo != null) {
                            try {
                                this.outMsg.append(this.aboutInfo).append('\n');
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException("unexpected IOException: ", iOException);
                            }
                        }
                    } else if (!string.startsWith("---")) {
                        int n4;
                        if (this.argArrays != null) {
                            Iterator<Argument[]> iterator = this.argArrays.iterator();
                            while (argument2 == null && iterator.hasNext()) {
                                Argument[] argumentArray = iterator.next();
                                int n5 = argumentArray.length;
                                int n6 = -1;
                                while (argument2 == null && ++n6 < n5) {
                                    Argument argument3 = argumentArray[n6];
                                    n4 = argument3.option.length();
                                    if (n4 == 0) {
                                        argument = argument3;
                                        continue;
                                    }
                                    assert (n2 == 0);
                                    boolean bl2 = false;
                                    if (!string.startsWith(argument3.option) || n3 != n4 && !(bl2 = ":=".indexOf(string.charAt(n4)) >= 0) || n4 < n2) continue;
                                    n2 = bl2 ? n4 + 1 : n4;
                                    argument2 = argument3;
                                }
                            }
                        }
                        if (argument2 == null && this.argList != null) {
                            int n7 = 0;
                            int n8 = this.argList.size() - 1;
                            Iterator<Argument> iterator = this.argList.iterator();
                            while (argument2 == null && iterator.hasNext()) {
                                Argument argument4 = iterator.next();
                                int n9 = argument4.option.length();
                                if (n9 == 0) {
                                    argument = argument4;
                                } else {
                                    assert (n2 == 0);
                                    n4 = 0;
                                    if ((string.startsWith(argument4.option) && (n3 == n9 || (n4 = ":=".indexOf(string.charAt(n9)) >= 0 ? 1 : 0) != 0) || n9 == 0 && (n7 == n || n7 == n8)) && n9 >= n2) {
                                        n2 = n4 != 0 ? n9 + 1 : n9;
                                        argument2 = argument4;
                                    }
                                }
                                ++n7;
                            }
                        }
                        if (argument2 != null) {
                            String string3;
                            String string4 = string3 = n3 == n2 ? string : string.substring(n2);
                            if (string3.length() >= 2 && string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                                string3 = string3.substring(1, string3.length() - 1);
                            }
                            if (argument2.set == null) {
                                argument2.val = string3;
                            } else {
                                bl = argument2.set.setArgument(string3);
                            }
                        } else {
                            bl = argument != null ? argument.set.setArgument(string) : false;
                        }
                    }
                }
            }
        }
        return bl;
    }

    protected final boolean checkArg(String string, String string2) {
        return string2.equals(string);
    }

    protected final String checkArgVal(String string, String string2) {
        int n = string.length();
        if (string2.startsWith(string)) {
            if (string2.length() == n) {
                return "";
            }
            int n2 = " :=".indexOf(string2.charAt(n));
            if (n2 < 0) {
                return null;
            }
            while (n2 == 0 && string2.length() < ++n) {
                n2 = " :=".indexOf(string2.charAt(n));
            }
            if (n2 >= 0) {
                return string2.substring(n + 1);
            }
            return string2.substring(n);
        }
        return null;
    }

    public final boolean parseArgs(String[] stringArray) throws IOException {
        return this.parseArgs(stringArray, null);
    }

    public final boolean parseArgs(String[] stringArray, Appendable appendable) {
        boolean bl = true;
        this.errMsg = appendable;
        this.outMsg = appendable != null ? appendable : System.out;
        try {
            if (stringArray.length == 0 && this.helpInfo != null && this.helpInfo.startsWith("!")) {
                this.showHelp(this.outMsg);
            }
            bl = this.parseArgs(stringArray, 0);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return bl;
    }

    private final boolean parseArgs(String[] stringArray, int n) throws IOException {
        boolean bl = true;
        int n2 = -1;
        boolean bl2 = false;
        for (String string : stringArray) {
            if (bl2) {
                String[] stringArray2 = string.split("\n");
                this.parseArgs(stringArray2, n + 1);
                bl2 = false;
                continue;
            }
            if (string.equals("--@:")) {
                bl2 = true;
                continue;
            }
            if (string.startsWith("--@")) {
                String string2;
                String string3;
                String string4;
                int n3 = string.indexOf(58, 6);
                if (n3 > 0) {
                    string4 = string.substring(3, n3);
                    string3 = string.substring(n3 + 1);
                } else {
                    string4 = string.substring(3);
                    string3 = null;
                }
                BufferedReader bufferedReader = null;
                File file = null;
                String string5 = null;
                try {
                    boolean bl3;
                    String string6;
                    int n4;
                    file = FileFunctions.newFile(string4);
                    try {
                        bufferedReader = new BufferedReader(new FileReader(file));
                    }
                    catch (IOException iOException) {
                        if (this.errMsg != null) {
                            this.errMsg.append("  ERROR not found: --@" + file.getAbsolutePath());
                        }
                        throw new IOException(iOException);
                    }
                    if (bufferedReader == null) continue;
                    string5 = file.getParent();
                    if (string3 != null) {
                        int n5 = string3.length() + 5;
                        n4 = -1;
                        String string7 = "";
                        while (n4 < 0 && (string7 = bufferedReader.readLine()) != null) {
                            n4 = StringFunctions.indexOf((CharSequence)string7, 0, n5, string3);
                        }
                        if (n4 < 0) {
                            this.errMsg.append("  ERROR Arguments: label not found in ").append(string).append('\n');
                            n4 = 0;
                            string2 = null;
                            string6 = null;
                            bl3 = false;
                        } else {
                            string2 = string7.substring(0, n4);
                            int n6 = n4 + string3.length();
                            if (string7.length() > n6) {
                                string6 = string7.substring(n6).trim();
                                bl3 = string7.charAt(n6) == ' ';
                            } else {
                                string6 = null;
                                bl3 = false;
                            }
                        }
                    } else {
                        n4 = 0;
                        string2 = null;
                        string6 = null;
                        bl3 = false;
                    }
                    while ((string = bufferedReader.readLine()) != null && (string2 == null || string.startsWith(string2))) {
                        int n7;
                        String string8 = string.substring(n4);
                        int n8 = n7 = string6 == null ? -1 : string8.indexOf(string6);
                        if (n7 < 0 && bl3) {
                            n7 = string8.length();
                        }
                        if (n7 > 0) {
                            while (n7 > 0 && string8.charAt(n7 - 1) == ' ') {
                                --n7;
                            }
                            string8 = string8.substring(0, n7);
                        }
                        string8 = string8.replace("$=", string5);
                        if ((string8 = string8.replace("$!", string4)).length() <= 0 || this.tryTestArgument(string8, ++n2, this.errMsg, bufferedReader)) continue;
                        bl = false;
                    }
                    bufferedReader.close();
                    bufferedReader = null;
                    file = null;
                    continue;
                }
                catch (IOException iOException) {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        string2 = string + "  ERROR Arguments: " + (file != null ? " File=" + file.getAbsolutePath() : "") + iOException.getMessage();
                        if (this.errMsg == null) {
                            throw new IllegalArgumentException(string2);
                        }
                        this.errMsg.append(string2).append('\n');
                        bl = false;
                        continue;
                    }
                    catch (IOException iOException2) {
                        throw new RuntimeException(iOException2);
                    }
                }
            }
            if (this.tryTestArgument(string, ++n2, this.errMsg, null)) continue;
            bl = false;
        }
        return bl;
    }

    private final boolean tryTestArgument(String string, int n, Appendable appendable, Closeable closeable) throws IOException {
        boolean bl;
        CharSequence charSequence = "";
        String string2 = Arguments.replaceEnv(string);
        try {
            bl = this.testArgument(string2, n + 1);
        }
        catch (Exception exception) {
            charSequence = ExcUtil.exceptionInfo(" argument eval error: ", exception, 1, 20);
            bl = false;
        }
        if (!bl) {
            if (appendable != null) {
                appendable.append("  ERROR Arguments: ").append(string2).append(charSequence).append('\n');
            } else {
                if (closeable != null) {
                    closeable.close();
                }
                throw new IllegalArgumentException(string2 + charSequence);
            }
        }
        return bl;
    }

    protected boolean errMsg(String string, Object ... objectArray) throws IOException {
        String string2 = String.format(string, objectArray);
        if (this.errMsg != null) {
            this.errMsg.append(string2);
        } else {
            System.err.println(string2);
        }
        return false;
    }

    public void showHelp(Appendable appendable) {
        try {
            if (this.aboutInfo != null) {
                appendable.append(this.aboutInfo).append('\n');
            }
            int n = this.helpInfo.startsWith("!") ? 1 : 0;
            appendable.append(this.helpInfo.substring(n)).append('\n');
            for (Argument argument : this.argList) {
                appendable.append(argument.toString());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected IOException:", iOException);
        }
    }

    public String aboutInfo() {
        return this.aboutInfo;
    }

    public abstract boolean testConsistence(Appendable var1) throws IOException;

    public void readArguments(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                this.showHelp(System.out);
                System.exit(1);
            }
            if (!this.parseArgs(stringArray, System.err) || !this.testConsistence(System.err)) {
                System.exit(exitCodeArgError);
            }
        }
        catch (Exception exception) {
            System.err.println("Unexpected Exception: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(255);
        }
    }

    public String getLogPath() {
        return this.sLogPath;
    }

    public String getLogLevel() {
        return this.sLogLevel;
    }

    public static void readConfig(Object object, InputStream inputStream, String string, LogMessage logMessage) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            int n = string2.indexOf("//");
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            if ((string2 = string2.trim()).length() <= 0 || string != null && !string2.startsWith(string)) continue;
            Arguments.readConfig(object, string2, logMessage);
        }
    }

    public static void readConfig(Object object, String string, LogMessage logMessage) {
        StringPartScan stringPartScan = new StringPartScan(string);
        stringPartScan.setIgnoreWhitespaces(true);
        stringPartScan.scanStart();
        if (stringPartScan.scanIdentifier().scan("=").scanOk()) {
            String string2 = stringPartScan.getLastScannedString();
            stringPartScan.seekNoWhitespaceOrComments();
            String string3 = stringPartScan.getCurrentPart().toString();
            if (string3.endsWith(";")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            try {
                DataAccess.DatapathElement datapathElement = new DataAccess.DatapathElement(string2);
                DataAccess.storeValue(datapathElement, object, string3, true);
            }
            catch (ParseException parseException) {
                logMessage.writeError("ERROR readConfig variable may faulty: %s", string);
            }
            catch (Exception exception) {
                logMessage.writeError("ERROR readConfig Exception writing: " + string, exception);
            }
        }
    }

    public static final class Argument {
        public String val;
        public final String option;
        public final String help;
        protected final SetArgument set;

        public Argument(String string, String string2) {
            this.option = string;
            this.help = string2;
            this.set = null;
        }

        public Argument(String string, String string2, String string3) {
            this.val = string2;
            this.option = string;
            this.help = string3;
            this.set = null;
        }

        public Argument(String string, String string2, SetArgument setArgument) {
            this.option = string;
            this.help = string2;
            this.set = setArgument;
        }

        public String toString() {
            return this.option + this.help + '\n';
        }
    }

    public static interface SetArgument {
        public boolean setArgument(String var1) throws IOException;
    }
}

