/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.states;

import java.util.ArrayList;
import java.util.LinkedList;
import org.vishia.event.TimeOrder;
import org.vishia.states.StateCompositeFlat;
import org.vishia.states.StateParallel;
import org.vishia.states.StateSimple;
import org.vishia.util.Debugutil;

class PrepareTransition {
    public static final String version = "2015-12-20";
    final StateSimple.Trans trans;
    final StateSimple state;
    final ArrayList<StateSimple> dstStates;
    final StateSimple[] exitStates;
    int[] ixInStatePath;

    PrepareTransition(StateSimple stateSimple, StateSimple.Trans trans, StateSimple[] stateSimpleArray) {
        this.trans = trans;
        this.state = stateSimple;
        if (trans.dst == null) {
            this.dstStates = null;
            this.ixInStatePath = null;
        } else {
            this.dstStates = new ArrayList();
        }
        this.exitStates = stateSimpleArray;
    }

    void execute() {
        if (this.state.stateId.equals("StateParallel")) {
            Debugutil.stop();
        }
        if (this.trans.dst != null) {
            this.buildDstStates();
            this.searchStateCommon();
            this.buildExitPath();
            this.buildEntryStates();
        }
        if (this.trans instanceof StateSimple.Timeout) {
            this.state.transTimeout = (StateSimple.Timeout)this.trans;
            this.state.millisectimeout = this.state.transTimeout.millisec;
            this.searchOrCreateTimerEvent();
        }
    }

    private void buildDstStates() {
        for (int i = 0; i < this.trans.dst.length; ++i) {
            StateSimple stateSimple = this.state.stateMachine.stateMap.get(new Integer(this.trans.dst[i]));
            this.checkDefaultAddDstState(stateSimple, 0);
            if (stateSimple != null) continue;
            System.err.println("PrepareTransition.buildDstStates - dst state not found, " + this.trans);
        }
        this.ixInStatePath = new int[this.dstStates.size()];
    }

    private void checkDefaultAddDstState(StateSimple stateSimple, int n) {
        if (n > 100) {
            throw new IllegalArgumentException("internal recursion error");
        }
        if (stateSimple instanceof StateCompositeFlat) {
            this.checkDefaultAddDstState(((StateCompositeFlat)stateSimple).stateDefault, n + 1);
        } else if (stateSimple instanceof StateParallel) {
            for (StateSimple stateSimple2 : ((StateParallel)stateSimple).aParallelstates) {
                this.checkDefaultAddDstState(stateSimple2, n + 1);
            }
        } else {
            this.dstStates.add(stateSimple);
        }
    }

    private void searchStateCommon() {
        int n;
        StateSimple stateSimple;
        boolean bl = true;
        int n2 = this.state.statePath.length - 2;
        do {
            stateSimple = this.state.statePath[n2];
            n = -1;
            while (stateSimple != null && ++n < this.dstStates.size()) {
                StateSimple stateSimple2 = this.dstStates.get(n);
                this.ixInStatePath[n] = stateSimple2.statePath.length - 1;
                while (stateSimple != null && stateSimple2.statePath[this.ixInStatePath[n]] != stateSimple) {
                    int n3 = n;
                    this.ixInStatePath[n3] = this.ixInStatePath[n3] - 1;
                    if (this.ixInStatePath[n3] >= 0) continue;
                    stateSimple = null;
                }
            }
        } while (stateSimple == null && --n2 >= 0);
        if (stateSimple == null) {
            throw new IllegalArgumentException("no common state found");
        }
        this.trans.ixCommonInStatePath = n2;
        this.trans.exitStates = new StateSimple[this.state.statePath.length - (n2 + 1)];
        n = 0;
        while (n < this.trans.dst.length) {
            int n4 = n++;
            this.ixInStatePath[n4] = this.ixInStatePath[n4] + 1;
        }
    }

    private void buildExitPath() {
        int n = this.state.statePath.length;
        for (int i = 0; i < this.trans.exitStates.length; ++i) {
            this.trans.exitStates[i] = this.state.statePath[--n];
        }
        if (this.trans instanceof StateSimple.TransJoin) {
            this.createJoinTransitionInTheFirstJoinState();
        }
    }

    private void createJoinTransitionInTheFirstJoinState() {
        StateSimple stateSimple;
        StateSimple.TransJoin transJoin = (StateSimple.TransJoin)this.trans;
        transJoin.joinStates = new StateSimple[transJoin.joinStateHashes.length];
        int n = -1;
        int n2 = 0;
        for (int n3 : transJoin.joinStateHashes) {
            stateSimple = this.state.stateMachine.stateMap.get(new Integer(n3));
            if (n2 < stateSimple.statePath.length) {
                n2 = stateSimple.statePath.length;
            }
            transJoin.joinStates[++n] = stateSimple;
        }
        Object object = new LinkedList();
        StateSimple stateSimple2 = transJoin.exitStates[transJoin.exitStates.length - 1].enclState;
        StateSimple stateSimple3 = null;
        do {
            --n2;
            StateSimple stateSimple4 = null;
            for (n = 0; n < transJoin.joinStates.length; ++n) {
                stateSimple = transJoin.joinStates[n];
                if (stateSimple.statePath.length <= n2 || (stateSimple3 = stateSimple.statePath[n2]) == stateSimple2) continue;
                if (stateSimple4 == null) {
                    stateSimple4 = stateSimple3;
                    object.add(stateSimple4);
                    continue;
                }
                if (stateSimple3 == stateSimple4) continue;
                object.add(stateSimple3);
            }
        } while (stateSimple3 != stateSimple2);
        transJoin.exitStates = object.toArray(new StateSimple[object.size()]);
    }

    private void buildEntryStates() {
        int n;
        StateSimple[] stateSimpleArray = new StateSimple[this.dstStates.size()];
        if (stateSimpleArray.length == 3) {
            Debugutil.stop();
        }
        if (this.trans.transId.equals("Trans_Running0")) {
            Debugutil.stop();
        }
        LinkedList<StateSimple> linkedList = new LinkedList<StateSimple>();
        int n2 = this.ixInStatePath[0];
        do {
            int n3;
            n = this.ixInStatePath.length;
            for (n3 = 0; n3 < this.ixInStatePath.length; ++n3) {
                stateSimpleArray[n3] = null;
            }
            for (n3 = 0; n3 < this.ixInStatePath.length; ++n3) {
                StateSimple[] stateSimpleArray2 = this.dstStates.get((int)n3).statePath;
                if (n2 < stateSimpleArray2.length) {
                    int n4;
                    StateSimple stateSimple = stateSimpleArray2[n2];
                    if (n3 == 0) {
                        n4 = stateSimpleArray.length;
                    } else {
                        for (n4 = 0; n4 < stateSimpleArray.length && stateSimpleArray[n4] != stateSimple; ++n4) {
                        }
                    }
                    if (n4 != stateSimpleArray.length) continue;
                    stateSimpleArray[n3] = stateSimple;
                    linkedList.add(stateSimple);
                    continue;
                }
                --n;
            }
            ++n2;
        } while (n > 0);
        this.trans.entryStates = linkedList.toArray(new StateSimple[linkedList.size()]);
    }

    private void searchOrCreateTimerEvent() {
        if (this.state.stateMachine.theThread == null) {
            throw new IllegalArgumentException("This statemachine needs a thread and a timer manager because timeouts are used. Use StateMachine(thread, timer); to construct it");
        }
        StateSimple stateSimple = this.state;
        while (stateSimple.enclState != null && !(stateSimple.enclState instanceof StateParallel)) {
            stateSimple = stateSimple.enclState;
        }
        if (stateSimple.evTimeout == null) {
            stateSimple.evTimeout = new TimeOrder(this.state.getName() + "-timeout", this.state.stateMachine.timerThread, this.state.stateMachine.evSourceTimeout, this.state.stateMachine, this.state.stateMachine.theThread);
        }
        this.state.evTimeout = stateSimple.evTimeout;
    }
}

