/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.math;

import java.util.Arrays;
import org.vishia.util.Debugutil;

public class CurveInterpolation {
    public static final String sVersion = "2015-10-04";
    private static Get getColumn = new Get(){

        @Override
        public float get(int n, Object object) {
            return ((float[][])object)[n][0];
        }
    };
    private static Get getSingle = new Get(){

        @Override
        public float get(int n, Object object) {
            return ((float[])object)[n];
        }
    };
    public static float[][] pointsTest = new float[][]{{0.0f, 1.0f}, {5.0f, 10.0f}, {10.0f, 1.0f}, {20.0f, 14.0f}, {30.0f, 20.0f}};
    private static int[] testIndex = new int[200];
    public static float[][] points2Test = new float[][]{{0.0f, -1.0f, 2.0f, 7.0f, 90.0f}, {-1.0f, 0.0f, 2.0f, 7.0f, 10.0f}, {3.0f, 4.0f, 10.0f, 11.0f, 12.0f}, {8.0f, 5.0f, 12.0f, 15.0f, 16.0f}, {92.0f, 6.0f, 15.0f, 19.0f, 19.0f}};

    public static float linearInterpolation(float f, float[][] fArray, int n) {
        float f2;
        float f3;
        float f4;
        int n2 = CurveInterpolation.search(f, fArray, 0, fArray.length, n, getColumn);
        float f5 = fArray[n2][0];
        float f6 = fArray[n2][1];
        if (n2 < fArray.length - 1) {
            float f7 = fArray[n2 + 1][0];
            float f8 = fArray[n2 + 1][1];
            f4 = (f8 - f6) / (f7 - f5);
        } else {
            float f9 = f5;
            float f10 = f6;
            f3 = fArray[n2 - 1][0];
            f2 = fArray[n2 - 1][1];
            f10 = f6;
            f4 = (f6 - f2) / (f5 - f3);
        }
        f3 = f - f5;
        f2 = f6 + f4 * f3;
        return f2;
    }

    public static float splineInterpolation(float f, float[][] fArray, int n) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        int n2 = CurveInterpolation.search(f, fArray, 0, fArray.length, n, getColumn);
        float f10 = fArray[n2][0];
        float f11 = fArray[n2][1];
        if (n2 >= 1) {
            f9 = fArray[n2 - 1][0];
            f8 = fArray[n2 - 1][1];
        } else {
            f9 = f10;
            f8 = f11;
        }
        if (n2 == 0) {
            f7 = fArray[n2 + 1][0];
            f6 = fArray[n2 + 1][1];
            float f12 = fArray[n2 + 2][0];
            float f13 = fArray[n2 + 2][1];
            f4 = f5 = (f6 - f11) / (f7 - f10);
            f3 = (f13 - f11) / (f12 - f10);
        } else if (n2 < fArray.length - 2) {
            f9 = fArray[n2 - 1][0];
            f8 = fArray[n2 - 1][1];
            f7 = fArray[n2 + 1][0];
            f6 = fArray[n2 + 1][1];
            float f14 = fArray[n2 + 2][0];
            float f15 = fArray[n2 + 2][1];
            f4 = (f6 - f8) / (f7 - f9);
            f5 = (f6 - f11) / (f7 - f10);
            f3 = (f15 - f11) / (f14 - f10);
        } else if (n2 < fArray.length - 1) {
            f9 = fArray[n2 - 1][0];
            f8 = fArray[n2 - 1][1];
            f7 = fArray[n2 + 1][0];
            f6 = fArray[n2 + 1][1];
            f4 = (f6 - f8) / (f7 - f9);
            f3 = f5 = (f6 - f11) / (f7 - f10);
        } else {
            f7 = f10;
            f6 = f11;
            f5 = f3 = (f4 = (f11 - f8) / (f10 - f9));
        }
        float f16 = (f10 + f7) / 2.0f;
        float f17 = f11 + f5 * (f16 - f10);
        if (f == 7.25f) {
            Debugutil.stop();
        }
        if (f < f16) {
            float f18 = f - f10;
            float f19 = 1.0f - f18 / (f16 - f10);
            f19 *= f19;
            float f20 = f11 + f4 * f18;
            float f21 = f17 - f5 * (f16 - f);
            f2 = f19 * f20 + (1.0f - f19) * f21;
        } else {
            float f22 = f - f16;
            float f23 = f16 < f7 ? (f - f16) / (f7 - f16) : 1.0f;
            f23 *= f23;
            float f24 = f17 + f5 * (f - f16);
            float f25 = f6 - f3 * (f7 - f);
            f2 = (1.0f - f23) * f24 + f23 * f25;
        }
        return f2;
    }

    public static float linearInterpolation(float f, float f2, float[][] fArray, int n) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        int n2 = CurveInterpolation.search(f, fArray, 1, fArray.length, n, getColumn);
        int n3 = CurveInterpolation.search(f2, fArray[0], 1, fArray[0].length, n, getSingle);
        float f11 = fArray[n2][0];
        float f12 = fArray[0][n3];
        float f13 = fArray[n2][n3];
        if (n2 < fArray.length - 1 && n3 < fArray[0].length - 1) {
            int n4 = n2 + 1;
            f10 = fArray[n4][0];
            float f14 = fArray[0][n3 + 1];
            f9 = fArray[n4][n3];
            float f15 = fArray[n2][n3 + 1];
            float f16 = fArray[n4][n3 + 1];
            f8 = (f15 - f13) / (f14 - f12);
            f7 = (f16 - f9) / (f14 - f12);
        } else if (n2 < fArray.length - 1) {
            f6 = fArray[0][n3 - 1];
            f5 = fArray[n2][n3 - 1];
            float f17 = f12 + (f12 - f6);
            int n5 = n2 + 1;
            f9 = fArray[n5][n3];
            float f18 = f13 + (f13 - f5) / (f12 - f6);
            float f19 = fArray[n5][n3 + 1];
            f10 = f11;
            f8 = (f18 - f13) / (f12 - f6);
            f7 = (f19 - f9) / (f12 - f6);
        } else {
            f6 = fArray[0][n3 - 1];
            f5 = fArray[n2][n3 - 1];
            f4 = fArray[n2 - 1][0];
            f3 = fArray[n2 - 1][n3];
            float f20 = f12 + (f12 - f6);
            f9 = 0.0f;
            float f21 = f13 + (f13 - f5) / (f12 - f6);
            float f22 = 0.0f;
            f10 = f11;
            f8 = f7 = (f21 - f13) / (f12 - f6);
        }
        f6 = f2 - f12;
        f5 = f - f11;
        f4 = f13 + f8 * f6;
        f3 = f9 + f7 * f6;
        float f23 = (f3 - f4) / (f10 - f11);
        float f24 = f4 + f23 * f5;
        return f24;
    }

    public static float splineInterpolation(float f, float f2, float[][] fArray, int n) {
        int n2 = CurveInterpolation.search(f, fArray[0], 1, fArray[0].length, n, getSingle);
        int n3 = CurveInterpolation.search(f2, fArray, 0, fArray.length, n, getColumn);
        float f3 = fArray[n2][0];
        float f4 = fArray[n2][n3];
        return 0.0f;
    }

    private static int search(float f, Object object, int n, int n2, int n3, Get get) {
        if (n3 >= 0 && get.get(n3, object) <= f && (n3 >= n2 - 1 || f <= get.get(n3 + 1, object))) {
            return n3;
        }
        int n4 = n;
        int n5 = n2;
        int n6 = n;
        while (n4 < n5 - 1) {
            n6 = n4 + n5 >> 1;
            float f2 = get.get(n6, object);
            if (f >= f2) {
                n4 = n6;
                continue;
            }
            n6 = n5 = n6;
        }
        return n4;
    }

    public static float[][] pointsTest() {
        return pointsTest;
    }

    public static float[][] test() {
        Arrays.fill(testIndex, 0);
        float[][] fArray = new float[140][2];
        for (int i = 0; i < 140; ++i) {
            float f;
            fArray[i][0] = f = 0.25f * (float)i - 2.0f;
            fArray[i][1] = CurveInterpolation.linearInterpolation(f, pointsTest, -1);
        }
        return fArray;
    }

    public static float[][] test2() {
        Arrays.fill(testIndex, 0);
        float[][] fArray = new float[140][10];
        for (int i = 1; i < 10; ++i) {
            float f;
            fArray[0][i] = f = (float)(-4 + 2 * i);
            for (int j = 1; j < 140; ++j) {
                float f2;
                fArray[j][0] = f2 = -0.5f + 0.25f * (float)j - 2.0f;
                if (i == 2 && j == 5) {
                    Debugutil.stop();
                }
                fArray[j][i] = CurveInterpolation.linearInterpolation(f2, f, points2Test, -1);
            }
        }
        return fArray;
    }

    private static interface Get {
        public float get(int var1, Object var2);
    }
}

