/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.header2Reflection;

import java.text.ParseException;
import org.vishia.header2Reflection.Header2Reflection;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.Report;

public class CmdHeader2Reflection
extends MainCmd {
    public static final int revisionInfo = 20110411;
    Report console;
    Header2Reflection main;
    String sFileIn = null;

    public static void main(String[] stringArray) {
        CmdHeader2Reflection cmdHeader2Reflection = new CmdHeader2Reflection(stringArray);
        Header2Reflection header2Reflection = new Header2Reflection(cmdHeader2Reflection);
        boolean bl = true;
        try {
            cmdHeader2Reflection.parseArguments(header2Reflection, stringArray);
        }
        catch (Exception exception) {
            cmdHeader2Reflection.setExitErrorLevel(5);
            bl = false;
        }
        if (bl) {
            try {
                header2Reflection.execute();
            }
            catch (Exception exception) {
                header2Reflection.console.report("Uncatched Exception on main level:", exception);
                exception.printStackTrace(System.err);
                header2Reflection.console.setExitErrorLevel(3);
            }
        }
        cmdHeader2Reflection.exit();
    }

    private CmdHeader2Reflection(String[] stringArray) {
        super(stringArray);
        super.addAboutInfo("Generate Reflection.c and Reflection.h");
        super.addAboutInfo("made by Hartmut Schorrig, 2009-11-22");
        super.addHelpInfo("param: {-i:INPUT} [-o:OUTDIR |-out.c:OUTFILE | -obin[l|b]:BINFILE -offs:OFFSETFILE ] -z:CHeader.zbnf -b:Types.cfg -c_only -ro:FileTypes.out");
        super.addStandardHelpInfo();
        super.addHelpInfo("-i:INPUT    inputfilepath, more as one -i is admissible and typical.");
        super.addHelpInfo("-o:OUTDIR For any INPUT one output file in this directory.");
        super.addHelpInfo("-out.c:OUTFILE The file path and name for OUTFILE.c and OUTFILE.h, this file is written.");
        super.addHelpInfo("-offs:OFFSETFILE An extra file.c for offset-constants for second CPU.");
        super.addHelpInfo("-obinl:BINFILE in little endian, contains all structure informations, only able to use with -offs:.");
        super.addHelpInfo("-obinb:BINFILE Same, but the BINFILE will written in big endian.");
        super.addHelpInfo("-obin[b|l]hex:HEXFILE The BINFILE will written in Intel-hex-Format.");
        super.addHelpInfo("-c_only Don't reagard C++-classes, don't generate C++-code especially static_cast<...> .");
        super.addHelpInfo("-b:Types.cfg Config-file for special handled types.");
        super.addHelpInfo("-always Don't check newness of header input files.");
        super.addHelpInfo("Syntax of the config-file: ------------------------------------------------------------");
        super.addHelpInfo("$setLinemode. \nReflectionTypes::=\n{ \\n\n| \\<leaderTextOffs  [ = <textFile?leaderTextOffs>  \\> | \\> \\n<lines?leaderTextOffs>]\n| \\<trailerTextOffs [ = <textFile?trailerTextOffs> \\> | \\> \\n<lines?trailerTextOffs>]\n| \\<leaderTextC     [ = <textFile?leaderTextC>     \\> | \\> \\n<lines?leaderTextC>]\n| \\<trailerTextC    [ = <textFile?trailerTextC>    \\> | \\> \\n<lines?trailerTextC>]\n| \\<leaderTextH     [ = <textFile?leaderTextH>     \\> | \\> \\n<lines?leaderTextH>]\n| \\<trailerTextH    [ = <textFile?trailerTextH>    \\> | \\> \\n<lines?trailerTextH>]\n| exprOffsField = <\"\"?exprOffsField> \\n\n| exprOffsBase = <\"\"?exprOffsBase> \\n\n| exprOffsObj = <\"\"?exprOffsObj> \\n\n| exprOffsObjJcpp = <\"\"?exprOffsObjJcpp> \\n\n| exprOffsCppObj = <\"\"?exprOffsCppObj> \\n\n| exprSizeType = <\"\"?exprSizeType> \\n\n| <blockedFile> \\n \n|<?c_only> c_only \\n\n|<?define> #define <$?name> <*\\r\\n?value> \n| <reflectionType> \\n \n| \\n\n} \\e.\nblockedFile::= % <* ,\\r\\n?path>.\nreflectionType::= [<?sign>#|-] <* ,\\r\\n?type> \n| [<?sign>=|@] <* =?type> = [ <$?deftype>| 0x<#x?defvalue>| <#?defvalue>] \n| [<?sign>!|!] <* =?type> = [ <$?deftype>].\nlines::={[? \\<END\\>]<*\\n?line>\\n} \\<END\\> \\n.\ntextFile::= <\"\"?fileName>.\n");
        super.addHelpInfo("---------------------------------------------------------------------------------------");
    }

    public void parseArguments(Header2Reflection header2Reflection, String[] stringArray) throws ParseException {
        this.main = header2Reflection;
        super.parseArguments(stringArray);
    }

    @Override
    protected boolean testArgument(String string, int n) {
        boolean bl = true;
        if (string.startsWith("-i:")) {
            bl = this.main.addInputFilemask(this.getArgument(3));
        } else if (string.startsWith("-o:")) {
            bl = this.main.setOutDir(this.getArgument(3));
        } else if (string.startsWith("-z:")) {
            this.main.setSyntax(this.getArgument(3));
        } else if (string.startsWith("-r:")) {
            this.main.setReflectionTypes(this.getArgument(3));
        } else if (string.startsWith("-b:")) {
            this.main.setReflectionBlockedTypes(this.getArgument(3));
        } else if (string.startsWith("-ro:")) {
            this.main.setReflectionTypesOut(this.getArgument(4), true);
        } else if (string.startsWith("-ro+")) {
            this.main.setReflectionTypesOut(this.getArgument(4), false);
        } else if (string.startsWith("-out.c:")) {
            bl = this.main.setOutC(this.getArgument(7));
        } else if (string.startsWith("-offs:")) {
            bl = this.main.setOutOffset(this.getArgument(6));
        } else if (string.startsWith("-obinl:")) {
            bl = this.main.setOutBin(this.getArgument(7), false, false);
        } else if (string.startsWith("-obinb:")) {
            bl = this.main.setOutBin(this.getArgument(7), true, false);
        } else if (string.startsWith("-obinlhex:")) {
            bl = this.main.setOutBin(this.getArgument(10), false, true);
        } else if (string.startsWith("-obinbhex:")) {
            bl = this.main.setOutBin(this.getArgument(10), true, true);
        } else if (string.startsWith("-c_only")) {
            this.main.c_only = true;
        } else if (string.startsWith("-always")) {
            this.main.setCheckNewness(false);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void callWithoutArguments() throws ParseException {
        super.callWithoutArguments();
    }

    @Override
    protected boolean checkArguments() {
        return true;
    }
}

