/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCmdEventData;
import org.vishia.msgDispatch.LogMessageStream;
import org.vishia.util.SortedTreeWalkerCallback;

public class FileRemoteWalkerCallbackLog
implements SortedTreeWalkerCallback<FileRemote, FileRemoteCmdEventData> {
    final LogMessageStream logout;
    final boolean bAnyFile;

    public FileRemoteWalkerCallbackLog(OutputStream outputStream, OutputStream outputStream2, Appendable appendable, boolean bl) {
        this.logout = new LogMessageStream(outputStream, outputStream2, appendable, true, Charset.forName("UTF-8"));
        this.bAnyFile = bl;
    }

    public FileRemoteWalkerCallbackLog(File file, OutputStream outputStream, Appendable appendable, boolean bl) throws IOException {
        this.bAnyFile = bl;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        boolean bl2 = true;
        this.logout = new LogMessageStream(fileOutputStream, outputStream, appendable, bl2, Charset.forName("UTF-8"));
    }

    @Override
    public void start(FileRemote fileRemote, FileRemoteCmdEventData fileRemoteCmdEventData) {
        this.logout.sendMsg(1, "start: %s", fileRemote.getAbsolutePath());
    }

    @Override
    public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote, Object object, Object object2) {
        this.logout.sendMsg(1, "start: %s", fileRemote.getAbsolutePath());
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, Object object, Object object2) {
        this.logout.sendMsg(1, "finish: %s", fileRemote.getAbsolutePath());
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
        if (this.bAnyFile) {
            this.logout.sendMsg(1, "file: %s", fileRemote.getAbsolutePath());
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public void finished(FileRemote fileRemote) {
        this.logout.sendMsg(1, "done: %s", fileRemote.getAbsolutePath());
    }

    @Override
    public boolean shouldAborted() {
        return false;
    }
}

