/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import org.vishia.event.EventWithDst;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCmdEventData;
import org.vishia.fileRemote.FileRemoteProgressEvData;
import org.vishia.util.FileFunctions;
import org.vishia.util.SortedTreeWalkerCallback;

public abstract class FileRemoteWalkerCallback
implements SortedTreeWalkerCallback<FileRemote, FileRemoteCmdEventData> {
    protected final FileRemote dir1Base;
    protected final FileRemote dir2Base;
    protected FileRemote dir1Curr;
    protected FileRemote dir2Curr;
    protected final String basepath1;
    protected final int zBasePath1;
    protected final EventWithDst<FileRemoteProgressEvData, ?> evBack;
    protected final FileRemoteProgressEvData progress;
    protected final FileRemoteWalkerCallback callbackUser;
    protected long minDiffTimestamp = 2000L;
    protected boolean aborted = false;

    public FileRemoteWalkerCallback(FileRemote fileRemote, FileRemote fileRemote2, FileRemoteWalkerCallback fileRemoteWalkerCallback, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        this.evBack = eventWithDst;
        this.progress = eventWithDst == null ? null : eventWithDst.data();
        this.callbackUser = fileRemoteWalkerCallback;
        this.dir1Base = fileRemote;
        this.dir2Base = fileRemote2;
        this.basepath1 = FileFunctions.normalizePath(fileRemote.getAbsolutePath()).toString();
        this.zBasePath1 = this.basepath1.length();
    }

    protected void prepareDirs(FileRemote fileRemote, boolean bl) {
        this.dir1Curr = fileRemote;
        if (this.dir2Base != null) {
            CharSequence charSequence = FileFunctions.normalizePath(fileRemote.getAbsolutePath());
            if (charSequence.length() <= this.zBasePath1) {
                this.dir2Curr = this.dir2Base;
            } else if (bl) {
                CharSequence charSequence2 = charSequence.subSequence(this.zBasePath1 + 1, charSequence.length());
                this.dir2Curr = this.dir2Base.subdir(charSequence2);
            } else {
                this.dir2Curr = this.dir2Curr.getChild(fileRemote.getName());
            }
        }
        if (this.progress != null) {
            this.progress.currDir = fileRemote;
        }
    }

    protected void restoreDirs() {
        this.dir1Curr = this.dir1Curr.getParentFile();
        if (this.dir2Curr != null) {
            this.dir2Curr = this.dir2Curr.getParentFile();
        }
    }

    protected FileRemote getFile2(FileRemote fileRemote, boolean bl) {
        String string = fileRemote.getName();
        FileRemote fileRemote2 = bl ? this.dir2Curr.child(string) : this.dir2Curr.getChild(string);
        return fileRemote2;
    }

    @Override
    public boolean shouldAborted() {
        return this.aborted;
    }

    @Override
    public void finished(FileRemote fileRemote) {
        if (this.evBack != null) {
            this.progress.done(null, null);
        }
    }
}

