/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.execode;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class Execode {
    private static EInstruction[] instrTable = new EInstruction[256];
    List<Instruction> code = new LinkedList<Instruction>();

    public void addInstr(EInstruction eInstruction, String string) {
        this.code.add(new Instruction(eInstruction, string));
    }

    public void addInstr(EInstruction eInstruction) {
        this.code.add(new Instruction(eInstruction));
    }

    public void addInstrVariable(EInstruction eInstruction, int n, String string) {
        this.code.add(new Instruction(eInstruction, n, string));
    }

    public Iterable<Instruction> code() {
        return this.code;
    }

    public CharSequence convertToNormalExpression() {
        StringBuilder stringBuilder = new StringBuilder();
        Stack<StringBuilder> stack = new Stack<StringBuilder>();
        for (Instruction instruction : this.code) {
            StringBuilder stringBuilder2 = null;
            if (instruction.instr.usedStack < 0) {
                if (stringBuilder != null) {
                    stack.push(stringBuilder);
                }
                stringBuilder = new StringBuilder();
            } else if (instruction.operand == EOperand.stack) {
                stringBuilder2 = stringBuilder;
                if (instruction.instr.usedStack > 0) {
                    stringBuilder = (StringBuilder)stack.pop();
                    stringBuilder.insert(0, '(').append(')');
                } else {
                    stringBuilder = new StringBuilder();
                }
            }
            switch (instruction.instr) {
                case set: {
                    stringBuilder.append("");
                    break;
                }
                case add: {
                    stringBuilder.append(" + ");
                    break;
                }
                case sub: {
                    stringBuilder.append(" + ");
                    break;
                }
                case div: {
                    stringBuilder.append(" / ");
                    break;
                }
                case mod: {
                    stringBuilder.append(" % ");
                    break;
                }
                case mult: {
                    stringBuilder.append(" * ");
                    break;
                }
                case neg: {
                    stringBuilder.append(" -");
                    break;
                }
                case bitneg: {
                    stringBuilder.append(" ~");
                    break;
                }
                case pow: {
                    stringBuilder.append(" ** ");
                    break;
                }
                case shl: {
                    stringBuilder.append(" << ");
                    break;
                }
                case shr: {
                    stringBuilder.append(" >> ");
                    break;
                }
                case ushr: {
                    stringBuilder.append(" :>> ");
                    break;
                }
                case equ: {
                    stringBuilder.append(" == ");
                    break;
                }
                case nequ: {
                    stringBuilder.append(" != ");
                    break;
                }
                case gt: {
                    stringBuilder.append(" > ");
                    break;
                }
                case ge: {
                    stringBuilder.append(" >= ");
                    break;
                }
                case lt: {
                    stringBuilder.append(" < ");
                    break;
                }
                case le: {
                    stringBuilder.append(" <= ");
                    break;
                }
                case and: {
                    stringBuilder.append(" && ");
                    break;
                }
                case or: {
                    stringBuilder.append(" || ");
                    break;
                }
                case xor: {
                    stringBuilder.append(" XOR ");
                }
            }
            switch (instruction.operand) {
                case constant: {
                    stringBuilder.append(instruction.constant);
                    break;
                }
                case stack: {
                    stringBuilder.append("(").append((CharSequence)stringBuilder2).append(")");
                    break;
                }
                case var: {
                    stringBuilder.append(" ").append(instruction.text).append(" ");
                }
            }
        }
        assert (stack.size() == 0);
        return stringBuilder;
    }

    public String toString() {
        return this.code.toString();
    }

    public static void main(String[] stringArray) {
        Execode execode = new Execode();
        execode.addInstr(EInstruction.set, "5");
        execode.addInstr(EInstruction.add, "3");
        execode.addInstr(EInstruction.set, "7");
        execode.addInstr(EInstruction.add, "2");
        execode.addInstr(EInstruction.mult);
        CharSequence charSequence = execode.convertToNormalExpression();
        System.out.println(charSequence);
    }

    public static class Instruction {
        public final EInstruction instr;
        public final int id;
        public final Constant constant;
        public final EOperand operand;
        public final String text;

        public Instruction(EInstruction eInstruction, String string) {
            this.instr = eInstruction;
            this.constant = new Constant(string);
            this.id = -1;
            this.text = string;
            this.operand = EOperand.constant;
        }

        public Instruction(EInstruction eInstruction) {
            this.instr = eInstruction;
            this.text = "@";
            this.constant = null;
            this.id = -1;
            this.operand = EOperand.stack;
        }

        public Instruction(EInstruction eInstruction, int n, String string) {
            this.instr = eInstruction;
            this.id = n;
            this.constant = null;
            this.text = string;
            this.operand = EOperand.var;
        }

        public String toString() {
            return this.text + " " + (Object)((Object)this.instr);
        }
    }

    public static class Constant {
        String sConst;
        float fConst;
        double dConst;
        long lConst;
        char type;

        public Constant(String string) {
            this.sConst = string;
        }

        public String toString() {
            return this.sConst;
        }
    }

    public static final class EXXXInstruction
    extends Enum<EXXXInstruction> {
        public static final /* enum */ EXXXInstruction nop = new EXXXInstruction(0, false, EOperand.stack, EInstruction.set);
        int ix;
        boolean bSet;
        EOperand XXXoperand;
        EInstruction XXXoperator;
        private static final /* synthetic */ EXXXInstruction[] $VALUES;

        public static EXXXInstruction[] values() {
            return (EXXXInstruction[])$VALUES.clone();
        }

        public static EXXXInstruction valueOf(String string) {
            return Enum.valueOf(EXXXInstruction.class, string);
        }

        private EXXXInstruction(int n2, boolean bl, EOperand eOperand, EInstruction eInstruction) {
            this.ix = n2;
            this.bSet = bl;
            this.XXXoperand = eOperand;
            this.XXXoperator = eInstruction;
            assert (instrTable[n2] == null);
        }

        static {
            $VALUES = new EXXXInstruction[]{nop};
        }
    }

    public static enum EOperand {
        var(0),
        constant(1),
        stack(2);

        int ix;

        private EOperand(int n2) {
            this.ix = n2;
        }
    }

    public static enum EInstruction {
        set(16, -1),
        add(96, 1),
        sub(100, 1),
        mult(104, 1),
        div(108, 1),
        pow(0, 1),
        mod(112, 1),
        neg(116, 0),
        bitneg(120, 0),
        shl(128, 1),
        shr(136, 1),
        ushr(128, 1),
        and(112, 1),
        or(112, 1),
        xor(112, 1),
        equ(0, 1),
        nequ(0, 1),
        lt(0, 1),
        le(0, 1),
        gt(0, 1),
        ge(0, 1);

        public int ix;
        public final int usedStack;

        private EInstruction(int n2, int n3) {
            this.ix = n2;
            this.usedStack = n3;
        }
    }
}

