/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.event;

import java.io.Closeable;
import java.util.EventObject;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.vishia.event.EventConsumer;
import org.vishia.event.EventTimerThread_ifc;
import org.vishia.event.EventWithDst;
import org.vishia.event.TimeOrder;
import org.vishia.util.Debugutil;
import org.vishia.util.ExcUtil;
import org.vishia.util.InfoAppend;

public class EventTimerThread
implements EventTimerThread_ifc,
Closeable,
InfoAppend {
    public static final String version = "2023-03-12";
    private int debugPrint = 0;
    int debugPrintViewDelayed = 1537;
    protected final String threadName;
    protected Thread threadTimer;
    private EventConsumer eventProcessor;
    private final ConcurrentLinkedQueue<EventObject> queueEvents = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<TimeOrder> queueDelayedOrders = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<TimeOrder> queueOrdersToExecute = new ConcurrentLinkedQueue();
    protected boolean bThreadRun;
    private int delayMax = 1000;
    protected long timeCheckNew = System.currentTimeMillis() + (long)this.delayMax;
    private long timeSleep;
    protected char stateThreadTimer = (char)63;
    private final AtomicBoolean extEventSet = new AtomicBoolean(false);
    protected boolean startOnDemand;
    private int ctWaitEmptyQueue;
    protected int maxCtWaitEmptyQueue = 5;
    private boolean preserveRecursiveInfoAppend;
    private Runnable runTimer = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EventTimerThread.this.bThreadRun = true;
            EventTimerThread.this.stateThreadTimer = (char)114;
            while (EventTimerThread.this.stateThreadTimer == 'r' && EventTimerThread.this.bThreadRun) {
                int n = EventTimerThread.this.stepThread();
                EventTimerThread eventTimerThread = EventTimerThread.this;
                synchronized (eventTimerThread) {
                    EventTimerThread.this.stateThreadTimer = (char)87;
                    try {
                        EventTimerThread.this.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (EventTimerThread.this.stateThreadTimer == 'W') {
                        EventTimerThread.this.stateThreadTimer = (char)114;
                    }
                }
            }
            EventTimerThread.this.stateThreadTimer = (char)102;
        }
    };

    public EventTimerThread(String string) {
        this.threadName = string;
    }

    public final void setStdEventProcessor(EventConsumer eventConsumer) {
        this.eventProcessor = eventConsumer;
    }

    public final void start() {
        if (this.threadTimer == null && !this.bThreadRun) {
            this.createThread_();
            this.startOnDemand = false;
            this.threadTimer.start();
        }
    }

    protected void createThread_() {
        this.threadTimer = new Thread(this.runTimer, this.threadName);
    }

    @Override
    public final boolean storeEvent(EventObject eventObject) {
        if (eventObject instanceof EventWithDst) {
            EventWithDst eventWithDst = (EventWithDst)eventObject;
            if (eventWithDst.stateOfEvent == 'q') {
                return false;
            }
            ((EventWithDst)eventObject).stateOfEvent = (char)113;
        }
        this.queueEvents.offer(eventObject);
        this.startOrNotify();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startOrNotify() {
        if (this.threadTimer == null) {
            this.createThread_();
            this.startOnDemand = true;
        } else {
            EventTimerThread eventTimerThread = this;
            synchronized (eventTimerThread) {
                if (this.stateThreadTimer == 'W') {
                    this.wakeup_();
                }
            }
        }
    }

    protected void wakeup_() {
        this.notify();
    }

    @Override
    public void close() {
        this.bThreadRun = false;
        this.notifyTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final char addTimeEntry(TimeOrder timeOrder) {
        int n;
        long l = timeOrder.timeToExecution();
        if (l >= 0L) {
            this.queueDelayedOrders.offer(timeOrder);
            long l2 = timeOrder.timeExecution - this.timeCheckNew;
            if (l2 < -2L) {
                this.timeCheckNew = timeOrder.timeExecution;
                EventTimerThread eventTimerThread = this;
                synchronized (eventTimerThread) {
                    boolean bl;
                    boolean bl2 = bl = this.stateThreadTimer == 'W';
                    if (bl) {
                        n = 110;
                        this.wakeup_();
                    } else {
                        n = 98;
                        this.wakeup_();
                    }
                }
            } else {
                n = 108;
            }
        } else {
            timeOrder.event.sendEvent(timeOrder.event.getSource());
            n = 120;
        }
        return (char)n;
    }

    @Override
    public final boolean removeTimeEntry(TimeOrder timeOrder) {
        boolean bl = this.queueDelayedOrders.remove(timeOrder);
        return bl;
    }

    @Override
    public final boolean removeFromQueue(EventObject eventObject) {
        boolean bl = this.queueEvents.remove(eventObject);
        if (bl && eventObject instanceof EventWithDst) {
            ((EventWithDst)eventObject).stateOfEvent = (char)97;
        }
        return bl;
    }

    @Override
    public boolean isBusy() {
        return this.stateThreadTimer == 'c';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkEventAndRun() {
        boolean bl;
        block13: {
            bl = false;
            try {
                Object object;
                EventObject eventObject = this.queueEvents.poll();
                if (eventObject == null) break block13;
                if (eventObject instanceof EventWithDst) {
                    object = (EventWithDst)eventObject;
                    ((EventWithDst)object).stateOfEvent = (char)101;
                }
                this.ctWaitEmptyQueue = 0;
                object = this;
                synchronized (object) {
                    if (this.stateThreadTimer != 'x') {
                        this.stateThreadTimer = (char)98;
                    }
                }
                if (this.stateThreadTimer == 'b') {
                    if (eventObject instanceof EventWithDst) {
                        object = (EventWithDst)eventObject;
                        ((EventWithDst)object).stateOfEvent = (char)114;
                        ((EventWithDst)object).notifyDequeued();
                        int n = ((EventWithDst)object).processEvent();
                        if ((n & 2) == 0) {
                            ((EventWithDst)object).relinquish();
                        }
                    } else if (this.eventProcessor != null) {
                        this.eventProcessor.processEvent(eventObject);
                    } else {
                        throw new IllegalStateException("destination for event execution is unknown. Use setStdEventProcessor(...). ");
                    }
                    bl = true;
                }
            }
            catch (Exception exception) {
                CharSequence charSequence = ExcUtil.exceptionInfo("EventThread unexpected Exception - ", exception, 0, 50);
                System.err.append(charSequence).append('\n');
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkTimeOrders() {
        TimeOrder timeOrder;
        int n = this.delayMax;
        this.timeCheckNew = System.currentTimeMillis() + (long)n;
        EventTimerThread eventTimerThread = this;
        synchronized (eventTimerThread) {
            Iterator<TimeOrder> iterator = this.queueDelayedOrders.iterator();
            long l = System.currentTimeMillis();
            while (iterator.hasNext()) {
                timeOrder = iterator.next();
                long l2 = timeOrder.timeExecution - l;
                if (l2 < 3L) {
                    EventTimerThread eventTimerThread2 = this;
                    synchronized (eventTimerThread2) {
                        if (!timeOrder.bHoldTimeorder) {
                            iterator.remove();
                            timeOrder.timeExecutionLatest = 0L;
                            timeOrder.timeExecution = 0L;
                            this.queueOrdersToExecute.offer(timeOrder);
                        }
                        continue;
                    }
                }
                if (l2 >= (long)n) continue;
                this.timeCheckNew = timeOrder.timeExecution;
                n = (int)l2;
            }
        }
        while ((timeOrder = this.queueOrdersToExecute.poll()) != null) {
            if (timeOrder.timerThread != timeOrder.event.evDstThread) {
                timeOrder.event.sendEvent(timeOrder.event.getSource());
            } else {
                timeOrder.event.processEvent();
            }
            timeOrder.repeatCyclic();
        }
        long l = this.timeCheckNew - System.currentTimeMillis();
        if (l < (long)n) {
            n = (int)l;
        }
        if (n < 2) {
            Debugutil.stop();
        }
        if (n > 500) {
            n = 500;
        }
        return n;
    }

    protected final int stepThread() {
        int n;
        boolean bl;
        do {
            this.stateThreadTimer = (char)99;
            this.timeSleep = System.currentTimeMillis();
            n = (int)(this.timeCheckNew - this.timeSleep);
            if (n < 0) {
                n = this.checkTimeOrders();
            }
            bl = false;
            while (this.checkEventAndRun()) {
                bl = true;
            }
            if (!bl || (this.debugPrint & 2) == 0) continue;
            System.out.printf("TimeOrderMng not wait %d\n", n);
        } while (bl);
        if ((this.debugPrint & 1) != 0) {
            System.out.printf("TimeOrderMng wait %d\n", n);
        }
        if (n < 2) {
            n = 2;
        }
        if (n > 120) {
            Debugutil.stop();
        }
        return n;
    }

    @Override
    public final boolean isCurrentThread() {
        return this.threadTimer == Thread.currentThread();
    }

    public final char getState() {
        return this.stateThreadTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimer() {
        Runnable runnable = this.runTimer;
        synchronized (runnable) {
            if (this.stateThreadTimer == 'W') {
                this.runTimer.notify();
            }
        }
    }

    @Override
    public CharSequence infoAppend(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("Thread ").append(this.threadName);
        stringBuilder.append("; ");
        return stringBuilder;
    }

    public String toString() {
        if (this.preserveRecursiveInfoAppend) {
            return this.threadName;
        }
        return this.infoAppend(null).toString();
    }
}

