/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.communication;

import org.vishia.communication.Address_InterProcessComm;
import org.vishia.communication.InterProcessComm;
import org.vishia.communication.InterProcessCommFactory;
import org.vishia.communication.InterProcessCommRx_ifc;
import org.vishia.util.Assert;
import org.vishia.util.Java4C;

public class InterProcessCommRxThread {
    public static final String version = "2015-06-13";
    @Java4C.SimpleRef
    private final InterProcessCommRx_ifc execRxData;
    private char state;
    private boolean bEnablePrintfOnComm;
    private final InterProcessComm ipc;
    private int ctErrorTelg;
    private final Thread thread;
    private final int[] nrofBytesReceived = new int[1];
    @Java4C.SimpleArray
    private final byte[] data_rxBuffer = new byte[1500];
    @Java4C.PtrVal
    private final byte[] rxBuffer = this.data_rxBuffer;
    private final Address_InterProcessComm myAnswerAddress;
    private final Runnable threadRoutine = new Runnable(){

        @Override
        public void run() {
            InterProcessCommRxThread.this.runThread();
        }
    };

    public InterProcessCommRxThread(String string, InterProcessCommRx_ifc interProcessCommRx_ifc) {
        this.execRxData = interProcessCommRx_ifc;
        InterProcessCommFactory interProcessCommFactory = InterProcessCommFactory.getInstance();
        InterProcessComm interProcessComm = interProcessCommFactory.create(string);
        this.myAnswerAddress = interProcessComm.createAddress();
        this.thread = new Thread(this.threadRoutine, "IpcRx");
        this.ipc = interProcessComm;
    }

    public static InterProcessCommRxThread create(String string, InterProcessCommRx_ifc interProcessCommRx_ifc) {
        InterProcessCommRxThread interProcessCommRxThread = new InterProcessCommRxThread(string, interProcessCommRx_ifc);
        return interProcessCommRxThread;
    }

    public final Address_InterProcessComm createDstAddr(String string) {
        InterProcessComm interProcessComm = this.ipc;
        return interProcessComm.createAddress(string);
    }

    private final boolean openComm(boolean bl) {
        InterProcessComm interProcessComm = this.ipc;
        int n = interProcessComm.open(null, bl);
        this.state = (char)(n >= 0 ? 111 : 101);
        if (n < 0 && !this.bEnablePrintfOnComm) {
            String string = interProcessComm.translateErrorMsg(n);
            System.out.format("\nopen fails: error, %d = %s\n", n & Integer.MAX_VALUE, string);
        }
        if (this.bEnablePrintfOnComm) {
            if (n >= 0) {
                System.out.print("\nopen RxThread-Communication ok\n");
            } else {
                System.out.format("\nopen RxThread-Communication error: %d\n", -n);
            }
        }
        return n >= 0;
    }

    public final boolean start() {
        boolean bl = this.openComm(true);
        if (bl) {
            this.thread.start();
        }
        return bl;
    }

    public final int send(@Java4C.PtrVal byte[] byArray, int n, Address_InterProcessComm address_InterProcessComm) {
        InterProcessComm interProcessComm = this.ipc;
        return interProcessComm.send(byArray, n, address_InterProcessComm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runThread() {
        while (this.state != 'x') {
            if (this.state == 'o') {
                this.receiveAndExecute();
                continue;
            }
            this.state = (char)69;
            while (this.state == 'E') {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        InterProcessCommRxThread interProcessCommRxThread = this;
        synchronized (interProcessCommRxThread) {
            this.state = (char)122;
            this.notify();
        }
    }

    private final void receiveAndExecute() {
        InterProcessCommRx_ifc interProcessCommRx_ifc = this.execRxData;
        InterProcessComm interProcessComm = this.ipc;
        while (this.state != 'x') {
            this.nrofBytesReceived[0] = 0;
            this.state = (char)114;
            try {
                interProcessComm.receiveData(this.nrofBytesReceived, this.rxBuffer, this.myAnswerAddress);
                if (this.state == 'x') continue;
                if (this.nrofBytesReceived[0] < 0) {
                    this.state = (char)101;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.state = (char)114;
                    continue;
                }
                interProcessCommRx_ifc.execRxData(this.rxBuffer, this.nrofBytesReceived[0], this.myAnswerAddress);
            }
            catch (Exception exception) {
                CharSequence charSequence = Assert.exceptionInfo("org.vishia.inspector.Comm - unexpected Exception; ", exception, 0, 7);
                System.err.println(charSequence);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        if (this.state == 'e') {
            return;
        }
        this.state = (char)120;
        InterProcessComm interProcessComm = this.ipc;
        interProcessComm.close();
        while (this.state != 'z') {
            InterProcessCommRxThread interProcessCommRxThread = this;
            synchronized (interProcessCommRxThread) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

