/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.checkDeps_C;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.checkDeps_C.AddDependency_InfoFileDependencies;
import org.vishia.checkDeps_C.ObjectFileDeps;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.Assert;
import org.vishia.util.Debugutil;
import org.vishia.util.FileFunctions;
import org.vishia.util.FileSystem;
import org.vishia.util.UnexpectedException;

public class InfoFileDependencies
implements AddDependency_InfoFileDependencies {
    public static final int version = 20121225;
    private static DateFormat formatTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static String spaces = "                                                                                                ";
    final MainCmdLogging_ifc console;
    final String sFilePathIncludeline;
    final File fileSrc;
    final String sAbsolutePath;
    final File fileMirror;
    final long dateFileSrc;
    private long dateFileMirror;
    long timestampNewestDependingFiles_;
    private char cNewly = (char)32;
    private final boolean isSrc;
    private String sDateNameLine;
    final Map<String, InfoFileDependencies> includedPrimaryDeps = new TreeMap<String, InfoFileDependencies>();
    final Map<String, InfoFileDependencies> includedPrimaryFiles = new TreeMap<String, InfoFileDependencies>();
    final Map<String, InfoFileDependencies> includedAllFiles = new TreeMap<String, InfoFileDependencies>();
    final Map<String, InfoFileDependencies> includingPrimaryFiles = new TreeMap<String, InfoFileDependencies>();
    final Map<String, InfoFileDependencies> includingAllFiles = new TreeMap<String, InfoFileDependencies>();

    public InfoFileDependencies(String string, File file, File file2, boolean bl, MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.console = mainCmdLogging_ifc;
        this.sFilePathIncludeline = string;
        this.fileSrc = file;
        this.fileMirror = file2;
        this.sAbsolutePath = file.exists() ? FileFunctions.normalizePath(file).toString() : null;
        this.isSrc = bl;
        this.timestampNewestDependingFiles_ = this.dateFileSrc = file == null ? 0L : file.lastModified();
    }

    public InfoFileDependencies(String string, MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.console = mainCmdLogging_ifc;
        this.sFilePathIncludeline = string;
        this.fileSrc = null;
        this.fileMirror = null;
        this.sAbsolutePath = string;
        this.isSrc = false;
        this.dateFileSrc = 0L;
        this.timestampNewestDependingFiles_ = 0L;
    }

    void addAllParentDependency(InfoFileDependencies infoFileDependencies, ObjectFileDeps objectFileDeps, int n) {
        InfoFileDependencies infoFileDependencies2;
        if (n > 89) {
            Debugutil.stop();
        }
        if (n > 99) {
            throw new IllegalArgumentException("CheckDeps - recursion to deep for addAllParentDependencies;" + infoFileDependencies.toString());
        }
        infoFileDependencies.includingAllFiles.put(this.sAbsolutePath, this);
        this.includedAllFiles.put(infoFileDependencies.sAbsolutePath, infoFileDependencies);
        for (Map.Entry<String, InfoFileDependencies> entry : infoFileDependencies.includedAllFiles.entrySet()) {
            infoFileDependencies2 = entry.getValue();
            infoFileDependencies2.includingAllFiles.put(this.sAbsolutePath, this);
            this.includedAllFiles.put(infoFileDependencies2.sAbsolutePath, infoFileDependencies2);
        }
        if (infoFileDependencies.isNewlyOrIncludedNewly()) {
            this.notifyIncludedNewly(objectFileDeps);
        }
        for (Map.Entry<String, InfoFileDependencies> entry : this.includingPrimaryFiles.entrySet()) {
            infoFileDependencies2 = entry.getValue();
            infoFileDependencies2.addAllParentDependency(infoFileDependencies, objectFileDeps, n + 1);
        }
    }

    @Override
    public void addDependency(InfoFileDependencies infoFileDependencies, ObjectFileDeps objectFileDeps) {
        this.includedPrimaryFiles.put(infoFileDependencies.sAbsolutePath, infoFileDependencies);
        infoFileDependencies.includingPrimaryFiles.put(this.sAbsolutePath, this);
        if (infoFileDependencies.isNewlyOrIncludedNewly()) {
            this.notifyIncludedNewly(objectFileDeps);
        }
        this.addAllParentDependency(infoFileDependencies, objectFileDeps, 0);
    }

    public void notifyNewly(ObjectFileDeps objectFileDeps) {
        this.cNewly = (char)33;
        this.dateFileMirror = this.fileMirror != null ? this.fileMirror.lastModified() : 0L;
        this.sDateNameLine = null;
        if (objectFileDeps != null) {
            objectFileDeps.notifyNewer(this, this.console);
        }
    }

    public void notifyIncludedNewly(ObjectFileDeps objectFileDeps) {
        switch (this.cNewly) {
            case '!': {
                break;
            }
            case '&': {
                break;
            }
            case ' ': {
                this.cNewly = (char)38;
                break;
            }
            case '^': {
                this.cNewly = (char)36;
                break;
            }
            case '?': {
                break;
            }
            case '$': {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (objectFileDeps != null) {
            objectFileDeps.notifyNewer(this, this.console);
        }
        this.dateFileMirror = this.fileMirror != null ? this.fileMirror.lastModified() : 0L;
        this.sDateNameLine = null;
    }

    public void notifyChangedTimestamp() {
        switch (this.cNewly) {
            case '!': {
                break;
            }
            case '&': {
                this.cNewly = (char)36;
                break;
            }
            case ' ': {
                this.cNewly = (char)94;
                break;
            }
            case '^': {
                break;
            }
            case '?': {
                break;
            }
            case '$': {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.dateFileMirror = this.fileMirror != null ? this.fileMirror.lastModified() : 0L;
        this.sDateNameLine = null;
    }

    public boolean isNewlyItself() {
        return this.cNewly == '!';
    }

    public boolean isNewlyOrIncludedNewly() {
        return "!&$".indexOf(this.cNewly) >= 0;
    }

    public boolean shouldWriteNewly() {
        return this.cNewly != ' ';
    }

    public boolean isSrcFile() {
        return this.isSrc;
    }

    long getDateFile() {
        if (this.dateFileMirror != 0L) {
            return this.dateFileMirror;
        }
        return this.dateFileSrc;
    }

    public String getDataNameLine() {
        if (this.sDateNameLine == null) {
            long l = this.fileSrc.lastModified();
            String string = formatTimestamp.format(new Date(l));
            if (this.fileMirror != null && this.fileMirror.exists()) {
                long l2 = this.fileMirror.lastModified();
                String string2 = formatTimestamp.format(new Date(l2));
                this.sDateNameLine = string2 + "; " + l2 + "; " + FileFunctions.normalizePath(this.fileMirror) + "; " + this.cNewly + "; " + FileFunctions.normalizePath(this.fileSrc) + "; " + l + "; " + string;
            } else {
                this.sDateNameLine = string + "; " + l + "; " + this.sAbsolutePath;
            }
        }
        return this.sDateNameLine;
    }

    public void xxx_writeDependenciesOfFile(File file, MainCmdLogging_ifc mainCmdLogging_ifc) {
        mainCmdLogging_ifc.reportln(5, "write file.dep; " + file.getAbsolutePath());
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        try {
            FileSystem.mkDirPath(file);
            FileWriter fileWriter = new FileWriter(file);
            this.writeDependendingFiles(fileWriter, treeMap, mainCmdLogging_ifc, 0);
            ((Writer)fileWriter).close();
        }
        catch (IOException iOException) {
            mainCmdLogging_ifc.writeError("writeDependencies:", iOException);
        }
    }

    public void writeDependendingFiles(Appendable appendable, Map<String, String> map, MainCmdLogging_ifc mainCmdLogging_ifc, int n) throws IOException {
        if (n >= spaces.length() / 2) {
            appendable.append("- ; to many includes\n");
        } else {
            String string = this.getDataNameLine();
            String string2 = Integer.toString(n);
            appendable.append(string2).append("; ").append(spaces.substring(0, 2 * n)).append(string).append("\n");
            mainCmdLogging_ifc.reportln(5, "  depending; " + string);
            if (this.includedPrimaryFiles != null) {
                for (Map.Entry<String, InfoFileDependencies> entry : this.includedPrimaryFiles.entrySet()) {
                    InfoFileDependencies infoFileDependencies = entry.getValue();
                    String string3 = entry.getKey();
                    if (map.get(string3) == null) {
                        infoFileDependencies.writeDependendingFiles(appendable, map, mainCmdLogging_ifc, n + 1);
                        map.put(string3, string3);
                        continue;
                    }
                    String string4 = infoFileDependencies.getDataNameLine();
                    appendable.append("+").append(Integer.toString(n + 1)).append(";").append(spaces.substring(0, 2 * (n + 1))).append(string4).append("\n");
                }
            }
        }
    }

    static void writeAllBackDeps(String string, Map<String, InfoFileDependencies> map) {
        Writer writer = null;
        try {
            if (string != null) {
                File file = FileFunctions.newFile(string);
                try {
                    FileSystem.mkDirPath(file);
                    writer = new FileWriter(file);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("CheckDeps_C - argument error; cannot create -depAll=" + string);
                }
            }
            writer.append("#This file contains all dependencies. It will be used as input for dependency check.");
            writer.append("\n#This file will be replaced after the dependency check with the new situation.");
            writer.append("\n#Special designation chars:");
            writer.append("\n# ^ Changed timestamp, but no content change outside comments in comparison with the mirror file.");
            writer.append("\n# & Recompile the file and all using files because an included file is changed.");
            writer.append("\n# $ Recompile like &, this file has a changed timestamp, but no content change outside comments too.");
            writer.append("\n# ! This file is changed, force recompile of all including files.");
            writer.append("\n");
            writer.append("\n#Include designation:");
            writer.append("\n# - Direct included.");
            writer.append("\n# + Indirect included in another included file.");
            writer.append("\n# * This file includes the named file directly. It depends on it.");
            writer.append("\n# % This file includes the named file indirectly. It depends on it.");
            writer.append("\n");
            for (Map.Entry entry : map.entrySet()) {
                InfoFileDependencies infoFileDependencies;
                String string2 = (String)entry.getKey();
                if (string2.contains("param_values.h")) {
                    Assert.stop();
                }
                InfoFileDependencies infoFileDependencies2 = (InfoFileDependencies)entry.getValue();
                writer.append("\n");
                writer.append("\nFile: ").append(infoFileDependencies2.getDataNameLine()).append(";");
                writer.append("\n  .includes: ");
                for (Map.Entry<String, InfoFileDependencies> entry2 : infoFileDependencies2.includedPrimaryFiles.entrySet()) {
                    infoFileDependencies = entry2.getValue();
                    writer.append("\n ").append(infoFileDependencies.cNewly);
                    writer.append("- ").append(infoFileDependencies.sAbsolutePath);
                }
                for (Map.Entry<String, InfoFileDependencies> entry2 : infoFileDependencies2.includedAllFiles.entrySet()) {
                    infoFileDependencies = entry2.getValue();
                    if (infoFileDependencies2.includedPrimaryFiles.get(infoFileDependencies.sAbsolutePath) != null) continue;
                    writer.append("\n ").append(infoFileDependencies.cNewly);
                    writer.append("+ ").append(infoFileDependencies.sAbsolutePath);
                }
                writer.append("\n  .is included in: ");
                for (Map.Entry<String, InfoFileDependencies> entry2 : infoFileDependencies2.includingPrimaryFiles.entrySet()) {
                    infoFileDependencies = entry2.getValue();
                    writer.append("\n  * " + infoFileDependencies.sAbsolutePath);
                }
                for (Map.Entry<String, InfoFileDependencies> entry2 : infoFileDependencies2.includingAllFiles.entrySet()) {
                    infoFileDependencies = entry2.getValue();
                    if (infoFileDependencies2.includingPrimaryFiles.get(infoFileDependencies.sAbsolutePath) != null) continue;
                    writer.append("\n  % " + infoFileDependencies.sAbsolutePath);
                }
            }
            writer.append("\n");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                throw new UnexpectedException(iOException);
            }
        }
    }

    void xxx_writeBackDeps(InfoFileDependencies infoFileDependencies, InfoFileDependencies infoFileDependencies2, Writer writer) throws IOException {
        for (Map.Entry<String, InfoFileDependencies> entry : infoFileDependencies2.includingPrimaryFiles.entrySet()) {
            InfoFileDependencies infoFileDependencies3 = entry.getValue();
            if (infoFileDependencies.includingPrimaryFiles.get(infoFileDependencies3.sAbsolutePath) == null) {
                writer.append("\n  + " + infoFileDependencies3.sAbsolutePath);
            }
            this.xxx_writeBackDeps(infoFileDependencies, infoFileDependencies3, writer);
        }
    }

    public String toString() {
        return "" + this.cNewly + this.sFilePathIncludeline;
    }
}

