/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlReader;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import org.vishia.genJavaOutClass.GenJavaOutClass;
import org.vishia.mainCmd.MainCmd;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.StringFunctions_B;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlJzReader;

public class GenXmlCfgJavaData {
    public static final String sVersion = "2025-12-14";
    protected final GenJavaOutClass.CmdArgs cmdArgs;
    protected final LogMessage log;
    protected final GenJavaOutClass genClass;
    protected Map<String, XmlCfg.XmlCfgNode> subtrees;

    public GenXmlCfgJavaData(GenJavaOutClass.CmdArgs cmdArgs, LogMessage logMessage) {
        this.cmdArgs = cmdArgs;
        this.genClass = new GenJavaOutClass(cmdArgs, logMessage);
        this.log = logMessage;
    }

    public void exec() throws IOException {
        XmlCfg xmlCfg;
        String string = this.cmdArgs.fileInput.getName();
        if (string.endsWith(".xml")) {
            XmlJzReader xmlJzReader = new XmlJzReader();
            xmlJzReader.readCfg(this.cmdArgs.fileInput);
            xmlCfg = xmlJzReader.cfg;
        } else {
            xmlCfg = new XmlCfg();
            xmlCfg.readCfgFile(this.cmdArgs.fileInput, this.log);
        }
        this.exec(xmlCfg);
    }

    public void exec(XmlCfg xmlCfg) {
        this.subtrees = xmlCfg.subtrees;
        Debugutil.stop();
        this.genClass.setupWriter();
        try {
            XmlCfg.XmlCfgNode xmlCfgNode;
            WrClassXml wrClassXml = new WrClassXml();
            SubClassXml subClassXml = new SubClassXml("root", "root");
            subClassXml.subItem = xmlCfgNode = xmlCfg.rootNode;
            String string = this.cmdArgs.sJavaClass + ".";
            wrClassXml.evaluateChildren(string, xmlCfgNode, subClassXml, false, 1);
            wrClassXml.wrClassJava.writeOperations();
            int n = 0;
            while (this.genClass.listCmpn.size() > n) {
                SubClassXml subClassXml2 = (SubClassXml)this.genClass.listCmpn.get(n++);
                WrClassXml wrClassXml2 = new WrClassXml();
                wrClassXml2.wrClassJava.wrClassCmpn(subClassXml2, null);
                wrClassXml2.evaluateChildren(string, subClassXml2.subItem, subClassXml2, false, 0);
                wrClassXml2.wrClassJava.writeOperations();
                this.genClass.finishCmpnWrite();
            }
            this.genClass.finishClassWrite();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        this.genClass.closeWrite();
    }

    public static void main(String[] stringArray) {
        GenXmlCfgJavaData.smain(stringArray, true);
    }

    public static String smain(String[] stringArray) {
        return GenXmlCfgJavaData.smain(stringArray, false);
    }

    private static String smain(String[] stringArray, boolean bl) {
        String string;
        if (stringArray.length == 0) {
            System.out.println("java -cp .... org.vishia.xmlReader.GenXmlCfgJavaData -cfg:INFILE -dirJava:PATH -pkg:PKG -class:CLASS\n  -cfg:INFILE: The config.xml file as config file for XmlJzReader\n  -dirJava:path/to/javaSrcRoot to create\n  -pkg:my.pkg.path The package path\n  -class:MyClass without .java, class to create");
            string = "";
        } else {
            GenJavaOutClass.CmdArgs cmdArgs = new GenJavaOutClass.CmdArgs();
            CmdLine cmdLine = new CmdLine(cmdArgs, stringArray);
            try {
                boolean bl2;
                cmdLine.addCmdLineProperties();
                try {
                    bl2 = cmdLine.parseArguments();
                }
                catch (Exception exception) {
                    cmdLine.report("Argument error:", exception);
                    cmdLine.setExitErrorLevel(5);
                    bl2 = false;
                }
                if (bl2) {
                    GenXmlCfgJavaData genXmlCfgJavaData = new GenXmlCfgJavaData(cmdArgs, cmdLine);
                    try {
                        genXmlCfgJavaData.exec();
                    }
                    catch (Exception exception) {
                        System.err.println(exception.getMessage());
                    }
                }
                string = "";
            }
            catch (Exception exception) {
                string = exception.getMessage();
            }
            if (bl) {
                cmdLine.exit();
            }
        }
        return string;
    }

    private static class CmdLine
    extends MainCmd {
        public final MainCmd.Argument[] defArguments = new MainCmd.Argument[]{new MainCmd.Argument("-cfg", ":<fileCfg.xml>    Xml cfg file", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.fileInput = new File(string);
                return true;
            }
        }), new MainCmd.Argument("-struct", ":<fileStruct.txt> out file to show the struct, optional", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.fileOutStruct = new File(string);
                return true;
            }
        }), new MainCmd.Argument("-dirJava", ":<dirJava>    directory for Java output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.dirJava = new File(string);
                return true;
            }
        }), new MainCmd.Argument("-pkg", ":<pkg.path>    directory for Java output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sJavaPkg = string;
                return true;
            }
        }), new MainCmd.Argument("-class", ":<class>     name and file <class>.java for Java output", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sJavaClass = string;
                return true;
            }
        })};
        public final GenJavaOutClass.CmdArgs argData;

        protected CmdLine(GenJavaOutClass.CmdArgs cmdArgs, String[] stringArray) {
            super(stringArray);
            this.argData = cmdArgs;
        }

        void addCmdLineProperties() {
            super.addAboutInfo("Generate Java source code as destination class from XML cfg file");
            super.addAboutInfo("made by HSchorrig, 2019-08-16..2019-08-29");
            super.addArgument(this.defArguments);
            super.addHelpInfo("==Standard arguments of MainCmd==");
            super.addStandardHelpInfo();
        }

        @Override
        protected boolean checkArguments() {
            boolean bl = true;
            if (this.argData.fileInput == null) {
                bl = false;
                this.writeError("ERROR argument Syntaxfile is obligat.");
            } else if (!this.argData.fileInput.exists()) {
                bl = false;
                this.writeError("ERROR argument Syntaxfile not found " + this.argData.fileInput.getAbsolutePath());
            } else if (this.argData.fileInput.length() == 0L) {
                bl = false;
                this.writeError("ERROR argument Syntaxfile without content.");
            }
            return bl;
        }
    }

    private class WrClassXml {
        final GenJavaOutClass.WrClassJava wrClassJava;

        WrClassXml() {
            this.wrClassJava = GenXmlCfgJavaData.this.genClass.new GenJavaOutClass.WrClassJava();
        }

        private SubClassXml getRegisterSubclass(String string, XmlCfg.XmlCfgNode xmlCfgNode) {
            SubClassXml subClassXml = (SubClassXml)GenXmlCfgJavaData.this.genClass.idxRegisteredCmpn.get(string);
            if (subClassXml == null) {
                subClassXml = new SubClassXml(string, GenJavaOutClass.firstUppercaseIdentifier(string));
                subClassXml.sDbgIdent = "xxx";
                subClassXml.subItem = xmlCfgNode;
                GenXmlCfgJavaData.this.genClass.idxRegisteredCmpn.put(string, subClassXml);
                GenXmlCfgJavaData.this.genClass.listCmpn.add(subClassXml);
            }
            return subClassXml;
        }

        private void evaluateSubCmpn(XmlCfg.XmlCfgNode xmlCfgNode, boolean bl, int n) throws Exception {
        }

        void evaluateChildren(String string, XmlCfg.XmlCfgNode xmlCfgNode, SubClassXml subClassXml, boolean bl, int n) throws Exception {
            Object object;
            System.out.println(xmlCfgNode.tag);
            if (xmlCfgNode.attribs != null) {
                for (Map.Entry<String, XmlCfg.AttribDstCheck> entry : xmlCfgNode.attribs.entrySet()) {
                    object = entry.getValue();
                    String string2 = StringFunctions_B.replaceNonIdentifierChars(((XmlCfg.AttribDstCheck)object).name, '-').toString();
                    this.wrVariable(subClassXml, null, "String", string2, ((XmlCfg.AttribDstCheck)object).daccess, ((XmlCfg.AttribDstCheck)object).daccess, "Attribute " + ((XmlCfg.AttribDstCheck)object).name, true, false, false);
                }
            }
            if (xmlCfgNode.contentStorePath != null) {
                this.wrVariable(subClassXml, null, "String", "_textContent", null, xmlCfgNode.contentStorePath, "TEXT content ", true, xmlCfgNode.bTextMoreOccurrences, false);
            }
            if (xmlCfgNode.subnodes != null) {
                for (Map.Entry<String, Object> entry : xmlCfgNode.subnodes.entrySet()) {
                    String string3;
                    Object object2;
                    object = (XmlCfg.XmlCfgNode)entry.getValue();
                    boolean bl2 = ((XmlCfg.XmlCfgNode)object).bList;
                    if (((XmlCfg.XmlCfgNode)object).cfgSubtreeName != null) {
                        object2 = GenXmlCfgJavaData.this.subtrees.get(((XmlCfg.XmlCfgNode)object).cfgSubtreeName);
                        if (object == null) {
                            GenXmlCfgJavaData.this.log.writef("\nERROR subtree missing: %s", ((XmlCfg.XmlCfgNode)object).cfgSubtreeName);
                        }
                    } else {
                        object2 = object;
                    }
                    if (object2 == null) continue;
                    if (((XmlCfg.XmlCfgNode)object2).dstClassName != null) {
                        string3 = GenJavaOutClass.firstUppercaseIdentifier(((XmlCfg.XmlCfgNode)object2).dstClassName);
                        if (GenXmlCfgJavaData.this.genClass.idxStdTypes.get(string3) != null) {
                            string3 = string3 + "__";
                        }
                        SubClassXml subClassXml2 = this.getRegisterSubclass(string3, (XmlCfg.XmlCfgNode)object2);
                        String string4 = StringFunctions_B.replaceNonIdentifierChars(((XmlCfg.XmlCfgNode)object2).tag, '-').toString();
                        this.wrVariable(subClassXml, string, string3, string4, ((XmlCfg.XmlCfgNode)object).elementCreatePath, ((XmlCfg.XmlCfgNode)object).elementFinishPath, "Complex node " + ((XmlCfg.XmlCfgNode)object).tag, false, bl2, true);
                        continue;
                    }
                    string3 = StringFunctions_B.replaceNonIdentifierChars(((XmlCfg.XmlCfgNode)object2).tag, '-').toString();
                    this.wrVariable(subClassXml, null, "String", string3, ((XmlCfg.XmlCfgNode)object).elementCreatePath, ((XmlCfg.XmlCfgNode)object).elementFinishPath, "Simple node " + ((XmlCfg.XmlCfgNode)object2).tag, true, false, false);
                }
            }
            this.wrClassJava.writeListAllNodes(null);
        }

        protected void wrVariable(SubClassXml subClassXml, String string, String string2, String string3, DataAccess.DatapathElement datapathElement, DataAccess.DatapathElement datapathElement2, String string4, boolean bl, boolean bl2, boolean bl3) throws Exception {
            if (string3 != null && string3.length() > 0) {
                String string5;
                if (string3.startsWith("ST")) {
                    Debugutil.stop();
                }
                if (string2.equals("Section_A")) {
                    Debugutil.stop();
                }
                if ((string5 = this.wrClassJava.variables.get(string3)) != null) {
                    if (!string5.equals(string2)) {
                        throw new IllegalArgumentException("Semantic " + string3 + " with different types");
                    }
                } else {
                    int n;
                    int n2;
                    if (string2.equals("Integer")) {
                        string2 = "int";
                    }
                    if (string3.equals("FBType")) {
                        Debugutil.stop();
                    }
                    if (string3.indexOf("@") >= 0) {
                        Debugutil.stop();
                    }
                    LinkedList<String> linkedList = null;
                    if (bl3 && (n2 = datapathElement.nrArgNames()) > 0) {
                        linkedList = new LinkedList<String>();
                        for (n = 0; n < n2; n += 1) {
                            String string6 = datapathElement.argName(n);
                            linkedList.add(GenJavaOutClass.firstLowercaseIdentifier(string6));
                        }
                    }
                    String string7 = datapathElement2.ident();
                    n = datapathElement2.whatisit() == '(' ? 1 : 0;
                    this.wrClassJava.wrVariable(subClassXml, string3, string, string2, string7, n != 0, string2, string4, bl, bl2, bl3, linkedList);
                }
            }
        }

        private void registerCmpn(String string) {
            if (GenXmlCfgJavaData.this.genClass.idxRegisteredCmpn.get(string) == null) {
                XmlCfg.XmlCfgNode xmlCfgNode = GenXmlCfgJavaData.this.subtrees.get(string);
                if (xmlCfgNode == null) {
                    throw new IllegalArgumentException("syntax component not found: " + string);
                }
                SubClassXml subClassXml = new SubClassXml(string, GenJavaOutClass.firstUppercaseIdentifier(xmlCfgNode.tag.toString()));
                subClassXml.sDbgIdent = xmlCfgNode.tag.toString();
                subClassXml.subItem = null;
                GenXmlCfgJavaData.this.genClass.idxRegisteredCmpn.put(string, subClassXml);
                GenXmlCfgJavaData.this.genClass.listCmpn.add(subClassXml);
            }
        }
    }

    static class SubClassXml
    extends GenJavaOutClass.SubClassJava {
        XmlCfg.XmlCfgNode subItem;

        SubClassXml(String string, String string2) {
            super(string, string2, null);
        }
    }
}

