/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.vishia.util.StringFormatter;

public class StdHexFormatWriter
extends OutputStream {
    final Writer hexOutput;
    final byte[] buffer = new byte[16];
    final StringFormatter line = new StringFormatter(45);
    int addr = 0;
    int addrHiWritten = 0;
    int ixBuffer = -1;

    public StdHexFormatWriter(File file) throws FileNotFoundException {
        try {
            this.hexOutput = new FileWriter(file);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
    }

    public void setAddress(int n) throws IOException {
        this.flush();
        this.addr = n;
    }

    private void writeLine() throws IOException {
        byte by;
        if (this.addrHiWritten != (this.addr & 0xFFFF0000)) {
            this.addrHiWritten = this.addr & 0xFFFF0000;
            this.line.reset().add(":02000002").addHex(this.addrHiWritten >> 4, 4);
            by = (byte)(4 + (this.addrHiWritten >> 4) + (this.addrHiWritten >> 12));
            this.line.addHex(-by, 2).add("\r\n");
            this.hexOutput.write(this.line.toString());
        }
        this.line.reset().add(":").addHex(this.ixBuffer + 1, 2).addHex(this.addr, 4).add("00");
        by = (byte)(this.ixBuffer + 1 + this.addr + (this.addr >> 8));
        for (int i = 0; i <= this.ixBuffer; ++i) {
            byte by2 = this.buffer[i];
            by = (byte)(by + by2);
            this.line.addHex(by2, 2);
        }
        this.line.addHex(-by, 2).add("\r\n");
        this.hexOutput.write(this.line.toString());
        this.addr += this.ixBuffer + 1;
        this.ixBuffer = -1;
        this.line.reset();
    }

    @Override
    public void write(int n) throws IOException {
        this.buffer[++this.ixBuffer] = (byte)n;
        if (this.ixBuffer >= 15) {
            this.writeLine();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.ixBuffer >= 0) {
            this.writeLine();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.hexOutput.write(":00000001FF\r\n");
        this.hexOutput.close();
    }
}

