/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.util.Arrays;
import java.util.Date;

public class LeapSeconds {
    protected static LeapSeconds singleton;
    protected final int[] leapSeconds = new int[30];
    protected long[] millisecondsUTCForLeapSeconds = new long[30];
    protected long[] millisecondsGPSForLeapSeconds = new long[30];

    protected LeapSeconds() {
        this.initFix();
    }

    public static void setLeapSeconds(int n, Date date) {
        if (singleton == null) {
            singleton = new LeapSeconds();
        }
        if (n < 0 || n > LeapSeconds.singleton.leapSeconds.length) {
            throw new IllegalArgumentException("The number of leap seconds should be not greater than" + (LeapSeconds.singleton.leapSeconds.length - 1));
        }
        LeapSeconds.singleton.leapSeconds[n] = n;
        LeapSeconds.singleton.millisecondsUTCForLeapSeconds[n] = date.getTime();
        LeapSeconds.singleton.millisecondsGPSForLeapSeconds[n] = (long)n + date.getTime();
    }

    protected void initFix() {
        int n = -1;
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(72, 6, 30, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(72, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(73, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(74, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(75, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(76, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(77, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(78, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(79, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(81, 6, 30, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(82, 6, 30, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(83, 6, 30, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(85, 6, 30, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(87, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(89, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(90, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(92, 6, 30, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(93, 6, 30, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(94, 6, 30, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(95, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(97, 6, 30, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(98, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(105, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(108, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(111, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(113, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(116, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(119, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(122, 12, 31, 23, 59, 59);
        this.millisecondsUTCForLeapSeconds[++n] = Date.UTC(125, 12, 31, 23, 59, 59);
        for (n = 0; n < this.leapSeconds.length; ++n) {
            this.leapSeconds[n] = n;
            this.millisecondsGPSForLeapSeconds[n] = this.millisecondsUTCForLeapSeconds[n] + (long)n;
        }
    }

    public static Date dateFromGPS(long l) {
        int n;
        if (singleton == null) {
            singleton = new LeapSeconds();
        }
        if ((n = Arrays.binarySearch(LeapSeconds.singleton.millisecondsGPSForLeapSeconds, l)) < 0) {
            n = -n - 1;
        }
        return new Date(l - (long)(1000 * n));
    }

    public static long millisecondsGPSfromUTC(long l) {
        int n;
        if (singleton == null) {
            singleton = new LeapSeconds();
        }
        if ((n = Arrays.binarySearch(LeapSeconds.singleton.millisecondsUTCForLeapSeconds, l)) < 0) {
            n = -n - 1;
        }
        return l + (long)(1000 * n);
    }

    public static int secondsGPSfromUTC(int n) {
        int n2;
        if (singleton == null) {
            singleton = new LeapSeconds();
        }
        if ((n2 = Arrays.binarySearch(LeapSeconds.singleton.millisecondsGPSForLeapSeconds, (long)n * 1000L)) < 0) {
            n2 = -n2 - 1;
        }
        return n + n2;
    }
}

