/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.vishia.util.IterableIterator;

public class IteratorMask<T>
implements IterableIterator<T> {
    private int ix = -1;
    private final Iterator<T> iterSrc;
    private final T[] array;
    private T elem;
    private final long mask;
    boolean bExecHasNext = false;

    public IteratorMask(Iterator<T> iterator, long l) {
        this.iterSrc = iterator;
        this.array = null;
        this.mask = l;
    }

    public IteratorMask(Iterable<T> iterable, long l) {
        this.iterSrc = iterable == null ? null : iterable.iterator();
        this.array = null;
        this.mask = l;
    }

    public IteratorMask(T[] TArray, long l) {
        this.iterSrc = null;
        this.array = TArray;
        this.mask = l;
    }

    @Override
    public boolean hasNext() {
        this.bExecHasNext = true;
        if (this.iterSrc != null) {
            while (this.iterSrc.hasNext()) {
                ++this.ix;
                this.elem = this.iterSrc.next();
                if ((this.mask & (long)(1 << this.ix)) == 0L) continue;
                return true;
            }
        } else if (this.array != null) {
            while (++this.ix < this.array.length) {
                if ((this.mask & (long)(1 << this.ix)) == 0L) continue;
                this.elem = this.array[this.ix];
                return true;
            }
        }
        this.ix = -1;
        return false;
    }

    @Override
    public T next() {
        if (!this.bExecHasNext) {
            this.hasNext();
        }
        this.bExecHasNext = false;
        if (this.ix < 0) {
            throw new NoSuchElementException();
        }
        return this.elem;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public static int getNextAssocIx(int n, long l) {
        int n2 = n + 1;
        if ((l & -1L << n2) == 0L) {
            return -1;
        }
        while (n2 < 64 && (l & 1L << n2) == 0L) {
            ++n2;
        }
        return n2;
    }
}

