/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.vishia.util.Arguments;
import org.vishia.util.ExcUtil;
import org.vishia.util.FileFunctions;

public class ReadWriteFileBase {
    public static final String sVersion = "2023-03-17";

    public static void main(String[] stringArray) {
        ArgsBase argsBase = new ArgsBase("Example for read write file, reads and writes back", "");
        argsBase.readArguments(stringArray);
        try {
            ReadWriteFileBase.smain(argsBase);
        }
        catch (Throwable throwable) {
            CharSequence charSequence = ExcUtil.exceptionInfo("unexpected: ", throwable, 0, 20);
            System.err.println(charSequence);
            System.exit(5);
        }
        System.exit(0);
    }

    public static void smain(ArgsBase argsBase) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(argsBase.fOut), argsBase.csOut);
        for (File file : argsBase.fIn) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), argsBase.csIn));
            while ((string = bufferedReader.readLine()) != null) {
                ((Writer)outputStreamWriter).append(string).append('\n');
            }
            bufferedReader.close();
        }
        ((Writer)outputStreamWriter).close();
    }

    static class ArgsBase
    extends Arguments {
        public Arguments.Argument sfOut = new Arguments.Argument("-o", ":output file path (*.adoc), default: -in:...Y");
        public Arguments.Argument encodingIn = new Arguments.Argument("-inCharset", ":Encoding for -in, default UTF-8");
        public Arguments.Argument encodingOut = new Arguments.Argument("-outCharset", ":Encoding for -o, default UTF-8");
        File dirWrk;
        File fOut;
        List<File> fIn = new LinkedList<File>();
        Arguments.SetArgument set_dirWrk = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                dirWrk = new File(FileFunctions.absolutePath(string, null).toString());
                return true;
            }
        };
        Arguments.SetArgument set_fIn = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                fIn.add(new File(FileFunctions.absolutePath(string, dirWrk)));
                return true;
            }
        };
        Charset csIn;
        Charset csOut;

        ArgsBase(String string, String string2) {
            this.aboutInfo = string;
            this.helpInfo = "obligate args: -in:...";
            this.addArg(new Arguments.Argument("-wd", ":working dir path, default: system's current dir", this.set_dirWrk));
            this.addArg(new Arguments.Argument("-in", ":input file path", this.set_fIn));
            this.addArg(this.sfOut);
            this.addArg(this.encodingIn);
            this.addArg(this.encodingOut);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean testConsistence(Appendable appendable) throws IOException {
            void var3_6;
            if (!(this.dirWrk == null || this.dirWrk.exists() && this.dirWrk.isDirectory())) {
                appendable.append("-wd:" + this.dirWrk.getAbsolutePath() + " : not existing or not a directory\n");
                return false;
            }
            if (this.fIn.size() == 0) {
                appendable.append("-in:path/to/input.adoc is obligate\n");
                return false;
            }
            for (File object2 : this.fIn) {
                if (object2.exists()) continue;
                appendable.append("-in:" + object2.getAbsolutePath() + " : file not found\n");
                return false;
            }
            String string = this.sfOut.val != null ? this.sfOut.val : this.fIn.get(0).getAbsolutePath() + "Y";
            String string2 = FileFunctions.absolutePath(string, this.dirWrk);
            if (string2.endsWith("/")) {
                String string3 = string2 + this.fIn.get(0).getName();
            }
            this.fOut = new File((String)var3_6);
            if (!this.fOut.getParentFile().exists()) {
                appendable.append("-o:" + this.fOut + " : directory does not exist, should be created manually\n");
            }
            this.csIn = this.encodingIn.val != null ? Charset.forName(this.encodingIn.val) : Charset.forName("UTF-8");
            this.csOut = this.encodingOut.val != null ? Charset.forName(this.encodingOut.val) : Charset.forName("UTF-8");
            return true;
        }
    }
}

