/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.states;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import org.vishia.event.EventConsumer;
import org.vishia.event.EventSource;
import org.vishia.event.EventThread_ifc;
import org.vishia.event.EventTimerThread_ifc;
import org.vishia.event.EventWithDst;
import org.vishia.states.StateComposite;
import org.vishia.states.StateSimple;
import org.vishia.util.DataAccess;
import org.vishia.util.DataShow;
import org.vishia.util.InfoAppend;

public class StateMachine
implements EventConsumer,
InfoAppend,
Closeable {
    public static final String version = "2014-10-14";
    public boolean debugState = false;
    public boolean debugTrans = false;
    public boolean debugEntryExit = false;
    public boolean permitException;
    final EventThread_ifc theThread;
    final EventTimerThread_ifc timerThread;
    final EventSource evSourceTimeout;
    final EventWithDst triggerEvent;
    protected final StateCompositeTop stateTop;
    @DataShow.ExcludeShowContent
    HashMap<Integer, StateSimple> stateMap = new HashMap();
    List<StateSimple> stateList = new ArrayList<StateSimple>();
    private final String name;

    public List<StateSimple> stateList() {
        return this.stateList;
    }

    public StateMachine(String string) {
        this(string, null, null);
    }

    public StateMachine(String string, EventTimerThread_ifc eventTimerThread_ifc, EventThread_ifc eventThread_ifc) {
        this.name = string;
        this.theThread = eventThread_ifc;
        this.timerThread = eventTimerThread_ifc;
        this.triggerEvent = eventThread_ifc != null ? new EventWithDst(string + "-trigger", null, this, eventThread_ifc, null) : null;
        this.evSourceTimeout = new EventSource(string);
        Class<?>[] classArray = this.getClass().getDeclaredClasses();
        if (classArray.length == 0) {
            throw new IllegalArgumentException("The StateMachine should have inner classes which are the states.");
        }
        StateSimple[] stateSimpleArray = new StateSimple[classArray.length];
        this.stateTop = new StateCompositeTop(this, stateSimpleArray);
        int n = -1;
        try {
            for (Class<?> clazz : classArray) {
                if (!DataAccess.isOrExtends(clazz, StateSimple.class)) continue;
                Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
                constructorArray[0].setAccessible(true);
                Object obj = constructorArray[0].newInstance(this);
                StateSimple stateSimple = (StateSimple)obj;
                stateSimpleArray[++n] = stateSimple;
                stateSimple.stateId = clazz.getSimpleName();
                stateSimple.stateMachine = this;
                stateSimple.enclState = this.stateTop;
                int n2 = clazz.hashCode();
                this.stateMap.put(n2, stateSimple);
                this.stateList.add(stateSimple);
                try {
                    clazz.getDeclaredField("isDefault");
                    if (this.stateTop.stateDefault != null) {
                        throw new IllegalArgumentException("StateMachine - more as one default state in;" + this.stateTop.stateId);
                    }
                    this.stateTop.stateDefault = stateSimple;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            if (this.stateTop.stateDefault == null) {
                throw new IllegalArgumentException("StateMachine - a default state is necessary. Define \"final boolean isDefault = true\" in one of an inner class State;" + this.stateTop.stateId);
            }
            this.stateTop.stateId = "StateTop";
            this.stateTop.buildStatePathSubstates(null, 0);
            this.stateTop.createTransitionListSubstate(0);
            this.stateTop.prepareTransitionsSubstate(0);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null) {
                throw new RuntimeException(throwable);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected StateMachine(StateSimple[] stateSimpleArray) {
        this.name = "StateMachine";
        this.evSourceTimeout = new EventSource(this.name);
        this.stateTop = new StateCompositeTop(this, stateSimpleArray);
        this.triggerEvent = null;
        this.theThread = null;
        this.timerThread = null;
    }

    @Override
    public final EventThread_ifc evThread() {
        return this.theThread;
    }

    protected int eventDebug(EventObject eventObject) {
        return this.stateTop.processEvent(eventObject);
    }

    public boolean triggerRun(EventSource eventSource) {
        if (this.theThread == null) {
            this.processEvent(null);
            return true;
        }
        if (this.triggerEvent.occupy(eventSource, false)) {
            this.triggerEvent.sendEvent("triggerRun");
        }
        return false;
    }

    public StateSimple getState(Class<? extends StateSimple> clazz) {
        int n = clazz.hashCode();
        StateSimple stateSimple = this.stateMap.get(n);
        return stateSimple;
    }

    public boolean isInState(Class<? extends StateSimple> clazz) {
        int n = clazz.hashCode();
        StateSimple stateSimple = this.stateMap.get(n);
        if (stateSimple == null) {
            throw new IllegalArgumentException("not a state class: " + clazz.getCanonicalName());
        }
        return stateSimple.isInState();
    }

    @Override
    public int processEvent(EventObject eventObject) {
        if (this.theThread == null || this.theThread.isCurrentThread()) {
            return this.eventDebug(eventObject);
        }
        if (eventObject != null) {
            if (eventObject instanceof EventWithDst) {
                EventWithDst eventWithDst = (EventWithDst)eventObject;
                eventWithDst.setDst(this);
            }
            this.theThread.storeEvent(eventObject);
            return 3;
        }
        return 0;
    }

    @Override
    public CharSequence infoAppend(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(200);
        }
        stringBuilder.append(this.name).append(':');
        this.stateTop.infoAppend(stringBuilder);
        stringBuilder.append("; ");
        if (this.theThread != null) {
            this.theThread.infoAppend(stringBuilder);
        }
        return stringBuilder;
    }

    @Override
    public void close() throws IOException {
        this.theThread.close();
    }

    public String toString() {
        return this.infoAppend(null).toString();
    }

    protected static class StateCompositeTop
    extends StateComposite {
        StateCompositeTop(StateMachine stateMachine, StateSimple[] stateSimpleArray) {
            super("top", stateMachine, stateSimpleArray);
        }

        public void prepare() {
            this.buildStatePathSubstates(null, 0);
            this.prepareTransitionsSubstate(0);
        }
    }
}

