/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.msgDispatch;

import java.io.IOException;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.ExcUtil;

public abstract class LogMessageBase
implements LogMessage {
    public static final String version = "2023-03-15";
    public int nLogLevel = 1;

    @Override
    public void writef(String string, Object ... objectArray) {
        try {
            if (objectArray != null && objectArray.length > 0) {
                this.writeInfo(String.format(string, objectArray));
            } else {
                this.writeInfo(string);
            }
            this.flush();
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION writef: " + string + " exc: " + exception.getMessage());
        }
    }

    @Override
    public void writeInfo(String string, Object ... objectArray) {
        try {
            String string2 = string.charAt(0) != '\n' ? "\n" + string : string;
            this.writeInfo(String.format(string2, objectArray));
            this.flush();
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION writeInfo: " + string + " exc: " + exception.getMessage());
        }
    }

    @Override
    public void writeInfoAdd(String string, Object ... objectArray) {
        try {
            this.writeInfo(String.format(string, objectArray));
            this.flush();
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION writeInfoAdd: " + string + " exc: " + exception.getMessage());
        }
    }

    @Override
    public void writeWarning(String string, Object ... objectArray) {
        try {
            String string2 = string.charAt(0) != '\n' ? "\n" + string : string;
            this.append(String.format(string2, objectArray));
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION writeWarning: " + string + " exc: " + exception.getMessage());
        }
    }

    @Override
    public void writeWarningAdd(String string, Object ... objectArray) {
        try {
            this.append(String.format("\n" + string, objectArray));
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION writeWarningAdd: " + string + " exc: " + exception.getMessage());
        }
    }

    @Override
    public void writeError(String string, Object ... objectArray) {
        try {
            if (string.charAt(0) != '\n') {
                this.append('\n');
            }
            this.append(String.format(string, objectArray));
        }
        catch (IOException iOException) {
            System.err.println("EXCEPTION writeError: " + string + " exc: " + iOException.getMessage());
        }
    }

    @Override
    public void writeErrorAdd(String string, Object ... objectArray) {
        try {
            this.append(String.format(string, objectArray));
        }
        catch (IOException iOException) {
            System.err.println("EXCEPTION writeErrorAdd: " + string + " exc: " + iOException.getMessage());
        }
    }

    @Override
    public void writeError(CharSequence charSequence) {
        try {
            this.append(charSequence).append('\n');
        }
        catch (IOException iOException) {
            System.err.println(charSequence);
        }
    }

    @Override
    public void writeInfoln(CharSequence charSequence) {
        try {
            this.append(charSequence).append('\n');
        }
        catch (IOException iOException) {
            System.out.println(charSequence);
        }
    }

    @Override
    public void writeInfo(CharSequence charSequence) {
        try {
            this.append(charSequence);
        }
        catch (IOException iOException) {
            System.out.append(charSequence);
        }
    }

    @Override
    public void writeWarning(CharSequence charSequence) {
        try {
            this.append("Warning: ").append(charSequence).append('\n');
        }
        catch (IOException iOException) {
            System.err.println("Error: " + charSequence);
        }
    }

    @Override
    public void writeError(String string, Throwable throwable) {
        CharSequence charSequence = ExcUtil.exceptionInfo(string, throwable, 0, 10);
        this.writeError(charSequence);
    }

    @Override
    public void report(int n, CharSequence charSequence) {
    }

    @Override
    public void reportln(int n, int n2, CharSequence charSequence) {
    }

    @Override
    public void reportln(int n, CharSequence charSequence) {
    }

    @Override
    public void report(CharSequence charSequence, Throwable throwable) {
    }

    @Override
    public int setReportLevel(int n) {
        int n2 = this.nLogLevel;
        this.nLogLevel = n;
        return n2;
    }

    @Override
    public int getReportLevel() {
        return this.nLogLevel;
    }

    @Override
    public void flushReport() {
        this.flush();
    }

    @Override
    public void setReportLevelToIdent(int n, int n2) {
    }

    @Override
    public int getReportLevelFromIdent(int n) {
        return 0;
    }
}

