/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.mainCmd;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.vishia.bridgeC.OS_TimeStamp;
import org.vishia.bridgeC.Va_list;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.Assert;
import org.vishia.util.Writer_Appendable;

public class MainCmdLoggingStream
implements MainCmdLogging_ifc {
    public static final String sVersion = "2015-07-19";
    protected OutputStream out;
    protected final Appendable app;
    private final StringBuilder u = new StringBuilder();
    private final SimpleDateFormat dateFormat;
    private static String sLeft = "                                                                ";
    private PrintWriter printWriter;
    private PrintStream printStream;
    int reportLevel = 3;

    public MainCmdLoggingStream(OutputStream outputStream) {
        this.out = outputStream;
        this.app = null;
        this.dateFormat = new SimpleDateFormat("MMM-dd HH:mm:ss.SSS: ");
    }

    public MainCmdLoggingStream(OutputStream outputStream, int n) {
        this.out = outputStream;
        this.app = null;
        this.dateFormat = new SimpleDateFormat("MMM-dd HH:mm:ss.SSS: ");
        this.reportLevel = n;
    }

    public MainCmdLoggingStream(String string, Appendable appendable) {
        this.dateFormat = new SimpleDateFormat(string);
        this.out = null;
        this.app = appendable;
    }

    public MainCmdLoggingStream(String string, Appendable appendable, int n) {
        this.dateFormat = new SimpleDateFormat(string);
        this.out = null;
        this.app = appendable;
        this.reportLevel = n;
    }

    @Override
    public void flushReport() {
        this.flush();
    }

    @Override
    public int getExitErrorLevel() {
        return 0;
    }

    @Override
    public int getReportLevel() {
        return this.reportLevel;
    }

    @Override
    public int getReportLevelFromIdent(int n) {
        return n <= 6 ? n : 3;
    }

    @Override
    public void openReportfile(String string, boolean bl) throws FileNotFoundException {
        this.out = new FileOutputStream(string);
    }

    @Override
    public void report(int n, CharSequence charSequence) {
        if ((n & 7) <= this.reportLevel) {
            this.u.append(charSequence);
        }
    }

    void writeBuffer() {
        try {
            if (this.out != null) {
                this.out.write(this.u.toString().getBytes());
            } else if (this.app != null) {
                this.app.append(this.u);
            }
        }
        catch (IOException iOException) {
            System.err.println("MainCmdLoggingStream - IOException;");
        }
        this.u.setLength(0);
    }

    void writeln(int n, int n2, CharSequence charSequence) {
        if (this.u.length() > 0) {
            for (int i = 0; i < this.u.length(); ++i) {
                if (this.u.charAt(i) >= ' ') continue;
                this.u.setCharAt(i, '|');
            }
            this.u.append("\n");
            this.writeBuffer();
        }
        this.u.append(this.dateFormat.format(new Date(System.currentTimeMillis())));
        this.u.append(n).append(": ").append(sLeft.subSequence(0, n2)).append(charSequence);
    }

    @Override
    public void report(CharSequence charSequence, Throwable throwable) {
        CharSequence charSequence2 = Assert.exceptionInfo(charSequence, throwable, 0, 20);
        this.writeln(1, 0, charSequence2);
    }

    @Override
    public void reportln(int n, int n2, CharSequence charSequence) {
        if ((n & 7) <= this.reportLevel) {
            this.writeln(n, n2, charSequence);
        }
    }

    @Override
    public void reportln(int n, CharSequence charSequence) {
        this.reportln(n, 0, charSequence);
    }

    @Override
    public void setExitErrorLevel(int n) {
    }

    @Override
    public void setOutputChannels(Appendable appendable, Appendable appendable2) {
    }

    @Override
    public void setReportLevelToIdent(int n, int n2) {
    }

    @Override
    public int setReportLevel(int n) {
        return 6;
    }

    @Override
    public void writeError(CharSequence charSequence) {
        this.reportln(1, charSequence);
    }

    @Override
    public void writeInfo(String string, Object ... objectArray) {
        this.report(3, "\n" + String.format(string, objectArray));
    }

    @Override
    public void writef(String string, Object ... objectArray) {
        this.report(3, String.format(string, objectArray));
    }

    @Override
    public void writeInfoAdd(String string, Object ... objectArray) {
        this.report(3, String.format(string, objectArray));
    }

    @Override
    public void writeWarning(String string, Object ... objectArray) {
        this.report(2, "\n" + String.format(string, objectArray));
    }

    @Override
    public void writeWarningAdd(String string, Object ... objectArray) {
        this.report(2, String.format(string, objectArray));
    }

    @Override
    public void writeError(String string, Object ... objectArray) {
        this.report(1, "\n" + String.format(string, objectArray));
    }

    @Override
    public void writeErrorAdd(String string, Object ... objectArray) {
        this.report(1, String.format(string, objectArray));
    }

    @Override
    public void writeError(String string, Throwable throwable) {
        this.report(string, throwable);
    }

    @Override
    public void writeInfo(CharSequence charSequence) {
        this.report(3, charSequence);
    }

    @Override
    public void writeInfoln(CharSequence charSequence) {
        this.reportln(3, charSequence);
    }

    @Override
    public void writeStackTrace(Exception exception) {
        if (this.out != null) {
            if (this.printStream == null) {
                this.printStream = new PrintStream(this.out, true);
            }
            exception.printStackTrace(this.printStream);
        } else if (this.app != null) {
            if (this.printWriter == null) {
                this.printWriter = new PrintWriter((Writer)new Writer_Appendable(this.app), true);
            }
            exception.printStackTrace(this.printWriter);
        }
    }

    @Override
    public void writeWarning(CharSequence charSequence) {
        this.reportln(2, charSequence);
    }

    @Override
    public void close() {
        if (this.u.length() > 0) {
            this.u.append("\n");
            this.writeBuffer();
        }
    }

    @Override
    public void flush() {
        if (this.u.length() > 0) {
            this.writeBuffer();
        }
        try {
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isOnline() {
        return this.out != null || this.app != null;
    }

    @Override
    public boolean sendMsg(int n, CharSequence charSequence, Object ... objectArray) {
        return this.sendMsgTime(n, new OS_TimeStamp(System.currentTimeMillis()), charSequence, objectArray);
    }

    @Override
    public boolean sendMsgTime(int n, OS_TimeStamp oS_TimeStamp, CharSequence charSequence, Object ... objectArray) {
        String string = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + String.format(charSequence.toString(), objectArray);
        try {
            if (this.out != null) {
                this.out.write(string.getBytes());
                this.out.write(10);
            } else if (this.app != null) {
                this.app.append(string).append('\n');
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean sendMsgVaList(int n, OS_TimeStamp oS_TimeStamp, CharSequence charSequence, Va_list va_list) {
        String string = "?";
        try {
            string = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + String.format(charSequence.toString(), va_list.get());
        }
        catch (Exception exception) {
            string = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + charSequence;
        }
        try {
            if (this.out != null) {
                this.out.write(string.getBytes());
                this.out.write(10);
            } else if (this.app != null) {
                this.app.append(string).append('\n');
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public Appendable append(CharSequence charSequence) throws IOException {
        this.sendMsg(0, charSequence.toString(), new Object[0]);
        return this;
    }

    @Override
    public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
        this.sendMsg(0, charSequence.subSequence(n, n2).toString(), new Object[0]);
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        String string = "" + c;
        this.sendMsg(0, string, new Object[0]);
        return this;
    }
}

