/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.header2Reflection;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.byteData.ByteDataAccessSimple;
import org.vishia.byteData.Class_Jc;
import org.vishia.byteData.Field_Jc;
import org.vishia.byteData.ObjectArray_Jc;
import org.vishia.byteData.Object_Jc;
import org.vishia.byteData.SuperclassIfc_idxMtblJc_ByteDataAccess;
import org.vishia.header2Reflection.ExtReflection_Insp_h;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;

public class BinOutShow {
    final byte[] binRefl;
    final int zBinRefl;
    private final ByteDataAccessSimple binOutRefl = new ByteDataAccessSimple(false);
    private final ExtReflection_Insp_h.ExtReflection_Insp binOutHead = new ExtReflection_Insp_h.ExtReflection_Insp();
    private final ObjectArray_Jc binOutClassArray = new ObjectArray_Jc();
    private final Class_Jc binClass = new Class_Jc();
    private final ObjectArray_Jc binSuperClassArray = new ObjectArray_Jc();
    private final SuperclassIfc_idxMtblJc_ByteDataAccess binSuperClass = new SuperclassIfc_idxMtblJc_ByteDataAccess();
    private final ObjectArray_Jc binFieldArray = new ObjectArray_Jc();
    private final Field_Jc binField = new Field_Jc();
    int posClassArray;
    int posRefl;
    private Map<Integer, Boolean> usedReloc = new TreeMap<Integer, Boolean>();

    BinOutShow(byte[] byArray, int n) {
        this.binRefl = byArray;
        this.zBinRefl = n;
    }

    public void show(File file) {
        this.binOutHead.assign(this.binRefl, this.zBinRefl);
        this.posClassArray = this.binOutHead.get_arrayClasses();
        this.posRefl = this.binOutHead.get_classDataBlock();
        this.binOutClassArray.assign(this.binRefl, this.posRefl - this.posClassArray, this.posClassArray);
        this.binOutRefl.assign(this.binRefl, this.zBinRefl - this.posRefl, this.posRefl);
        this.listContent(file);
    }

    private void listContent(File file) {
        block7: {
            StringBuilder stringBuilder = new StringBuilder(200);
            PrintStream printStream = null;
            try {
                printStream = new PrintStream(new FileOutputStream(file));
            }
            catch (Exception exception) {
                System.err.println("error cannot create " + file);
            }
            try {
                if (printStream != null) {
                    int n;
                    int n2;
                    int n3 = this.binOutHead.getLengthTotal();
                    int n4 = this.binOutClassArray.getLengthTotal();
                    int n5 = this.binOutRefl.getLengthTotal();
                    printStream.printf("Listing of structure of the ", new Object[0]).printf(file.getAbsolutePath(), new Object[0]).printf("\n", new Object[0]);
                    printStream.printf("The bin file consists of 3 parts:\n", new Object[0]);
                    printStream.printf("@0x000000: Table of relocate positions, addresses which should be corrected. \n", new Object[0]);
                    printStream.printf("@0x%06x: ObjectArrayJc with references to all ClassJc in this file\n", this.posClassArray);
                    printStream.printf("@0x%06x: ClassJc, FieldJc instances. \n", this.posRefl);
                    printStream.printf("@0x%06x: -length. \n", this.zBinRefl);
                    int n6 = this.binOutHead.get_nrofRelocEntries();
                    int n7 = this.binOutHead.getLengthHead();
                    printStream.printf("Re-allocation @%04x: nrof=%d \n", n7, n6);
                    for (n2 = 0; n2 < n6; ++n2) {
                        n = this.binOutHead.get_relocateAddr(n2);
                        this.usedReloc.put(n, false);
                        printStream.printf("%06x ", n);
                        if ((n2 & 7) != 7) continue;
                        printStream.printf("\n", new Object[0]);
                    }
                    printStream.printf("\n\n==@0x%06x: ObjectArrayJc arrayClasses:\n", this.posClassArray);
                    stringBuilder.setLength(0);
                    printStream.printf(this.binOutClassArray.showContent(stringBuilder), new Object[0]);
                    n2 = this.binOutClassArray.getLength_ArrayJc();
                    for (n = 0; n < n2; ++n) {
                        int n8 = this.binOutClassArray.getIntVal(4 * n + 24, 4);
                        printStream.printf("\n ClassJc [0x%06x]  @0x%06x", n8, n8 + this.posRefl);
                    }
                    this.listRefl(printStream, n3 + n4);
                    printStream.close();
                    printStream = null;
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                if (printStream == null) break block7;
                printStream.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listRefl(PrintStream printStream, int n) {
        printStream.printf("\n\n==@0x%06x: Reflection data:\n", this.posRefl);
        Object_Jc object_Jc = new Object_Jc();
        try {
            block7: while (this.binOutRefl.sufficingBytesForNextChild(object_Jc.getLengthHead())) {
                this.binOutRefl.addChild(object_Jc);
                int n2 = object_Jc.getIdent();
                switch (n2) {
                    case 4092: {
                        this.showClass(printStream, object_Jc);
                        continue block7;
                    }
                    case 4085: {
                        this.showFields(printStream, object_Jc);
                        continue block7;
                    }
                    case 4090: {
                        this.showSuper(printStream, object_Jc);
                        continue block7;
                    }
                }
                this.showUnknown(printStream, object_Jc);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
        }
        Debugutil.stop();
    }

    private void showClass(PrintStream printStream, Object_Jc object_Jc) {
        this.binClass.assignDataUpcast(object_Jc);
        int n = this.binClass.getPositionInBuffer();
        printStream.printf("\n\n==@0x%06x %s size=0x%4x (ClassJc 0x%06x): \n", n, this.binClass.getName(), object_Jc.getSizeObject(), n - this.posRefl);
        printStream.printf(" -name=", new Object[0]);
        printStream.printf(this.binClass.getName(), new Object[0]);
        int n2 = this.binClass.getFieldsAddr();
        int n3 = this.binClass.getSuperAddr();
        printStream.printf("\n -fields", new Object[0]);
        this.checkPrintReference(printStream, n + 56, n2);
        printStream.printf("\n -super", new Object[0]);
        this.checkPrintReference(printStream, n + 64, n3);
    }

    void checkPrintReference(PrintStream printStream, int n, int n2) {
        int n3 = n2 == 0 ? 0 : n2 + n - this.posRefl;
        int n4 = n - this.posRefl;
        Boolean bl = this.usedReloc.get(n4);
        printStream.printf(" @0x%06x =0x%06x =^ @0x%06x", n4, n2 & 0xFFFFFF, n3);
        if (bl != null) {
            printStream.printf(" ok", new Object[0]);
            this.usedReloc.put(n4, true);
        }
    }

    private void showFields(PrintStream printStream, Object_Jc object_Jc) {
        this.binFieldArray.assignDataUpcast(object_Jc);
        int n = this.binFieldArray.getSizeObject();
        int n2 = this.binFieldArray.getLength_ArrayJc();
        int n3 = object_Jc.getPositionInBuffer();
        printStream.printf("\n\n  @0x%06x + 0x%4x: FieldArrayJc[%d] (0x%06x):", n3, n, n2, n3 - this.posRefl);
        if (n != n2 * 48 + this.binFieldArray.getLengthHead()) {
            printStream.printf(" - faulty size vs. nrofFields", new Object[0]);
        }
        while (this.binFieldArray.sufficingBytesForNextChild(48)) {
            this.binFieldArray.addChild(this.binField);
            int n4 = this.binField.getPositionInBuffer();
            int n5 = this.binField.getType();
            printStream.printf("\n  @0x%06x: %s : at %04x type=0x%08x", n4, this.binField.getName(), this.binField.getPosValue(), n5);
            int n6 = this.binField.getModifiers();
            if ((n6 & Field_Jc.EModifier.mPrimitiv_Modifier.e) != 0) continue;
            this.checkPrintReference(printStream, this.binField.getPositionInBuffer_type(), n5);
        }
    }

    private void showSuper(PrintStream printStream, Object_Jc object_Jc) {
        this.binSuperClassArray.assignDataUpcast(object_Jc);
        int n = this.binSuperClassArray.getSizeObject();
        int n2 = this.binSuperClassArray.getLength_ArrayJc();
        int n3 = object_Jc.getPositionInBuffer();
        printStream.printf("\n\n==@0x%06x + 0x%4x: SuperArrayJc[%d] (0x%06x):\n", n3, n, n2, n3);
        if (n != n2 * 56 + this.binSuperClassArray.getLengthHead()) {
            printStream.printf(" - faulty size vs. nrofFields\n", new Object[0]);
        }
        while (this.binSuperClassArray.sufficingBytesForNextChild(56)) {
            this.binSuperClassArray.addChild(this.binSuperClass);
            this.binSuperClass.addInnerChildren();
            int n4 = this.binSuperClass.field_access.getType();
            printStream.printf("\n + %s : at %d", this.binSuperClass.field_access.getName(), this.binSuperClass.field_access.getPosValue());
            this.checkPrintReference(printStream, this.binSuperClass.field_access.getPositionInBuffer_type(), n4);
        }
    }

    private void showUnknown(PrintStream printStream, Object_Jc object_Jc) {
        printStream.printf("\n\n==@0x%06x: unknown ObjectJc:\n", this.posRefl + object_Jc.getPositionInBuffer());
    }

    public static void main(String[] stringArray) {
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[0] + ".lst");
        byte[] byArray = FileSystem.readBinFile(file);
        BinOutShow binOutShow = new BinOutShow(byArray, byArray.length);
        binOutShow.show(file2);
    }
}

