/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.checkDeps_C;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import org.vishia.checkDeps_C.CfgData;
import org.vishia.checkDeps_C.CheckData;
import org.vishia.checkDeps_C.CheckDependencyFile;
import org.vishia.checkDeps_C.InfoFileDependencies;
import org.vishia.checkDeps_C.InputSrc;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.Report;
import org.vishia.util.FileFunctions;
import org.vishia.util.FileSystem;

public class CheckDeps_Old {
    public static final int version = 20121225;
    List<File> listFilesSrcAll = new LinkedList<File>();
    final CfgData cfgData;
    final CheckData checkData;
    private final Args args;
    private final Report console;
    final CheckDependencyFile checkerDependencyFile;

    public CheckDeps_Old(Report report, Args args) {
        this.console = report;
        this.args = args;
        this.checkerDependencyFile = new CheckDependencyFile(report, false);
        this.checkData = this.checkerDependencyFile.checkData;
        this.cfgData = this.checkerDependencyFile.cfgData;
    }

    public static void main(String[] stringArray) {
        Args args = new Args();
        Cmdline cmdline = new Cmdline(args);
        cmdline.writeInfoln("CheckDeps 2012-12-30 - checks and builds Dependencies, deletes Objects");
        try {
            cmdline.parseArguments(stringArray);
        }
        catch (ParseException parseException) {
            cmdline.writeError("cmd line arguments: ", parseException);
        }
        CheckDeps_Old checkDeps_Old = new CheckDeps_Old(cmdline, args);
        try {
            checkDeps_Old.execute();
        }
        catch (Exception exception) {
            cmdline.writeError("Any execution error; ", exception);
        }
    }

    private void execute() {
        String string = null;
        if (this.args.sPathSrcMirrorRoot != null && (string = this.checkerDependencyFile.setDirSrcMirror(this.args.sPathSrcMirrorRoot)) != null) {
            throw new IllegalArgumentException(string);
        }
        if (this.args.sPathObj != null && (string = this.checkerDependencyFile.setDirSrcMirror(this.args.sPathObj)) != null) {
            throw new IllegalArgumentException(string);
        }
        File file = new File(".");
        string = this.checkerDependencyFile.readCfgData(this.args.sFileCfg, file);
        if (string != null) {
            throw new IllegalArgumentException(string);
        }
        string = this.checkerDependencyFile.readDependencies(this.args.sFileDep);
        if (string != null) {
            throw new IllegalArgumentException(string);
        }
        for (String object : this.args.pathsSrcGen) {
            InputSrc inputSrc = new InputSrc(object, file);
            this.cfgData.listProcessPaths.add(inputSrc);
            this.cfgData.listSourcePaths.add(inputSrc);
        }
        for (InputSrc inputSrc : this.cfgData.listProcessPaths) {
            int n = this.gatherSrcFiles(inputSrc);
            this.console.reportln(3, "source file path; " + inputSrc.sCanonicalPathSrc + "; nrof files=" + n);
        }
        try {
            this.processSrcTree();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        InfoFileDependencies.writeAllBackDeps(this.args.sFileDep, this.checkData.indexAllInclFilesAbsPath);
        if (this.args.evalDeps) {
            // empty if block
        }
        this.console.reportln(3, "cmdAndCpy - srcFiles= " + this.checkData.nrofSrcFiles + ", newDeps= " + this.checkData.nrofNewDeps + ", changedFiles= " + this.checkData.nrofChangedFiles + ", del-obj= " + this.checkData.nrofDelObj + ", re-compile= " + this.checkData.nrofRecompilings + ", newFiles= " + this.checkData.nrofNewFiles + ", extInclFiles= " + this.checkData.nrofExtInclFiles);
        this.console.reportln(3, "");
    }

    private int gatherSrcFiles(InputSrc inputSrc) {
        LinkedList<File> linkedList = new LinkedList<File>();
        try {
            FileSystem.addFileToList(inputSrc.dirSrcBase, "**/*.cpp", linkedList);
            FileSystem.addFileToList(inputSrc.dirSrcBase, "**/*.c", linkedList);
            FileSystem.addFileToList(inputSrc.dirSrcBase, "**/*.C", linkedList);
            FileSystem.addFileToList(inputSrc.dirSrcBase, "**/*.s", linkedList);
            FileSystem.addFileToList(inputSrc.dirSrcBase, "**/*.S", linkedList);
            this.listFilesSrcAll.addAll(linkedList);
        }
        catch (Exception exception) {
            this.console.writeError("File not found", exception);
        }
        if (this.console.getReportLevel() >= 5) {
            for (File file : this.listFilesSrcAll) {
                String string = file.getAbsolutePath();
                this.console.reportln(5, "gather source file; " + string);
            }
        }
        return linkedList.size();
    }

    private void processSrcTree() throws FileNotFoundException {
        for (File file : this.listFilesSrcAll) {
            InfoFileDependencies infoFileDependencies;
            ++this.checkData.nrofSrcFiles;
            String string = FileFunctions.normalizePath(file).toString();
            this.console.reportln(5, "CheckDeps - check source file; " + string);
            if (string.contains("ObjectJc.h")) {
                this.stop();
            }
            if ((infoFileDependencies = this.checkData.indexSrcFilesAbs.get(string)) != null) {
                this.console.report(5, " : is processed already.");
                continue;
            }
            String string2 = this.cfgData.checkIsInSourcePool(string);
            if (string2 == null) {
                this.console.reportln(1, "CheckDeps - error check source file - sLocalPathName not found in config; " + string);
                continue;
            }
            infoFileDependencies = this.checkerDependencyFile.processSrcfile(file, string2, this.args.sObjExt);
        }
    }

    void stop() {
    }

    private static class Cmdline
    extends MainCmd {
        private final Args args;

        @Override
        public boolean checkArguments() {
            boolean bl = true;
            if (this.args.sFileCfg == null) {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean testArgument(String string, int n) {
            boolean bl = true;
            if (string.startsWith("-src=")) {
                this.args.pathsSrcGen.add(this.getArgument(5));
            } else if (string.startsWith("-srcBuild=")) {
                this.args.sPathSrcMirrorRoot = this.getArgument(10);
            } else if (string.startsWith("-srcMirrorRoot=")) {
                this.args.sPathSrcMirrorRoot = this.getArgument(15);
            } else if (string.startsWith("-obj=")) {
                String string2 = this.getArgument(5);
                int n2 = string2.indexOf("*");
                if (n2 < 0) {
                    this.writeError("argument -obj should contain a *: Syntay -obj=path/*.ext");
                    bl = false;
                } else {
                    this.args.sPathObj = string2.substring(0, n2);
                    this.args.sObjExt = string2.substring(n2 + 1);
                }
            } else if (string.startsWith("-cfg=")) {
                this.args.sFileCfg = this.getArgument(5);
            } else if (string.startsWith("-cfg:")) {
                this.args.sFileCfg = this.getArgument(5);
            } else if (string.startsWith("-depAll=")) {
                this.args.sFileDep = this.getArgument(8);
            } else if (string.startsWith("-depAll:")) {
                this.args.sFileDep = this.getArgument(8);
            } else if (string.startsWith("cmpAndCpy")) {
                this.args.cmpAndCpy = true;
            } else if (string.startsWith("evalDeps")) {
                this.args.evalDeps = true;
            } else if (string.startsWith("-lastPath=")) {
                this.args.sPathLast = this.getArgument(10);
            } else if (string.startsWith("-lastPath:")) {
                this.args.sPathLast = this.getArgument(10);
            } else if (string.startsWith("-testDummyObj")) {
                this.args.testDummyObj = true;
            } else {
                bl = false;
            }
            return bl;
        }

        Cmdline(Args args) {
            this.args = args;
        }
    }

    public static class Args {
        public String sFileCfg;
        public List<String> pathsSrcGen = new LinkedList<String>();
        public String sPathSrcMirrorRoot;
        public String sPathObj;
        public String sObjExt;
        public String sFileDep;
        public boolean cmpAndCpy;
        public boolean evalDeps;
        public String sPathLast;
        public boolean testDummyObj;
    }
}

